/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.caespToCtmBridgeBuilder;

import com.bmc.caespToCtmBridgeBuilder.ActionItemsHandler;
import com.bmc.caespToCtmBridgeBuilder.BridgeRecord;
import com.bmc.caespToCtmBridgeBuilder.ChangeActionItem;
import com.bmc.caespToCtmBridgeBuilder.ConditionPrefixesHandler;
import com.bmc.caespToCtmBridgeBuilder.Constants;
import com.bmc.caespToCtmBridgeBuilder.CtoRulesHandler;
import com.bmc.caespToCtmBridgeBuilder.ESPBridgeTypeMapper;
import com.bmc.caespToCtmBridgeBuilder.IBridgeHandler;
import java.io.IOException;

public class ESPToCtmBridge
implements IBridgeHandler {
    private CtoRulesHandler ctoRulesCreator;
    private ActionItemsHandler actionItemsHandler;
    private ESPBridgeTypeMapper mapper;

    public ESPToCtmBridge(CtoRulesHandler ctoRulesCreator, ActionItemsHandler actionItemsHandler, ConditionPrefixesHandler conditionPrefixesHandler) throws IOException {
        this.ctoRulesCreator = ctoRulesCreator;
        this.actionItemsHandler = actionItemsHandler;
        this.mapper = new ESPBridgeTypeMapper(conditionPrefixesHandler);
    }

    @Override
    public void handleRecord(BridgeRecord record) {
        String ctmJob = record.getCtmJob();
        Constants.BridgeType bridgeType = record.getType();
        String existingConditionName = this.mapper.getExistConditonPrefix(bridgeType) + record.getVendorJob() + "-" + record.getCtmJob();
        String desiredConditionName = this.mapper.getDesiredConditonPrefix(bridgeType) + existingConditionName;
        String identifierMessage = this.mapper.getIdentifier(bridgeType);
        this.ctoRulesCreator.addRule(identifierMessage, ctmJob, desiredConditionName);
        ChangeActionItem change = new ChangeActionItem(record.getCtmPath(), Constants.ChangeType.InCondition, existingConditionName, desiredConditionName);
        this.actionItemsHandler.addActionItem(change);
    }
}

