/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.caespToCtmBridgeBuilder;

import com.bmc.caespToCtmBridgeBuilder.BridgeException;
import com.bmc.ctmconvert.common.log.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class CtoRulesHandler {
    private String ctoRuleTemplate;
    private List<String> ctoRulesList = new ArrayList<String>();

    public CtoRulesHandler(InputStream ctoRuleTemplateStream) throws BridgeException {
        BufferedReader templateBufferReader = new BufferedReader(new InputStreamReader(ctoRuleTemplateStream));
        try {
            this.ctoRuleTemplate = IOUtils.toString((Reader)templateBufferReader);
        }
        catch (IOException e) {
            Logger.getLogger().writeToLog((Exception)e);
            throw new BridgeException("Failed to read the CTO Rule Template");
        }
    }

    public void addRule(String message, String triggerJob, String conditionToAdd) {
        String ctoRule = this.ctoRuleTemplate;
        ctoRule = ctoRule.replace("@MSG_ID@", message);
        ctoRule = ctoRule.replace("@ESP_JOBNAME@", triggerJob);
        ctoRule = ctoRule.replace("@CONDITION_FORMAT@", conditionToAdd);
        String ctoRule80 = CtoRulesHandler.expandEachLineTo80(ctoRule);
        this.ctoRulesList.add(ctoRule80);
    }

    public static String expandEachLineTo80(String ctoRule) {
        Object eachLine80 = "";
        BufferedReader bufReader = new BufferedReader(new StringReader(ctoRule));
        String line = null;
        try {
            while ((line = bufReader.readLine()) != null) {
                eachLine80 = (String)eachLine80 + StringUtils.rightPad((String)line, (int)80, (String)" ") + "\r\n";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return eachLine80;
    }

    public List<String> getCtoRulesList() {
        return this.ctoRulesList;
    }
}

