/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.caespToCtmBridgeBuilder;

import com.bmc.caespToCtmBridgeBuilder.ActionItemsHandler;
import com.bmc.caespToCtmBridgeBuilder.BridgeJobParameters;
import com.bmc.caespToCtmBridgeBuilder.BridgeRecord;
import com.bmc.caespToCtmBridgeBuilder.ChangeActionItem;
import com.bmc.caespToCtmBridgeBuilder.ConditionPrefixesHandler;
import com.bmc.caespToCtmBridgeBuilder.Constants;
import com.bmc.caespToCtmBridgeBuilder.IBridgeHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CtmToEspBridge
implements IBridgeHandler {
    private ActionItemsHandler actionItemsHandler;
    private List<BridgeJobParameters> jobsParameterslist;
    protected Map<Constants.BridgeType, String> bridgeTypeToCondtionPrefixMap;

    public CtmToEspBridge(ActionItemsHandler actionItemsHandler, ConditionPrefixesHandler conditionPrefixesHandler) {
        Map<Constants.BridgeType, String> bridgeType2PrefixMap = conditionPrefixesHandler.getBridgeType2PrefixMap();
        String globalConditionPrefix = conditionPrefixesHandler.getGlobalConditionPrefix();
        this.jobsParameterslist = new ArrayList<BridgeJobParameters>();
        this.actionItemsHandler = actionItemsHandler;
        this.bridgeTypeToCondtionPrefixMap = new HashMap<Constants.BridgeType, String>();
        this.bridgeTypeToCondtionPrefixMap.put(Constants.BridgeType.CTMDS_ESPDS, globalConditionPrefix + bridgeType2PrefixMap.get((Object)Constants.BridgeType.CTMDS_ESPDS));
        this.bridgeTypeToCondtionPrefixMap.put(Constants.BridgeType.CTMDS_ESPMF, globalConditionPrefix);
        this.bridgeTypeToCondtionPrefixMap.put(Constants.BridgeType.CTMMF_ESPDS, globalConditionPrefix);
        this.bridgeTypeToCondtionPrefixMap.put(Constants.BridgeType.CTMMF_ESPMF, "");
    }

    @Override
    public void handleRecord(BridgeRecord record) {
        Constants.BridgeType bridgeType = record.getType();
        String ctmJob = record.getCtmJob();
        String vendorJob = record.getVendorJob();
        String conditionName = this.bridgeTypeToCondtionPrefixMap.get((Object)bridgeType) + ctmJob + "-" + vendorJob;
        BridgeJobParameters parameters = new BridgeJobParameters(ctmJob, vendorJob, record.getCtmFolder(), conditionName);
        this.jobsParameterslist.add(parameters);
        if (bridgeType.equals((Object)Constants.BridgeType.CTMDS_ESPDS)) {
            this.addActionItem(record);
        }
    }

    private void addActionItem(BridgeRecord record) {
        String actualConditionName = record.getCtmJob() + "-" + record.getVendorJob();
        String desiredConditionName = this.bridgeTypeToCondtionPrefixMap.get((Object)record.getType()) + actualConditionName;
        ChangeActionItem actionItem = new ChangeActionItem(record.getCtmPath(), Constants.ChangeType.OutCondition, actualConditionName, desiredConditionName);
        this.actionItemsHandler.addActionItem(actionItem);
    }

    public List<BridgeJobParameters> getJobsParametersList() {
        return new ArrayList<BridgeJobParameters>(this.jobsParameterslist);
    }
}

