/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.caespToCtmBridgeBuilder;

import com.bmc.caespToCtmBridgeBuilder.ArgumentsParser;
import com.bmc.caespToCtmBridgeBuilder.BridgeException;
import com.bmc.caespToCtmBridgeBuilder.BridgeResultsWriter;
import com.bmc.caespToCtmBridgeBuilder.BridgeStreamRepository;
import com.bmc.caespToCtmBridgeBuilder.BridgesBuilder;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.log.Logger;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;

public class BridgeBuilderRunner {
    private FileSystem fileSystem;
    private BridgeStreamRepository bridgeStreamRepository = null;

    public BridgeBuilderRunner(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public BridgeBuilderRunner() {
        this.fileSystem = FileSystems.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        ArgumentsParser argumetParser = new ArgumentsParser();
        try {
            System.out.println("Running BridgeBuilder\n");
            argumetParser.parse(args);
            this.printArgsToConsole(argumetParser);
            this.bridgeStreamRepository = new BridgeStreamRepository(argumetParser, this.fileSystem);
            BridgesBuilder bridgesBuilder = new BridgesBuilder(this.bridgeStreamRepository);
            bridgesBuilder.build();
            BridgeResultsWriter bridgesResultsWriter = new BridgeResultsWriter(bridgesBuilder, this.bridgeStreamRepository);
            bridgesResultsWriter.writeReports();
            String successfullMessage = String.format("BridgeBuilder completed successfully.\r\nOutputs directory: %s", this.bridgeStreamRepository.getOutputFolder());
            System.out.println("\n" + successfullMessage);
        }
        catch (BridgeException e) {
            Logger.getLogger().writeToLog(e.getMessage());
        }
        catch (IOException e) {
            Logger logger = Logger.getLogger();
            logger.writeToLog((Exception)e);
            Object outputFolderPath = argumetParser.getOutputPath().isEmpty() ? Globs.BRIDGE_BUILDER_DIRECTORY + Globs.DIRSEP + "Output" : argumetParser.getOutputPath();
            String messageForUser = String.format("BridgeBuilder completed with errors, see log file at %s for more information.", (String)outputFolderPath + Globs.DIRSEP + "logs.txt");
            logger.writeToLog(messageForUser);
        }
        finally {
            try {
                if (this.bridgeStreamRepository != null) {
                    this.bridgeStreamRepository.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void printArgsToConsole(ArgumentsParser argumetParser) {
        System.out.println("Parameters used:");
        String argValue = "";
        argValue = argumetParser.getInputPath();
        if (!argValue.isEmpty()) {
            System.out.println("-bridgesData".substring(1) + ": " + argValue);
        }
        if ((argValue = argumetParser.getTemplateCtoPath()) != null && !argValue.isEmpty()) {
            System.out.println("-ctoTemplate".substring(1) + ": " + argValue);
        }
        if ((argValue = argumetParser.getXmlSkeletonPath()) != null && !argValue.isEmpty()) {
            System.out.println("-ctmTemplate".substring(1) + ": " + argValue);
        }
        if (!(argValue = argumetParser.getOutputPath()).isEmpty()) {
            System.out.println("-outputDirectory".substring(1) + ": " + argValue);
        }
    }
}

