/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.io;

import com.bmc.ctmconvert.io.IPrinter;
import java.io.PrintStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/bmc/ctmconvert/io/ConsolePrinter;", "Lcom/bmc/ctmconvert/io/IPrinter;", "stdout", "Ljava/io/PrintStream;", "<init>", "(Ljava/io/PrintStream;)V", "lastPrinterMessage", "", "printToCurrentLine", "", "message", "replaceCurrentLine", "", "printToNewLine", "printSafely", "lengthOfMessage", "", "splitLargeFolder"})
public final class ConsolePrinter
implements IPrinter {
    @NotNull
    private final PrintStream stdout;
    @NotNull
    private String lastPrinterMessage;

    public ConsolePrinter(@NotNull PrintStream stdout) {
        Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
        this.stdout = stdout;
        this.lastPrinterMessage = "";
    }

    public /* synthetic */ ConsolePrinter(PrintStream printStream, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            printStream = System.out;
        }
        this(printStream);
    }

    @Override
    public void printToCurrentLine(@NotNull String message, boolean replaceCurrentLine) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String messageToPrint = "\r" + this.printSafely(message);
        if (!replaceCurrentLine) {
            this.stdout.print(message);
        } else {
            this.stdout.print(messageToPrint);
        }
        this.lastPrinterMessage = messageToPrint;
    }

    @Override
    public void printToNewLine(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object messageToPrint = StringsKt.startsWith$default((String)this.lastPrinterMessage, (String)"\r", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)this.lastPrinterMessage, (String)"\n", (boolean)false, (int)2, null) ? "\r\n" + message : (((CharSequence)((Object)StringsKt.trim((CharSequence)this.lastPrinterMessage)).toString()).length() == 0 || StringsKt.endsWith$default((String)this.lastPrinterMessage, (String)"\n", (boolean)false, (int)2, null) ? message : this.printSafely(message));
        this.stdout.println((String)messageToPrint);
        this.lastPrinterMessage = (String)messageToPrint + "\r\n";
    }

    private final String printSafely(String message) {
        String string = "%-" + this.lengthOfMessage(message) + "s";
        Object[] objectArray = new Object[]{message};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final int lengthOfMessage(String message) {
        return ((CharSequence)((Object)StringsKt.trim((CharSequence)this.lastPrinterMessage)).toString()).length() == 0 ? ((Object)StringsKt.trim((CharSequence)message)).toString().length() : ((Object)StringsKt.trim((CharSequence)this.lastPrinterMessage)).toString().length();
    }

    public ConsolePrinter() {
        this(null, 1, null);
    }
}

