/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl;

import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSLConf;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.openssl.OpenSSLConf;
import org.apache.tomcat.util.net.openssl.OpenSSLEngine;
import org.apache.tomcat.util.net.openssl.OpenSSLSessionContext;
import org.apache.tomcat.util.net.openssl.OpenSSLX509Certificate;
import org.apache.tomcat.util.net.openssl.ciphers.OpenSSLCipherConfigurationParser;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLContext
implements SSLContext {
    private static final Base64 BASE64_ENCODER = new Base64(64, new byte[]{10});
    private static final Log log = LogFactory.getLog(OpenSSLContext.class);
    private static final StringManager netSm = StringManager.getManager(AbstractEndpoint.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLContext.class);
    private static final String defaultProtocol = "TLS";
    private final SSLHostConfig sslHostConfig;
    private final SSLHostConfigCertificate certificate;
    private OpenSSLSessionContext sessionContext;
    private final List<String> negotiableProtocols;
    private List<String> jsseCipherNames = new ArrayList<String>();
    private String enabledProtocol;
    private final long aprPool;
    private final AtomicInteger aprPoolDestroyed = new AtomicInteger(0);
    protected final long cctx;
    protected final long ctx;
    static final CertificateFactory X509_CERT_FACTORY;
    private static final String BEGIN_KEY = "-----BEGIN RSA PRIVATE KEY-----\n";
    private static final Object END_KEY;
    private boolean initialized = false;

    public List<String> getJsseCipherNames() {
        return this.jsseCipherNames;
    }

    public String getEnabledProtocol() {
        return this.enabledProtocol;
    }

    public void setEnabledProtocol(String protocol) {
        this.enabledProtocol = protocol == null ? defaultProtocol : protocol;
    }

    public OpenSSLContext(SSLHostConfigCertificate certificate, List<String> negotiableProtocols) throws SSLException {
        this.sslHostConfig = certificate.getSSLHostConfig();
        this.certificate = certificate;
        this.aprPool = Pool.create(0L);
        boolean success = false;
        try {
            OpenSSLConf openSslConf = this.sslHostConfig.getOpenSslConf();
            if (openSslConf != null) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug(sm.getString("openssl.makeConf"));
                    }
                    this.cctx = SSLConf.make(this.aprPool, 58);
                }
                catch (Exception e) {
                    throw new SSLException(sm.getString("openssl.errMakeConf"), e);
                }
            } else {
                this.cctx = 0L;
            }
            this.sslHostConfig.setOpenSslConfContext(this.cctx);
            int value = 0;
            for (String protocol : this.sslHostConfig.getEnabledProtocols()) {
                if ("SSLv2Hello".equalsIgnoreCase(protocol)) continue;
                if ("SSLv2".equalsIgnoreCase(protocol)) {
                    value |= 1;
                    continue;
                }
                if ("SSLv3".equalsIgnoreCase(protocol)) {
                    value |= 2;
                    continue;
                }
                if ("TLSv1".equalsIgnoreCase(protocol)) {
                    value |= 4;
                    continue;
                }
                if ("TLSv1.1".equalsIgnoreCase(protocol)) {
                    value |= 8;
                    continue;
                }
                if ("TLSv1.2".equalsIgnoreCase(protocol)) {
                    value |= 0x10;
                    continue;
                }
                if ("all".equalsIgnoreCase(protocol)) {
                    value |= 0x1C;
                    continue;
                }
                throw new Exception(netSm.getString("endpoint.apr.invalidSslProtocol", protocol));
            }
            try {
                this.ctx = org.apache.tomcat.jni.SSLContext.make(this.aprPool, value, 1);
            }
            catch (Exception e) {
                throw new Exception(netSm.getString("endpoint.apr.failSslContextMake"), e);
            }
            this.negotiableProtocols = negotiableProtocols;
            success = true;
        }
        catch (Exception e) {
            throw new SSLException(sm.getString("openssl.errorSSLCtxInit"), e);
        }
        finally {
            if (!success) {
                this.destroy();
            }
        }
    }

    @Override
    public synchronized void destroy() {
        if (this.aprPoolDestroyed.compareAndSet(0, 1)) {
            if (this.ctx != 0L) {
                org.apache.tomcat.jni.SSLContext.free(this.ctx);
            }
            if (this.cctx != 0L) {
                SSLConf.free(this.cctx);
            }
            if (this.aprPool != 0L) {
                Pool.destroy(this.aprPool);
            }
        }
    }

    @Override
    public synchronized void init(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) {
        if (this.initialized) {
            log.warn(sm.getString("openssl.doubleInit"));
            return;
        }
        try {
            OpenSSLConf openSslConf;
            if (this.sslHostConfig.getInsecureRenegotiation()) {
                org.apache.tomcat.jni.SSLContext.setOptions(this.ctx, 262144);
            } else {
                org.apache.tomcat.jni.SSLContext.clearOptions(this.ctx, 262144);
            }
            String honorCipherOrderStr = this.sslHostConfig.getHonorCipherOrder();
            if (honorCipherOrderStr != null) {
                if (Boolean.parseBoolean(honorCipherOrderStr)) {
                    org.apache.tomcat.jni.SSLContext.setOptions(this.ctx, 0x400000);
                } else {
                    org.apache.tomcat.jni.SSLContext.clearOptions(this.ctx, 0x400000);
                }
            }
            if (this.sslHostConfig.getDisableCompression()) {
                org.apache.tomcat.jni.SSLContext.setOptions(this.ctx, 131072);
            } else {
                org.apache.tomcat.jni.SSLContext.clearOptions(this.ctx, 131072);
            }
            if (this.sslHostConfig.getDisableSessionTickets()) {
                org.apache.tomcat.jni.SSLContext.setOptions(this.ctx, 16384);
            } else {
                org.apache.tomcat.jni.SSLContext.clearOptions(this.ctx, 16384);
            }
            if (this.sslHostConfig.getSessionCacheSize() > 0) {
                org.apache.tomcat.jni.SSLContext.setSessionCacheSize(this.ctx, this.sslHostConfig.getSessionCacheSize());
            } else {
                long sessionCacheSize = org.apache.tomcat.jni.SSLContext.setSessionCacheSize(this.ctx, 20480L);
                org.apache.tomcat.jni.SSLContext.setSessionCacheSize(this.ctx, sessionCacheSize);
            }
            if (this.sslHostConfig.getSessionTimeout() > 0) {
                org.apache.tomcat.jni.SSLContext.setSessionCacheTimeout(this.ctx, this.sslHostConfig.getSessionTimeout());
            } else {
                long sessionTimeout = org.apache.tomcat.jni.SSLContext.setSessionCacheTimeout(this.ctx, 300L);
                org.apache.tomcat.jni.SSLContext.setSessionCacheTimeout(this.ctx, sessionTimeout);
            }
            String opensslCipherConfig = this.sslHostConfig.getCiphers();
            this.jsseCipherNames = OpenSSLCipherConfigurationParser.parseExpression(opensslCipherConfig);
            org.apache.tomcat.jni.SSLContext.setCipherSuite(this.ctx, opensslCipherConfig);
            if (this.certificate.getCertificateFile() != null) {
                org.apache.tomcat.jni.SSLContext.setCertificate(this.ctx, SSLHostConfig.adjustRelativePath(this.certificate.getCertificateFile()), SSLHostConfig.adjustRelativePath(this.certificate.getCertificateKeyFile()), this.certificate.getCertificateKeyPassword(), 0);
                org.apache.tomcat.jni.SSLContext.setCertificateChainFile(this.ctx, SSLHostConfig.adjustRelativePath(this.certificate.getCertificateChainFile()), false);
                org.apache.tomcat.jni.SSLContext.setCARevocation(this.ctx, SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCertificateRevocationListFile()), SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCertificateRevocationListPath()));
            } else {
                X509Certificate[] chain;
                X509KeyManager keyManager = OpenSSLContext.chooseKeyManager(kms);
                String alias = this.certificate.getCertificateKeyAlias();
                if (alias == null) {
                    alias = "tomcat";
                }
                if ((chain = keyManager.getCertificateChain(alias)) == null) {
                    alias = OpenSSLContext.findAlias(keyManager, this.certificate);
                    chain = keyManager.getCertificateChain(alias);
                }
                PrivateKey key = keyManager.getPrivateKey(alias);
                StringBuilder sb = new StringBuilder(BEGIN_KEY);
                String encoded = BASE64_ENCODER.encodeToString(key.getEncoded());
                if (encoded.endsWith("\n")) {
                    encoded = encoded.substring(0, encoded.length() - 1);
                }
                sb.append(encoded);
                sb.append(END_KEY);
                org.apache.tomcat.jni.SSLContext.setCertificateRaw(this.ctx, chain[0].getEncoded(), sb.toString().getBytes(StandardCharsets.US_ASCII), 0);
                for (int i = 1; i < chain.length; ++i) {
                    org.apache.tomcat.jni.SSLContext.addChainCertificateRaw(this.ctx, chain[i].getEncoded());
                }
            }
            int value = 0;
            switch (this.sslHostConfig.getCertificateVerification()) {
                case NONE: {
                    value = 0;
                    break;
                }
                case OPTIONAL: {
                    value = 1;
                    break;
                }
                case OPTIONAL_NO_CA: {
                    value = 3;
                    break;
                }
                case REQUIRED: {
                    value = 2;
                }
            }
            org.apache.tomcat.jni.SSLContext.setVerify(this.ctx, value, this.sslHostConfig.getCertificateVerificationDepth());
            if (tms != null) {
                final X509TrustManager manager = OpenSSLContext.chooseTrustManager(tms);
                org.apache.tomcat.jni.SSLContext.setCertVerifyCallback(this.ctx, new CertificateVerifier(){

                    @Override
                    public boolean verify(long ssl, byte[][] chain, String auth) {
                        X509Certificate[] peerCerts = OpenSSLContext.certificates(chain);
                        try {
                            manager.checkClientTrusted(peerCerts, auth);
                            return true;
                        }
                        catch (Exception e) {
                            log.debug(sm.getString("openssl.certificateVerificationFailed"), e);
                            return false;
                        }
                    }
                });
                for (X509Certificate caCert : manager.getAcceptedIssuers()) {
                    org.apache.tomcat.jni.SSLContext.addClientCACertificateRaw(this.ctx, caCert.getEncoded());
                    if (!log.isDebugEnabled()) continue;
                    log.debug(sm.getString("openssl.addedClientCaCert", caCert.toString()));
                }
            } else {
                org.apache.tomcat.jni.SSLContext.setCACertificate(this.ctx, SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCaCertificateFile()), SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCaCertificatePath()));
            }
            if (this.negotiableProtocols != null && this.negotiableProtocols.size() > 0) {
                ArrayList<String> protocols = new ArrayList<String>();
                protocols.addAll(this.negotiableProtocols);
                protocols.add("http/1.1");
                String[] protocolsArray = protocols.toArray(new String[0]);
                org.apache.tomcat.jni.SSLContext.setAlpnProtos(this.ctx, protocolsArray, 0);
                org.apache.tomcat.jni.SSLContext.setNpnProtos(this.ctx, protocolsArray, 0);
            }
            if ((openSslConf = this.sslHostConfig.getOpenSslConf()) != null && this.cctx != 0L) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("openssl.checkConf"));
                }
                try {
                    if (!openSslConf.check(this.cctx)) {
                        log.error(sm.getString("openssl.errCheckConf"));
                        throw new Exception(sm.getString("openssl.errCheckConf"));
                    }
                }
                catch (Exception e) {
                    throw new Exception(sm.getString("openssl.errCheckConf"), e);
                }
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("openssl.applyConf"));
                }
                try {
                    if (!openSslConf.apply(this.cctx, this.ctx)) {
                        log.error(sm.getString("openssl.errApplyConf"));
                        throw new SSLException(sm.getString("openssl.errApplyConf"));
                    }
                }
                catch (Exception e) {
                    throw new SSLException(sm.getString("openssl.errApplyConf"), e);
                }
                int opts = org.apache.tomcat.jni.SSLContext.getOptions(this.ctx);
                ArrayList<String> enabled = new ArrayList<String>();
                enabled.add("SSLv2Hello");
                if ((opts & 0x4000000) == 0) {
                    enabled.add("TLSv1");
                }
                if ((opts & 0x10000000) == 0) {
                    enabled.add("TLSv1.1");
                }
                if ((opts & 0x8000000) == 0) {
                    enabled.add("TLSv1.2");
                }
                if ((opts & 0x1000000) == 0) {
                    enabled.add("SSLv2");
                }
                if ((opts & 0x2000000) == 0) {
                    enabled.add("SSLv3");
                }
                this.sslHostConfig.setEnabledProtocols(enabled.toArray(new String[enabled.size()]));
                this.sslHostConfig.setEnabledCiphers(org.apache.tomcat.jni.SSLContext.getCiphers(this.ctx));
            }
            this.sessionContext = new OpenSSLSessionContext(this.ctx);
            this.sessionContext.setSessionIdContext(org.apache.tomcat.jni.SSLContext.DEFAULT_SESSION_ID_CONTEXT);
            this.sslHostConfig.setOpenSslContext(this.ctx);
            this.initialized = true;
        }
        catch (Exception e) {
            log.warn(sm.getString("openssl.errorSSLCtxInit"), e);
            this.destroy();
        }
    }

    private static String findAlias(X509KeyManager keyManager, SSLHostConfigCertificate certificate) {
        SSLHostConfigCertificate.Type type = certificate.getType();
        String result = null;
        ArrayList<SSLHostConfigCertificate.Type> candidateTypes = new ArrayList<SSLHostConfigCertificate.Type>();
        if (SSLHostConfigCertificate.Type.UNDEFINED.equals((Object)type)) {
            candidateTypes.addAll(Arrays.asList(SSLHostConfigCertificate.Type.values()));
            candidateTypes.remove((Object)SSLHostConfigCertificate.Type.UNDEFINED);
        } else {
            candidateTypes.add(type);
        }
        Iterator iter = candidateTypes.iterator();
        while (result == null && iter.hasNext()) {
            result = keyManager.chooseServerAlias(((SSLHostConfigCertificate.Type)((Object)iter.next())).toString(), null, null);
        }
        return result;
    }

    private static X509KeyManager chooseKeyManager(KeyManager[] managers) throws Exception {
        for (KeyManager manager : managers) {
            if (!(manager instanceof X509KeyManager)) continue;
            return (X509KeyManager)manager;
        }
        throw new IllegalStateException(sm.getString("openssl.keyManagerMissing"));
    }

    private static X509TrustManager chooseTrustManager(TrustManager[] managers) {
        for (TrustManager m : managers) {
            if (!(m instanceof X509TrustManager)) continue;
            return (X509TrustManager)m;
        }
        throw new IllegalStateException(sm.getString("openssl.trustManagerMissing"));
    }

    private static X509Certificate[] certificates(byte[][] chain) {
        X509Certificate[] peerCerts = new X509Certificate[chain.length];
        for (int i = 0; i < peerCerts.length; ++i) {
            peerCerts[i] = new OpenSSLX509Certificate(chain[i]);
        }
        return peerCerts;
    }

    @Override
    public SSLSessionContext getServerSessionContext() {
        return this.sessionContext;
    }

    @Override
    public SSLEngine createSSLEngine() {
        return new OpenSSLEngine(this.ctx, defaultProtocol, false, this.sessionContext, this.negotiableProtocols != null && this.negotiableProtocols.size() > 0, this.initialized);
    }

    @Override
    public SSLServerSocketFactory getServerSocketFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SSLParameters getSupportedSSLParameters() {
        throw new UnsupportedOperationException();
    }

    static {
        END_KEY = "\n-----END RSA PRIVATE KEY-----";
        try {
            X509_CERT_FACTORY = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalStateException(sm.getString("openssl.X509FactoryError"), e);
        }
    }
}

