/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.appworx.AppWorxVariables;
import com.bmc.ctmconvert.appworx.CsvFileTable;
import com.bmc.ctmconvert.appworx.EntityTableManager;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class NotificationsTable {
    private static NotificationsTable instance;
    public static String notificationsMSG;
    private HashMap<String, Properties> notifications = new HashMap();
    private HashMap<String, ArrayList<Properties>> notificationsMessages = new HashMap();
    private HashMap<String, ArrayList<HashMap<String, String>>> notificationsActions = new HashMap();

    public static NotificationsTable instance() {
        if (instance == null) {
            instance = new NotificationsTable();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    private NotificationsTable() {
        CsvFileTable table = EntityTableManager.get(EntityTableManager.EntityType.aw_notif);
        AttrHolderList list = table.getAttrHoldersList();
        for (IAttrHolder attr : list) {
            String notification = attr.getAttr("long_list");
            String[] notificationArr = notification.split(String.format("[%s]+", notification.substring(1, 2)));
            Properties properties = new Properties();
            properties.setProperty("DEST", notificationArr.length > 5 ? notificationArr[5] : "Default");
            String text = "Default";
            if (notificationArr.length > 6) {
                text = this.changeVariableAnnotation(notificationArr[6], attr.getAttr("aw_notif_name"));
            }
            properties.setProperty("SUBJECT", text);
            text = "Default";
            if (notificationArr.length > 3) {
                text = this.changeVariableAnnotation(notificationArr[3], attr.getAttr("aw_notif_name"));
            }
            properties.setProperty("MESSAGE", text);
            properties.setProperty("ATTACH_SYSOUT", "Default");
            properties.setProperty("URGENCY", "R");
            this.notifications.put(attr.getAttr("aw_notif_name"), properties);
        }
    }

    private String changeVariableAnnotation(String origText, String notificationName) {
        AppWorxVariables appWorxVariables = new AppWorxVariables(origText);
        ArrayList<Properties> notificationMessages = this.notificationsMessages.get(notificationName);
        if (notificationMessages == null) {
            notificationMessages = new ArrayList();
        }
        for (Properties properties : appWorxVariables.getMessages()) {
            notificationMessages.add(properties);
        }
        this.notificationsMessages.put(notificationName, notificationMessages);
        ArrayList<HashMap<String, String>> notificationActions = this.notificationsActions.get(notificationName);
        if (notificationActions == null) {
            notificationActions = new ArrayList();
        }
        for (HashMap<String, String> properties : appWorxVariables.getActions()) {
            notificationActions.add(properties);
        }
        this.notificationsActions.put(notificationName, notificationActions);
        return appWorxVariables.getAnnotatedText();
    }

    public Properties getNitificationProperties(String name) {
        return this.notifications.get(name);
    }

    public ArrayList<Properties> getNitificationMessages(String name) {
        return this.notificationsMessages.get(name);
    }

    public ArrayList<HashMap<String, String>> getNitificationActions(String name) {
        return this.notificationsActions.get(name);
    }

    static {
        notificationsMSG = "NotificationsMSG";
    }
}

