/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.common.Params;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NodesTable {
    private static NodesTable instance;
    public static final String NAME = "Name";
    public static final String PHYSICAL_NAME = "PhysicalName";
    public static final String PLATFORM = "Platform";
    public static final String FLAG1 = "Flag1";
    public static final String FLAG2 = "Flag2";
    public static final String FLAG3 = "Flag3";
    public static final String GROUP_FLAG = "Group";
    public static final String GROUP_MULTI_FLAG = "MultiHostExecution";
    public static final String GROUP_NODES_LIST = "GroupNodeList";
    private HashMap<String, Properties> nodesMapping = new HashMap();

    public static NodesTable instance() {
        if (instance == null) {
            instance = new NodesTable();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodesTable() {
        String destinationFolderPath = Params.instance().getDatasourcePath();
        try (Scanner scanner = null;){
            Pattern nodeGroupPattern = Pattern.compile("^Group: (\\S+)\\s*Multi Host Execution: ([N|Y])");
            scanner = new Scanner(new File(destinationFolderPath + "AppWorxNodesMapping.txt"));
            String line = null;
            boolean skip = false;
            while (scanner.hasNextLine()) {
                if (!skip) {
                    line = scanner.nextLine();
                }
                if (line.isEmpty()) continue;
                skip = false;
                Matcher nodeGroupMatcher = nodeGroupPattern.matcher(line);
                if (line.matches("(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\d+)\\s+(\\S)\\s+(\\d+)\\s*")) {
                    String[] record = line.split("\\s+");
                    Properties properties = new Properties();
                    properties.setProperty(NAME, record[0]);
                    properties.setProperty(PHYSICAL_NAME, record[1]);
                    properties.setProperty(PLATFORM, record[2]);
                    properties.setProperty(FLAG1, record[3]);
                    properties.setProperty(FLAG2, record[4]);
                    properties.setProperty(FLAG3, record[5]);
                    properties.setProperty(GROUP_FLAG, "N");
                    this.nodesMapping.put(record[0], properties);
                    continue;
                }
                if (!nodeGroupMatcher.matches()) continue;
                Properties properties = new Properties();
                properties.setProperty(NAME, nodeGroupMatcher.group(1));
                properties.setProperty(GROUP_MULTI_FLAG, nodeGroupMatcher.group(2));
                properties.setProperty(GROUP_FLAG, "Y");
                ArrayList<String> nodesList = new ArrayList<String>();
                while (scanner.hasNextLine() && !skip) {
                    line = scanner.nextLine();
                    nodeGroupMatcher = nodeGroupPattern.matcher(line);
                    if (!nodeGroupMatcher.matches() && line.matches("\\s+\\S+\\s*")) {
                        nodesList.add(line.trim());
                        continue;
                    }
                    properties.put(GROUP_NODES_LIST, nodesList);
                    this.nodesMapping.put(properties.getProperty(NAME), properties);
                    skip = true;
                }
            }
        }
    }

    public Set<String> getNodesList() {
        return this.nodesMapping.keySet();
    }

    public String getNodeName(String nodeName) {
        String name = null;
        Properties node = this.getNodeProperties(nodeName);
        if (node != null) {
            name = node.containsKey(PHYSICAL_NAME) ? node.getProperty(PHYSICAL_NAME) : node.getProperty(NAME);
        }
        return name != null ? name : nodeName;
    }

    public String getNodePlatform(String nodeName) {
        String platform = null;
        Properties node = this.getNodeProperties(nodeName);
        if (node != null) {
            platform = node.getProperty(PLATFORM);
        }
        return platform;
    }

    public boolean getMutiExecutionFlag(String nodeName) {
        Properties node = this.getNodeProperties(nodeName);
        if (node != null && node.containsKey(GROUP_MULTI_FLAG)) {
            return node.getProperty(GROUP_MULTI_FLAG).equals("Y");
        }
        return false;
    }

    public Properties getNodeProperties(String nodeName) {
        return this.nodesMapping.get(nodeName);
    }
}

