/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Scanner;

public class Exp2Csv {
    private String destinationFolderPath;
    private BaseProgressBar progressBar;
    private Scanner scanner;
    private String line;
    private final String START = "START";
    private final String END = "END";
    private final String DELETE = "DELETE";
    private final String TABLE = "Table";
    private final String LEFTOVER = "Leftover";
    private int totalLines = 0;
    private int currLine = 0;
    private HashMap<String, ArrayList<Properties>> propertiesGroups = new HashMap();
    private HashMap<String, ArrayList<String>> propertiesHeaders = new HashMap();

    public Exp2Csv(String destinationFolderPath, BaseProgressBar progressBar) {
        this.destinationFolderPath = destinationFolderPath;
        this.progressBar = progressBar;
    }

    public boolean convert2CSV() throws ConvertorCancelClickException, FileNotFoundException {
        this.scanner = new Scanner(new File(this.destinationFolderPath + "AppWorxExpDefinitions.exp"));
        this.totalLines = this.getLineCount();
        do {
            this.line = this.getNextLine();
            if (this.line.startsWith("START")) {
                this.processStart();
                continue;
            }
            if (this.line.startsWith("DELETE")) {
                this.processDelete();
                continue;
            }
            this.processLeftover();
        } while (!this.line.isEmpty());
        this.scanner.close();
        this.saveCsvs();
        return true;
    }

    private void processStart() throws ConvertorCancelClickException {
        Properties entry = new Properties();
        String table = "";
        String[] properties = this.line.split(" ");
        int samePropertyCnt = 0;
        for (int index = 0; index < properties.length; ++index) {
            if (!properties[index].contains("=")) continue;
            String[] propertyArr = properties[index].split("=", 2);
            entry.setProperty(propertyArr[0], propertyArr[1]);
            if (propertyArr[0].equals("START")) {
                table = propertyArr[1];
                continue;
            }
            this.add2Headers(table, propertyArr[0]);
        }
        while (!this.line.isEmpty() && !this.line.startsWith("END")) {
            this.line = this.getNextLine();
            if (!this.line.contains("=")) continue;
            String[] propertyArr = this.line.split("=", 2);
            if (entry.containsKey(propertyArr[0]) && !entry.getProperty(propertyArr[0]).equals(propertyArr[1])) {
                propertyArr[0] = propertyArr[0] + "_" + ++samePropertyCnt;
            }
            entry.setProperty(propertyArr[0], propertyArr[1]);
            this.add2Headers(table, propertyArr[0]);
        }
        this.add2PropertiesGroups(table, entry);
    }

    private void processDelete() {
        Properties entry = new Properties();
        String table = "";
        this.line = this.line.replace(" not_in ", "=");
        String[] properties = this.line.split(" ");
        for (int index = 0; index < properties.length; ++index) {
            String delimiter = "=";
            if (!properties[index].contains("=")) {
                delimiter = ">";
            }
            if (!properties[index].contains(delimiter)) continue;
            String[] propertyArr = properties[index].split(delimiter, 2);
            entry.setProperty(propertyArr[0], (delimiter == ">" ? ">" : "") + propertyArr[1]);
            if (propertyArr[0].equals("DELETE")) {
                table = propertyArr[1];
                entry.setProperty("Table", table);
                this.add2Headers("DELETE", "Table");
                continue;
            }
            this.add2Headers("DELETE", propertyArr[0]);
        }
        this.add2PropertiesGroups("DELETE", entry);
    }

    private void processLeftover() {
        Properties entry = new Properties();
        entry.setProperty("Leftover", this.line);
        this.add2Headers("Leftover", "Leftover");
        this.add2PropertiesGroups("Leftover", entry);
    }

    private void add2Headers(String table, String property) {
        ArrayList<String> header = this.propertiesHeaders.get(table);
        if (header == null) {
            header = new ArrayList();
            this.propertiesHeaders.put(table, header);
        }
        if (!header.contains(property)) {
            header.add(property);
        }
    }

    private void add2PropertiesGroups(String table, Properties properties) {
        ArrayList<Properties> propertiesArray = this.propertiesGroups.get(table);
        if (propertiesArray == null) {
            propertiesArray = new ArrayList();
            this.propertiesGroups.put(table, propertiesArray);
        }
        propertiesArray.add(properties);
    }

    private String getNextLine() throws ConvertorCancelClickException {
        StringBuilder lineBuilder = new StringBuilder();
        boolean first = true;
        while (this.scanner.hasNextLine()) {
            int startIndex;
            String line;
            if (this.progressBar != null) {
                ++this.currLine;
                this.progressBar.setProgressValue(this.currLine * 50 / this.totalLines + 30);
                if (this.progressBar.isCancelled()) {
                    throw new ConvertorCancelClickException();
                }
            }
            if ((line = this.scanner.nextLine()).isEmpty()) continue;
            int n = startIndex = first ? 0 : line.indexOf("=") + 1;
            if (line.endsWith("\\")) {
                lineBuilder.append(line, startIndex, line.length() - 1);
                first = false;
                continue;
            }
            lineBuilder.append(line, startIndex, line.length());
            break;
        }
        return lineBuilder.toString();
    }

    private int getLineCount() throws FileNotFoundException {
        int lines = 0;
        while (this.scanner.hasNextLine()) {
            this.scanner.nextLine();
            ++lines;
        }
        this.scanner.close();
        this.scanner = new Scanner(new File(this.destinationFolderPath + "AppWorxExpDefinitions.exp"));
        return lines;
    }

    private void saveCsvs() throws ConvertorCancelClickException {
        int totalFiles = this.propertiesGroups.size();
        int currFile = 0;
        for (String entry : this.propertiesGroups.keySet()) {
            if (this.progressBar != null) {
                this.progressBar.setProgressValue(++currFile * 20 / totalFiles + 80);
                if (this.progressBar.isCancelled()) {
                    throw new ConvertorCancelClickException();
                }
            }
            try {
                CsvWriter csvWriter = new CsvWriter(this.destinationFolderPath + entry + ".csv");
                String[] entryHeaders = this.propertiesHeaders.get(entry).toArray(new String[0]);
                csvWriter.writeRecord(entryHeaders);
                for (Properties prop : this.propertiesGroups.get(entry)) {
                    String[] record = new String[entryHeaders.length];
                    for (int i = 0; i < entryHeaders.length; ++i) {
                        record[i] = prop.getProperty(entryHeaders[i]);
                    }
                    csvWriter.writeRecord(record);
                    if (this.progressBar == null || !this.progressBar.isCancelled()) continue;
                    throw new ConvertorCancelClickException();
                }
                csvWriter.close();
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
    }
}

