/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.appworx.CsvFileTable;
import com.bmc.ctmconvert.common.Params;
import java.util.HashMap;

public class EntityTableManager {
    private static String datasourcePath = "";
    private static HashMap<EntityType, CsvFileTable> EntityTables = new HashMap();

    private EntityTableManager() {
    }

    public static CsvFileTable get(EntityType table) {
        CsvFileTable csvFileTable;
        String path = Params.instance().getDatasourcePath();
        if (!path.equals(datasourcePath)) {
            EntityTableManager.clear();
            datasourcePath = path;
        }
        if ((csvFileTable = EntityTables.get((Object)table)) == null) {
            csvFileTable = new CsvFileTable(EntityTableManager.getTableProperties(table));
            EntityTables.put(table, csvFileTable);
        }
        return csvFileTable;
    }

    public static void clear() {
        EntityTables = new HashMap();
    }

    public static void clear(EntityType table) {
        EntityTables.remove((Object)table);
    }

    private static String getTableProperties(EntityType table) {
        return datasourcePath + table.toString() + ".csv";
    }

    public static enum EntityType {
        aw_env_lst("aw_envlst_name"),
        aw_module_except("so_module"),
        aw_module_sched("aw_sch_name"),
        aw_msg_template("aw_template_name"),
        aw_notif("aw_notif_name"),
        aw_output_scan("aw_scan_name"),
        aw_reports_header("aw_rpt_name"),
        aw_sched_args("so_module"),
        aw_thread_scheds("aw_sched_name"),
        so_appls("so_appl_name"),
        so_chain_args("so_module"),
        so_chain_detail("so_module"),
        so_chain_prts("so_module"),
        so_command_paths("so_commd_type"),
        so_dist_list("so_printer"),
        so_documentation("so_module"),
        so_holiday_grps("so_holiday_name"),
        so_job_prompts("so_module"),
        so_job_table("so_module"),
        so_libraries("so_library"),
        so_object_cond("so_module"),
        so_printers("so_printer"),
        so_prompt_types("so_prompt_type"),
        so_queues("so_queue"),
        so_role_master("so_role_name"),
        so_spoolers("so_spooler"),
        so_sub_vars("so_var_name"),
        EntitesWithoutProcessFlows("EntitesWithoutProcessFlows");

        private final String tableIDKey;

        private EntityType(String tableIDKey) {
            this.tableIDKey = tableIDKey;
        }

        public String getTableIDKey() {
            return this.tableIDKey;
        }
    }
}

