/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AppWorxVariables {
    private String text;
    private final Pattern variablePaterren = Pattern.compile("\\{?#((\\d+)|([^\\{}%%#\\/]+))\\}?");
    public static final String unresolvedReplacementPrefix = "%%AppWorx_";
    private final Pattern unresolvedVariablePattern = Pattern.compile("%%AppWorx_\\S+");
    private ArrayList<HashMap<String, String>> actions;
    private ArrayList<Properties> messages;

    public AppWorxVariables(String text) {
        this.text = text;
        this.actions = new ArrayList();
        this.messages = new ArrayList();
        this.variableHandleWithBraces();
        this.text = this.changeVariablesAnnotation(this.text);
    }

    private void variableHandleWithBraces() {
        this.jobReplacementValues();
        List<Pair<Integer, Integer>> pairsOfBraces = this.FindPairsofBraces(this.text);
        String tempText = this.text;
        for (Pair<Integer, Integer> pair : pairsOfBraces) {
            String subTextWithBraces = this.text.substring((Integer)pair.getKey(), (Integer)pair.getValue() + 1);
            String subTextWithOutBraces = this.text.substring((Integer)pair.getKey() + 1, (Integer)pair.getValue());
            if (!this.isVariable(subTextWithBraces)) continue;
            subTextWithOutBraces = this.handelIllegalCharacterInVariable(subTextWithOutBraces);
            subTextWithOutBraces = this.changeVariablesAnnotation(subTextWithOutBraces);
            tempText = tempText.replace(subTextWithBraces, subTextWithOutBraces);
        }
        this.text = tempText;
    }

    private boolean isVariable(String subTextWithBraces) {
        Matcher matcher = this.variablePaterren.matcher(subTextWithBraces);
        return matcher.find();
    }

    public AppWorxVariables(String text, ReplaceType replaceType) {
        this.text = text;
        this.actions = new ArrayList();
        this.messages = new ArrayList();
        if (replaceType.equals((Object)ReplaceType.ONLY_PROMPTS)) {
            text = this.changeVariablesAnnotation(text);
        } else if (replaceType.equals((Object)ReplaceType.ONLY_REPLACEMENT)) {
            this.jobReplacementValues();
        }
    }

    public String changeVariablesAnnotation(String theText) {
        Matcher matcher = this.variablePaterren.matcher(theText);
        while (matcher.find()) {
            Object variable = "%%";
            if (matcher.group(2) != null) {
                variable = (String)variable + matcher.group(2);
            } else {
                variable = (String)variable + matcher.group(3);
                variable = ((String)variable).replaceAll("[()\\-]", "_");
                HashMap<String, String> action = new HashMap<String, String>();
                action.put("ACTENTTYPE", "GLOBALVAR");
                action.put("ACTENTNAME", matcher.group(0));
                action.put("ACTSTATUS", "0");
                this.actions.add(action);
            }
            theText = theText.replace(matcher.group(0), (String)variable + ".");
        }
        return theText;
    }

    private String handelIllegalCharacterInVariable(String variable) {
        String tempVar = variable.replaceAll("[()\\-\\/]", "_");
        return tempVar;
    }

    public void jobReplacementValues() {
        this.text = this.text.replace("{agent}", "%%NODEID.").replace("{application}", "%%APPLIC.").replace("{application_path}", "%%AppWorx_application_path.").replace("{batch_queue}", "%%AppWorx_batch_queue.").replace("{queue}", "%%AppWorx_queue.").replace("{chain_id}", "%%GROUP_ORDID.").replace("{chain_seq}", "%%AppWorx_chain_seq.").replace("{command}", "%%AppWorx_command.").replace("{command_path}", "%%MEMLIB.").replace("{command_type}", "%%AppWorx_command_type.").replace("{condition1}", "%%AppWorx_condition1.").replace("{condition2}", "%%AppWorx_condition2.").replace("{db_type}", "%%AppWorx_db_type.").replace("{engine}", "%%DATACENTER.").replace("{email}", "%%AppWorx_email.").replace("{fax_no}", "%%AppWorx_fax_no.").replace("{file_line}", "%%AppWorx_file_line.").replace("{first}", "%%AppWorx_first.").replace("{flow_seq}", "%%AppWorx_flow_seq.").replace("{host_command}", "%%AppWorx_host_command.").replace("{job}", "%%JOBNAME.").replace("{job_seq}", "%%AppWorx_jobid.").replace("{jobid}", "%%ORDERID.-%%RUNCOUNT.").replace("{last}", "%%AppWorx_last.").replace("{master}", "%%AppWorx_master.").replace("{mjn}", "%%AppWorx_mjn.").replace("{module}", "%%JOBNAME.").replace("{net_connect}", "%%AppWorx_net_connect.").replace("{node}", "%%NODEID.").replace("{operator}", "%%NODEID.").replace("{oracle_sid}", "%%AppWorx_oracle_sid.").replace("{phone_no}", "%%AppWorx_phone_no.").replace("{queue}", "%%AppWorx_queue.").replace("{requestor}", "%%OWNER.").replace("{run_id}", "%%AppWorx_run_id.").replace("{seq_no}", "%%AppWorx_seq_no.").replace("{status}", "%%COMPSTAT.").replace("{subflow_id}", "%%AppWorx_subflow_id.").replace("{task}", "%%JOBNAME.").replace("{text_msg}", "%%AppWorx_text_msg.").replace("{top_flow_id}", "%%AppWorx_top_flow_id.");
        Matcher matcher = this.unresolvedVariablePattern.matcher(this.text);
        while (matcher.find()) {
            Properties message = new Properties();
            message.put("MSGID", "WRN11016");
            message.put("RESVAR", new String[]{matcher.group(0)});
            this.messages.add(message);
            HashMap<String, String> action = new HashMap<String, String>();
            action.put("ACTENTTYPE", "GLOBALVAR");
            action.put("ACTENTNAME", matcher.group(0));
            action.put("ACTSTATUS", "0");
            this.actions.add(action);
        }
    }

    public List<Pair<Integer, Integer>> FindPairsofBraces(String text) {
        Stack<Integer> stack = new Stack<Integer>();
        ArrayList<Pair<Integer, Integer>> pairs = new ArrayList<Pair<Integer, Integer>>();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '{') {
                stack.push(i);
            }
            if (text.charAt(i) != '}' || stack.size() == 0) continue;
            pairs.add((Pair<Integer, Integer>)new Pair((Object)((Integer)stack.pop()), (Object)i));
        }
        return pairs;
    }

    public String getAnnotatedText() {
        return this.text;
    }

    public ArrayList<Properties> getMessages() {
        return this.messages;
    }

    public ArrayList<HashMap<String, String>> getActions() {
        return this.actions;
    }

    public static enum ReplaceType {
        ONLY_PROMPTS,
        ONLY_REPLACEMENT;

    }
}

