/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.appworx.AppWorxDefs;
import com.bmc.ctmconvert.appworx.AppWorxEntity;
import com.bmc.ctmconvert.appworx.AppWorxSchedConvertor;
import com.bmc.ctmconvert.appworx.AppWorxTaskTypeFieldsMapping;
import com.bmc.ctmconvert.appworx.AppWorxVariablesHandler;
import com.bmc.ctmconvert.appworx.CommandTaskHandler;
import com.bmc.ctmconvert.appworx.ConditionsResolver;
import com.bmc.ctmconvert.appworx.EntityTableManager;
import com.bmc.ctmconvert.appworx.NodesTable;
import com.bmc.ctmconvert.appworx.OEBSJobHandler;
import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CtmPriority;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.MessageIdTable;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.message_id.MessageId;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.tree.TreeNode;

public class AppWorxJob
implements SchedEntity {
    private final SchedEntity.TYPE entityType;
    private final AppWorxEntity entityData;
    private boolean validEntity = true;
    private Properties properties = new Properties();
    private final ArrayList<String> optionalProperties = new ArrayList();
    private LinkedHashMap<String, String> autoedits;
    private ArrayList<SchedEntity> children;
    private String nodePlatform;
    private final RulesDataSet rules;
    private final ArrayList<String> messages = new ArrayList();
    private LinkedHashSet<AssistingJob> schedulingJobs;
    private final LinkedHashSet<AssistingJob> preCmdJobs = new LinkedHashSet();
    private static final CtmPriority priorityCalculator = new CtmPriority(99, 1);
    private String maxwait = "";
    private boolean isScriptJob = false;
    private static int uniqueNumber = 0;

    public AppWorxJob(SchedEntity.TYPE entityType, AppWorxEntity entityData, RulesDataSet rules, String nodePlatform) {
        this.entityType = entityType;
        this.entityData = entityData;
        this.rules = rules;
        this.nodePlatform = nodePlatform;
        this.initialize();
        this.messages.addAll(entityData.getMessages());
    }

    public AppWorxEntity getEntityData() {
        return this.entityData;
    }

    private void initialize() {
        if (this.entityData == null) {
            this.validEntity = false;
            return;
        }
        this.autoedits = this.entityData.getAutoedits();
        this.maxwait = this.rules.getStringRule("AppWorx rules", new String[]{"MAXWAIT"});
        HashMap<String, String> competitorValues = new HashMap<String, String>();
        switch (this.entityType) {
            case SMART_TABLE: 
            case TABLE: {
                String tableName = FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", this.entityData.getEntityDisplayName());
                this.properties.setProperty("TABLE_NAME", tableName);
                this.properties.setProperty("JOBNAME", tableName);
                this.properties.setProperty("TABLE_USERDAILY", "");
                break;
            }
            case SUB_TABLE: {
                this.properties.setProperty("JOBNAME", FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", this.entityData.getEntityDisplayName()));
                this.properties.setProperty("PARENT_TABLE", this.getParentName());
                break;
            }
            case JOB: {
                this.properties.setProperty("JOBNAME", FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", this.entityData.getEntityDisplayName()));
                this.properties.setProperty("PARENT_TABLE", this.getParentName());
                this.properties.setProperty("CYCLIC", "0");
                this.properties.setProperty("TAG_RELATIONSHIP", "OR");
                this.properties.setProperty("ACTIVE_FROM", "");
                this.properties.setProperty("ACTIVE_TILL", "");
                if (this.entityData.getJobDetails() != null) {
                    String nodeName = this.entityData.getJobDetails().getAttr("so_node");
                    if (NodesTable.instance().getMutiExecutionFlag(nodeName)) {
                        this.properties.setProperty("MULTY_AGENT", "Y");
                    }
                    this.properties.setProperty("NODEID", FieldValidation.instance().validateAndReturnFixedValue("NODEID", NodesTable.instance().getNodeName(nodeName)));
                    Properties nodeProperties = NodesTable.instance().getNodeProperties(nodeName);
                    if (nodeProperties != null && nodeProperties.getProperty("Group").equals("Y")) {
                        HashMap<String, String> nodeGrpAction = new HashMap<String, String>();
                        nodeGrpAction.put("ACTENTTYPE", "NODEGRP");
                        nodeGrpAction.put("JOBID", this.originalProductID());
                        nodeGrpAction.put("ACTENTNAME", nodeName);
                        nodeGrpAction.put("ACTSTATUS", "0");
                        Reporter.addAction(nodeGrpAction);
                    }
                    this.convertTaskType();
                } else {
                    this.properties.setProperty("TASKTYPE", "Dummy");
                    Reporter.addMessage(this.messages, (String)"WRN11025", (String)this.originalProductID(), (String[])new String[]{this.getJobName(), this.getParentName(), EntityTableManager.EntityType.so_job_table.toString()});
                }
                this.setOptionalAttribute("MAXWAIT", this.maxwait);
                break;
            }
        }
        if (this.entityData.getJobDetails() != null) {
            competitorValues.put("Application", this.entityData.getJobDetails().getAttr("so_application"));
            competitorValues.put("Queue", this.entityData.getJobDetails().getAttr("so_queue"));
            competitorValues.put("Login", this.entityData.getJobDetails().getAttr("so_login"));
            competitorValues.put("Job_description", this.entityData.getJobDetails().getAttr("so_job_descr"));
            try {
                String prio = this.entityData.getJobDetails().getAttr("so_default_pri");
                this.properties.setProperty("PRIORITY", priorityCalculator.calculatePriority(Integer.parseInt(prio)));
            }
            catch (NumberFormatException ex) {
                Reporter.addMessage(this.messages, (String)"WRN11022", (String)this.originalProductID(), (String[])new String[]{this.entityData.getJobDetails().getAttr("so_default_pri"), "so_default_pri", "PRIORITY"});
                ExceptionHandler.writeToExceptionFile((Exception)ex);
            }
        }
        this.properties.setProperty("APPLICATION", FieldValidation.instance().validateAndReturnFixedValue("APPLICATION", this.rules.getFieldEditor().generateCTMField("APPLICATION", competitorValues)));
        this.properties.setProperty("GROUP", FieldValidation.instance().validateAndReturnFixedValue("GROUP", this.rules.getFieldEditor().generateCTMField("GROUP", competitorValues)));
        this.properties.setProperty("DESCRIPTION", FieldValidation.instance().validateAndReturnFixedValue("DESCRIPTION", this.rules.getFieldEditor().generateCTMField("DESCRIPTION", competitorValues)));
        this.properties.setProperty("OWNER", FieldValidation.instance().validateAndReturnFixedValue("OWNER", this.rules.getFieldEditor().generateCTMField("OWNER", competitorValues)));
        this.properties.setProperty("AUTHOR", FieldValidation.instance().validateAndReturnFixedValue("AUTHOR", this.rules.getFieldEditor().generateCTMField("AUTHOR", competitorValues)));
        this.handleAppWorxCondition();
    }

    private void handleAppWorxCondition() {
        AttrHolderList conditions;
        String commandSep = "&";
        String nodeType = this.getNodePlatform();
        if (nodeType.startsWith("U")) {
            commandSep = ";";
        }
        if (!(conditions = this.entityData.getConditions()).isEmpty()) {
            for (IAttrHolder condition : conditions) {
                String so_performed;
                boolean ignorePerformedConditionds = this.rules.getBooleanRule("AppWorx rules", new String[]{"IGNORE_PERFORMED_CONDITIONS"});
                if (ignorePerformedConditionds && null != condition && null != (so_performed = condition.getAttr("so_performed")) && so_performed.equalsIgnoreCase("Y")) {
                    Reporter.addMessage(this.messages, (String)"INF11005", (String)this.originalProductID(), (String[])new String[]{condition.toString()});
                    return;
                }
                boolean bIsJob = this.entityType.equals((Object)SchedEntity.TYPE.JOB);
                Map.Entry<String, List<Properties>> convertedRow = ConditionsResolver.convertConditionRow(conditions, commandSep, bIsJob);
                if (null != convertedRow) {
                    String sType = convertedRow.getKey();
                    if (sType.equals("SUBVAR") || sType.equals("SUBVAR_RUN")) {
                        if (null == this.autoedits) {
                            this.autoedits = new LinkedHashMap();
                        }
                        if (null == convertedRow.getValue()) continue;
                        for (Properties properties : convertedRow.getValue()) {
                            if (properties.containsKey("CONVERSION_MESSAGES_ARRAY")) {
                                this.addConditionsMessages(properties);
                            }
                            if (properties.containsKey("CONVERSION_ACTIONS_ARRAY")) {
                                this.addConditionsActions(properties);
                            }
                            for (String string : properties.stringPropertyNames()) {
                                String sUpper;
                                Object sAutoEditVal = properties.getProperty(string);
                                String validatedVariableName = GlobalFunctions.addMissingVariablePrefix((String)AppWorxVariablesHandler.validateVariableName(string));
                                if (null != this.autoedits.get(AppWorxVariablesHandler.validateVariableName(string))) {
                                    sAutoEditVal = (String)sAutoEditVal + " " + commandSep + " " + this.autoedits.get(AppWorxVariablesHandler.validateVariableName(string));
                                }
                                this.autoedits.put(validatedVariableName, (String)sAutoEditVal);
                                if (!sType.equals("SUBVAR_RUN") || !(sUpper = ((String)sAutoEditVal).toUpperCase()).contains("#") && !sUpper.contains("{") && !sUpper.contains("APPWORX")) continue;
                                Reporter.addMessage(this.messages, (String)"WRN11023", (String)this.originalProductID(), (String[])new String[]{condition.toString(), sAutoEditVal});
                            }
                        }
                        continue;
                    }
                    if (sType.equals("DOSTMT")) {
                        if (null == convertedRow.getValue()) continue;
                        for (Properties properties : convertedRow.getValue()) {
                            if (properties.containsKey("CONVERSION_MESSAGES_ARRAY")) {
                                this.addConditionsMessages(properties);
                            }
                            if (properties.containsKey("CONVERSION_ACTIONS_ARRAY")) {
                                this.addConditionsActions(properties);
                                continue;
                            }
                            this.entityData.addOnStatement(properties);
                        }
                        continue;
                    }
                    if (sType.equals("NEW_JOB_NEEDED")) {
                        String precmdAutoEditValue = "";
                        if (null != convertedRow.getValue()) {
                            for (Object prop2 : convertedRow.getValue()) {
                                for (String sAutoEditName2 : ((Properties)prop2).stringPropertyNames()) {
                                    if (!sAutoEditName2.equals("%%PRECMD")) continue;
                                    precmdAutoEditValue = ((Properties)prop2).getProperty(sAutoEditName2);
                                }
                            }
                        }
                        if (precmdAutoEditValue.equals("")) {
                            ConversionLogger.getLogger().info("handleAppWorxCondition: NEW_JOB_NEEDED condition found but no %%PRECMD exists in convertedRow!!!");
                            continue;
                        }
                        LinkedHashSet<AssistingJob> linkedHashSet = this.getSchedulingJobs();
                        if (linkedHashSet != null && !linkedHashSet.isEmpty()) {
                            Object prop2;
                            prop2 = linkedHashSet.iterator();
                            while (prop2.hasNext()) {
                                AssistingJob assistingJob = (AssistingJob)prop2.next();
                                assistingJob.setAutoedit("%%PRECMD", precmdAutoEditValue);
                            }
                            continue;
                        }
                        if (this.entityType.equals((Object)SchedEntity.TYPE.SMART_TABLE)) {
                            Reporter.addMessage(this.messages, (String)"WRN11021", (String)this.originalProductID(), (String[])new String[]{condition.toString()});
                            continue;
                        }
                        if (!this.entityType.equals((Object)SchedEntity.TYPE.SUB_TABLE)) continue;
                        String condAction = condition.getAttr("so_action").replace(" ", "_");
                        String string = this.createPreCmdJob(precmdAutoEditValue, condAction);
                        Reporter.addMessage(this.messages, (String)"INF11002", (String)this.originalProductID(), (String[])new String[]{string, this.getJobName(), condition.toString()});
                        continue;
                    }
                    if (sType.equalsIgnoreCase("NC_COND")) {
                        Reporter.addMessage(this.messages, (String)"WRN11008", (String)this.originalProductID(), (String[])new String[]{condition.toString()});
                        continue;
                    }
                    if (sType.equals("NC_ACT")) {
                        IAttrHolder firstRow = condition;
                        if (null != firstRow) {
                            String string = firstRow.getAttr("so_action");
                            if (!string.equalsIgnoreCase("RUN HOST COMMAND")) continue;
                            Reporter.addMessage(this.messages, (String)"WRN11026", (String)this.originalProductID(), (String[])new String[]{condition.toString()});
                            continue;
                        }
                        Reporter.addMessage(this.messages, (String)"WRN11007", (String)this.originalProductID(), (String[])new String[]{condition.toString()});
                        continue;
                    }
                    if (sType.equals("NOT_CONVERTED_ACTION_RJ")) {
                        Reporter.addMessage(this.messages, (String)"WRN11015", (String)this.originalProductID(), (String[])new String[]{condition.toString()});
                        continue;
                    }
                    if (sType.equals("OLD_APPWORX_VALUE")) {
                        Reporter.addMessage(this.messages, (String)"WRN11011", (String)this.originalProductID(), (String[])new String[]{condition.toString()});
                        continue;
                    }
                    if (sType.equals("NC_COND_1_SUBVAR")) {
                        Reporter.addMessage(this.messages, (String)"WRN11010", (String)this.originalProductID(), (String[])new String[]{condition.toString()});
                        continue;
                    }
                    if (sType.equals("UNSUPPORTED_SUBVAR_USAGE")) {
                        Reporter.addMessage(this.messages, (String)"WRN11012", (String)this.originalProductID(), (String[])new String[]{condition.toString()});
                        continue;
                    }
                    if (sType.equals("INVALID_OR_MISSING_DATA")) {
                        Reporter.addMessage(this.messages, (String)"WRN11009", (String)this.originalProductID(), (String[])new String[]{condition.toString()});
                        continue;
                    }
                    if (sType.equals("NC_TIMING")) {
                        Reporter.addMessage(this.messages, (String)"WRN11020", (String)this.originalProductID(), (String[])new String[]{condition.toString()});
                        continue;
                    }
                    if (!sType.equals("CONDITIONS_GENERATED")) continue;
                }
                Reporter.addMessage(this.messages, (String)"WRN11005", (String)this.originalProductID(), (String[])new String[]{condition.toString()});
            }
        }
    }

    private void addConditionsMessages(Properties messagesProperties) {
        ArrayList messagesPropertiesArray = (ArrayList)messagesProperties.get("CONVERSION_MESSAGES_ARRAY");
        if (messagesPropertiesArray != null && !messagesPropertiesArray.isEmpty()) {
            for (Properties msg : messagesPropertiesArray) {
                Reporter.addMessage(this.messages, (String)msg.getProperty("MSGID"), (String)this.originalProductID(), (String[])((String[])msg.get("RESVAR")));
            }
        }
    }

    private void addConditionsActions(Properties actionsProperties) {
        ArrayList actionsPropertiesArray = (ArrayList)actionsProperties.get("CONVERSION_ACTIONS_ARRAY");
        if (actionsPropertiesArray != null && !actionsPropertiesArray.isEmpty()) {
            AppWorxDefs.addActionsToReporter(this.messages, actionsPropertiesArray, this.originalProductID());
        }
    }

    private void convertTaskType() {
        String jobTypeInAppworx = this.entityData.getJobDetails().getAttr("so_command_type");
        if ("OAE".equals(jobTypeInAppworx)) {
            OEBSJobHandler oebsHandler = new OEBSJobHandler(this);
            this.properties = oebsHandler.getJobProperties();
        } else {
            this.handleOtherJobs();
        }
        boolean convertToDummy = this.isDummyJob();
        if (convertToDummy) {
            this.convertToDummyJob();
        }
    }

    private boolean isDummyJob() {
        String nodePlatform;
        boolean convertToDummy = this.rules.getTaskTypeHandler().isToDummy();
        String node = this.entityData.getJobDetails().getAttr("so_node");
        if (!this.getParentName().equals("EntitesWithoutProcessFlows") && this.entityData.getChainDetails().getAttr("so_act_flag").equals("N")) {
            convertToDummy = true;
            Reporter.addMessage(this.messages, (String)"WRN11024", (String)this.originalProductID(), (String[])new String[0]);
        }
        if (!(node == null || node.isEmpty() || (nodePlatform = this.getNodePlatform()).equals("Unix") || nodePlatform.equals("Windows"))) {
            convertToDummy = true;
        }
        return convertToDummy;
    }

    private void handleOtherJobs() {
        AppWorxTaskTypeFieldsMapping appWorxTaskTypeFieldsMapper = new AppWorxTaskTypeFieldsMapping(this.properties);
        boolean convertToCmdline = !this.rules.getTaskTypeHandler().isToJobType();
        String program = this.entityData.getJobDetails().getAttr("so_program");
        String nodePlatform = this.getNodePlatform();
        appWorxTaskTypeFieldsMapper.setFilePath(nodePlatform, this.entityData);
        appWorxTaskTypeFieldsMapper.setFileName(nodePlatform, this.entityData);
        boolean isFilePathEmpty = appWorxTaskTypeFieldsMapper.isFilePathEmpty();
        if (isFilePathEmpty) {
            convertToCmdline = true;
        }
        if (convertToCmdline) {
            CommandTaskHandler cmdBuilder = new CommandTaskHandler(this, appWorxTaskTypeFieldsMapper, this.entityData.getLibrary(), program);
            this.properties = cmdBuilder.getJobProperties();
        } else {
            this.isScriptJob = true;
            this.properties = appWorxTaskTypeFieldsMapper.getScriptMapping();
        }
    }

    private void convertToDummyJob() {
        if (!Params.instance().getGUIVersion().equals("7")) {
            this.autoedits.put("%%$BMCWAIORIGTYPE", this.properties.getProperty("TASKTYPE"));
        }
        this.properties.setProperty("TASKTYPE", "Dummy");
    }

    public String getNodePlatform() {
        if (this.nodePlatform == null) {
            if (this.entityData.getJobDetails() != null) {
                this.nodePlatform = NodesTable.instance().getNodePlatform(this.entityData.getJobDetails().getAttr("so_node"));
                if (this.nodePlatform != null && !this.nodePlatform.isEmpty()) {
                    if (this.nodePlatform.equals("UNIX")) {
                        this.nodePlatform = "Unix";
                    } else if (this.nodePlatform.equals("NT")) {
                        this.nodePlatform = "Windows";
                    } else {
                        Reporter.addMessage(this.messages, (String)"WRN11006", (String)this.originalProductID(), (String[])new String[]{this.nodePlatform});
                    }
                }
            }
            if (this.nodePlatform == null) {
                this.nodePlatform = this.rules.getStringRule("AppWorx rules", new String[]{"NODE_DEFAULT_PLATFORM"});
            }
        }
        return this.nodePlatform;
    }

    private String createPreCmdJob(String cmdline, String condAction) {
        AssistingJob preCmdJob = new AssistingJob((SchedEntity)this);
        String precmdJobname = String.format("%s_FOR_%s", condAction, this.getJobName());
        preCmdJob.setAttribute("JOBNAME", FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", precmdJobname));
        preCmdJob.setAttribute("PARENT_TABLE", FieldValidation.instance().validateAndReturnFixedValue("PARENT_TABLE", this.getParentName()));
        preCmdJob.setAttribute("TABLE_NAME", FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", this.getTableName()));
        boolean bConvertToDummy = this.rules.getTaskTypeHandler().isToDummy();
        if (bConvertToDummy) {
            if (!Params.instance().getGUIVersion().equals("7")) {
                preCmdJob.setAutoedit("%%$BMCWAIORIGTYPE", "Command");
            }
            preCmdJob.setAttribute("TASKTYPE", "Dummy");
        } else {
            preCmdJob.setAttribute("TASKTYPE", "Command");
        }
        preCmdJob.setAttribute("TAG_RELATIONSHIP", "AND");
        ArrayList<Properties> tags = new ArrayList<Properties>(this.getTags());
        preCmdJob.setM_tags(tags);
        preCmdJob.setAttribute("CMDLINE", cmdline);
        boolean jobAOK = this.rules.getStringRule("AppWorx rules", new String[]{"CONDITION_NAME"}).equals("JOBA_OK");
        String conditionName = "CID" + ++uniqueNumber + "@" + precmdJobname + "@" + this.getJobName();
        if (jobAOK) {
            conditionName = precmdJobname + "@OK";
        }
        Properties outcond = new Properties();
        outcond.setProperty("NAME", FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", conditionName));
        outcond.setProperty("SIGN", "ADD");
        outcond.setProperty("ODATE", "ODAT");
        preCmdJob.addOutCondition(outcond);
        Properties incond = new Properties();
        incond.setProperty("NAME", conditionName);
        incond.setProperty("AND_OR", "AND");
        incond.setProperty("ODATE", "ODAT");
        this.getEntityData().addInCondition(incond);
        preCmdJob.setOptionalAttribute("MAXWAIT", this.maxwait);
        this.preCmdJobs.add(preCmdJob);
        return preCmdJob.getAttr("JOBNAME");
    }

    private void setOptionalAttribute(String name, String value) {
        if (!this.optionalProperties.contains(name)) {
            this.optionalProperties.add(name);
        }
        this.properties.setProperty(name, value);
    }

    public SchedEntity.TYPE type() {
        return this.entityType;
    }

    public String originalProductID() {
        return this.entityData.getEntityID();
    }

    public List<SchedEntity> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
            switch (this.entityType) {
                case SMART_TABLE: 
                case SUB_TABLE: {
                    Enumeration<TreeNode> enumeration = this.entityData.children();
                    while (enumeration.hasMoreElements()) {
                        IAttrHolder jobDetails;
                        AppWorxEntity child = (AppWorxEntity)enumeration.nextElement();
                        HashMap<String, String> filterDetails = new HashMap<String, String>();
                        if (child.getChainDetails() != null) {
                            filterDetails.put("Module", child.getChainDetails().getAttr("so_module_1"));
                            filterDetails.put("Task_name", child.getChainDetails().getAttr("so_task_name"));
                        }
                        if (child.getJobDetails() != null) {
                            jobDetails = child.getJobDetails();
                            if (!filterDetails.containsKey("Module")) {
                                filterDetails.put("Module", jobDetails.getAttr("so_module"));
                                filterDetails.put("Task_name", jobDetails.getAttr("so_module"));
                            }
                            filterDetails.put("Application", jobDetails.getAttr("so_application"));
                            filterDetails.put("Queue", jobDetails.getAttr("so_queue"));
                            filterDetails.put("Command_type", jobDetails.getAttr("so_command_type"));
                            filterDetails.put("Login", jobDetails.getAttr("so_login"));
                        }
                        if (!this.rules.getFilterHandler().isFilter(filterDetails)) continue;
                        jobDetails = child.getJobDetails();
                        if (jobDetails != null && jobDetails.getAttr("so_command_type").equals("CHAIN")) {
                            this.children.add(new AppWorxJob(SchedEntity.TYPE.SUB_TABLE, child, this.rules, this.nodePlatform));
                            continue;
                        }
                        this.children.add(new AppWorxJob(SchedEntity.TYPE.JOB, child, this.rules, this.nodePlatform));
                    }
                    break;
                }
            }
        }
        return this.children;
    }

    public List<AssistingJob> getAssistingJobs() {
        ArrayList<AssistingJob> toRet = new ArrayList<AssistingJob>();
        if (this.type().equals((Object)SchedEntity.TYPE.SMART_TABLE)) {
            toRet.addAll(this.getSchedulingJobs());
        } else if (this.type().equals((Object)SchedEntity.TYPE.SUB_TABLE)) {
            toRet.addAll(this.preCmdJobs);
        }
        return toRet;
    }

    public String getAttr(String attrName) {
        return this.properties.getProperty(attrName);
    }

    public List<Properties> getInConds() {
        return this.entityData.getInCondition();
    }

    public List<Properties> getOutConds() {
        return this.entityData.getOutCondition();
    }

    public List<Properties> getTags() {
        Set<Properties> myRbcs = AppWorxSchedConvertor.instance().getRBCs(this);
        LinkedHashSet<Properties> toRet = new LinkedHashSet<Properties>();
        for (SchedEntity schedEntity : this.getChildren()) {
            for (Properties tag : schedEntity.getTags()) {
                if (GlobalFunctions.isUseParentSchedulingRbc((Properties)tag)) continue;
                toRet.add(tag);
            }
        }
        if (toRet.isEmpty() || myRbcs.size() != 1 || !GlobalFunctions.isUseParentSchedulingRbc((Properties)myRbcs.iterator().next())) {
            toRet.addAll(myRbcs);
        }
        for (Map map : AppWorxSchedConvertor.instance().getMessages(this)) {
            map.forEach((msgId, msgParameters) -> Reporter.addMessage(this.messages, (String)msgId, (String)this.originalProductID(), (String[])msgParameters));
        }
        return new ArrayList<Properties>(toRet);
    }

    protected LinkedHashSet<AssistingJob> getSchedulingJobs() {
        if (this.schedulingJobs == null) {
            this.schedulingJobs = new LinkedHashSet();
        }
        Set<AssistingJob> schedJobs = AppWorxSchedConvertor.instance().getSchedJobs(this);
        this.schedulingJobs.addAll(schedJobs);
        if (this.children != null) {
            for (SchedEntity child : this.children) {
                this.schedulingJobs.addAll(((AppWorxJob)child).getSchedulingJobs());
            }
        }
        return this.schedulingJobs;
    }

    public List<Properties> getQuantResources() {
        return Collections.emptyList();
    }

    public List<Properties> getCtrlResources() {
        return Collections.emptyList();
    }

    public List<Properties> getOnStmt() {
        return this.entityData.getOnStatements();
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        return null;
    }

    public List<Properties> getShouts() {
        return Collections.emptyList();
    }

    public String getJobName() {
        return this.properties.getProperty("JOBNAME");
    }

    public String getOriginalJobName() {
        return this.properties.getProperty("JOBNAME");
    }

    public String getParentName() {
        return this.getTablePathForSons();
    }

    public SchedEntity getParent() {
        return null;
    }

    public String getTablePathForSons() {
        TreeNode[] nodesPath = this.entityData.getPath();
        StringBuilder path = new StringBuilder();
        if (nodesPath != null) {
            for (int index = 1; index < nodesPath.length - 1; ++index) {
                path.append(nodesPath[index].toString());
                if (index >= nodesPath.length - 2) continue;
                path.append("/");
            }
        }
        return path.toString();
    }

    public boolean isValid() {
        return this.validEntity;
    }

    public boolean hasWarnings() {
        if (this.messages.isEmpty()) {
            return false;
        }
        HashMap messageIds = MessageIdTable.instance().getMessageIds();
        return messageIds.keySet().stream().filter(id -> ((MessageId)messageIds.get(id)).getMessageType(id).equals("W")).anyMatch(id -> this.messages.stream().anyMatch(currMessage -> currMessage.startsWith((String)id)));
    }

    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }

    public boolean isDSJob() {
        return true;
    }

    public String getTableName() {
        return this.getJobName();
    }

    public boolean isCyclic() {
        String cyclic = this.properties.getProperty("CYCLIC");
        if (cyclic == null) {
            return false;
        }
        return cyclic.equals("1");
    }

    public String applyFieldConversion(String field) {
        return null;
    }

    public String getApplication() {
        return this.properties.getProperty("APPLICATION");
    }

    public String getGroup() {
        return this.properties.getProperty("GROUP");
    }

    public LinkedHashMap<String, String> getAutoedits() {
        AppWorxVariablesHandler appWorxVariableHandler = new AppWorxVariablesHandler(this.getEntityData(), this.autoedits, this.originalProductID(), this.isScriptJob, this);
        return (LinkedHashMap)appWorxVariableHandler.getVariables();
    }

    public List<String> getOptionalAttributes() {
        return this.optionalProperties;
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    public void addAutoedit(String key, String value) {
        this.autoedits.put(key, value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public SchedEntity.TYPE getEntityType() {
        return this.entityType;
    }

    public void addMessage(String msgId, String ... msgArgs) {
        Reporter.addMessage(this.messages, (String)msgId, (String)this.originalProductID(), (String[])msgArgs);
    }
}

