/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.tng.TngJob;
import com.bmc.ctmconvert.tng.TngTrigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TriggerTable
extends CsvFile {
    private HashMap<String, IAttrHolder> m_Triggers = new HashMap();
    private static TriggerTable m_instance = null;
    private List<TngTrigger> triggersList = new ArrayList<TngTrigger>();

    private TriggerTable() {
    }

    public static TriggerTable instance() {
        if (m_instance == null) {
            m_instance = new TriggerTable();
            m_instance.load();
        }
        return m_instance;
    }

    public static void destroy() {
        m_instance = null;
    }

    public void load() {
        String csvFile = Params.instance().getDatasourcePath() + Globs.DIRSEP + "TRIGGER.csv";
        this.load(csvFile);
    }

    protected void handleRecord(IAttrHolder new_record, int rec_number) {
        String key = TngJob.buildJobIdKey(new_record.getAttr("TRIGGER_ID"), new_record.getAttr("EVENT_ID"), null);
        this.m_Triggers.put(key, new_record);
        TngTrigger tngTrigger = new TngTrigger(new_record.getAttr("TRIGGER_ID"), new_record.getAttr("EVENT_ID"), "NULL");
        this.triggersList.add(tngTrigger);
    }

    public IAttrHolder getTrigger(String triggerId, String eventId) {
        String key = TngJob.buildJobIdKey(triggerId, eventId, null);
        return this.m_Triggers.get(key);
    }

    public TngTrigger getTngTrigger(TngTrigger tngTrigger) {
        TngTrigger trigger = null;
        if (this.triggersList.indexOf(tngTrigger) > -1) {
            trigger = this.triggersList.get(this.triggersList.indexOf(tngTrigger));
        }
        return trigger;
    }
}

