/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TngLineToMap {
    public HashMap<String, String> handleLine(String type, String regexpAttributes, String line) {
        String tmpLine = line.replaceFirst(type, "").trim();
        HashMap<String, String> tmpHM = new HashMap<String, String>();
        this.updateHashMap(regexpAttributes, tmpHM, tmpLine);
        return tmpHM;
    }

    public void updateHashMap(String attributes, HashMap<String, String> tmpHM, String line) {
        String regexp;
        Pattern p;
        Matcher m;
        if (line.matches("PARM[0-9](.*)") && line.matches("(.*)[a-zA-Z]ID(.*)") || line.matches("PARM[0-9]=(\\w+)'")) {
            attributes = attributes.replace("ID", "^ID|\\\\s+ID");
        }
        if ((m = (p = Pattern.compile(regexp = "((" + attributes + "=).*)\\s+((" + attributes + "))=(.*)")).matcher(line)).matches()) {
            String rest = m.group(1);
            String key = m.group(3);
            String value = m.group(5);
            value = TngLineToMap.replaceSpecialCharacters(key, value);
            tmpHM.put(key, value);
            this.updateHashMap(attributes, tmpHM, rest);
            return;
        }
        regexp = "^(" + attributes + ")=(.*)";
        p = Pattern.compile(regexp);
        m = p.matcher(line);
        if (m.matches()) {
            String key = m.group(1);
            String value = m.group(2);
            value = TngLineToMap.replaceSpecialCharacters(key, value);
            tmpHM.put(key, value);
        }
    }

    public static String replaceSpecialCharacters(String key, String value) {
        String newValue = value;
        if (key.startsWith("PARM")) {
            newValue = newValue.replace("\\'", "'");
            newValue = newValue.replace("\\\\", "\\");
        } else {
            newValue = newValue.replace('\'', '\"');
        }
        return newValue;
    }
}

