/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TngCalendars {
    private ArrayList<CtmCalendar> convertedCalendars = null;
    private final ArrayList<String> failedConversions = new ArrayList();
    private ArrayList<Properties> sourceCalendars = null;
    private final HashMap<String, ArrayList<String>> suspectRules = new HashMap();
    private final HashMap<String, String> confCals = new HashMap();
    private final HashMap<String, HashMap<String, ArrayList<String[]>>> calendarMessages = new HashMap();
    private String sourceFile = null;
    private String datacenter = null;
    private static final String CALENDAR_DECLARATION = "define cal";
    private static final String weekDaysExpr = "(sun|mon|tues?|wed(n(es)?)?|thu(rs?)?|fri|sat(ur?)?)(days?)?";
    private static final String monthsExpr = "(jan(uary)?|feb(ruary)?|mar(ch)?|apr(il)?|may|jun(e)?|jul(y)?|aug(ust)?|sep(tember)?|oct(ober)?|nov(ember)?|dec(ember)?)";
    private static final String[] ignoredRulesExprs = new String[]{"settime", "settime (on|off|invert)", "[0-9]{3,4}-[0-9]{3,4} (on|off|invert)", "stend"};
    private static final String CAL_NAME = "name";
    private static final String CAL_DESC = "desc";
    private static final String CAL_RULES = "rules";

    public TngCalendars(String sourceFileName, String datacenter) throws IOException {
        this.sourceFile = sourceFileName;
        this.datacenter = datacenter;
        this.sourceCalendars = new ArrayList();
        this.readCalendars();
    }

    private void readCalendars() throws IOException {
        FileInputStream sourceStream = new FileInputStream(this.sourceFile);
        Scanner sourceScanner = new Scanner(sourceStream);
        String currId = null;
        String currSet = null;
        String currDesc = null;
        Pattern pattern = Pattern.compile("(.*)(id|set|desc)=(.*)");
        while (sourceScanner.hasNext()) {
            String line = sourceScanner.nextLine().trim();
            if (line.toLowerCase().contains(CALENDAR_DECLARATION)) {
                if (currId != null && currSet != null) {
                    Properties toAdd = new Properties();
                    toAdd.put(CAL_NAME, currId);
                    toAdd.put(CAL_DESC, currDesc == null ? "" : currDesc);
                    toAdd.put(CAL_RULES, currSet);
                    this.sourceCalendars.add(toAdd);
                }
                currId = null;
                currSet = null;
                currDesc = null;
            }
            Matcher matcher = pattern.matcher(line);
            while (matcher.matches()) {
                line = matcher.group(1).trim();
                String key = matcher.group(2).trim();
                String value = matcher.group(3).trim();
                matcher = pattern.matcher(line);
                if (value.startsWith("\"") || value.startsWith("'") || value.startsWith("(")) {
                    value = value.substring(1, value.length() - 1);
                }
                if (key.equalsIgnoreCase("id")) {
                    currId = value;
                }
                if (key.equalsIgnoreCase("set")) {
                    currSet = value;
                }
                if (!key.equalsIgnoreCase(CAL_DESC)) continue;
                currDesc = value;
            }
        }
        if (currId != null && currSet != null) {
            Properties toAdd = new Properties();
            toAdd.put(CAL_NAME, currId);
            toAdd.put(CAL_DESC, currDesc == null ? "" : currDesc);
            toAdd.put(CAL_RULES, currSet);
            this.sourceCalendars.add(toAdd);
        }
        sourceStream.close();
        sourceScanner.close();
    }

    public void convert(int startYear, int endYear) throws FileNotFoundException {
        this.convertedCalendars = new ArrayList();
        for (Properties currProps : this.sourceCalendars) {
            CtmCalendar currCal = new CtmCalendar((String)currProps.get(CAL_NAME), this.datacenter);
            currCal.setDescription((String)currProps.get(CAL_DESC));
            String[] rules = currProps.getProperty(CAL_RULES).split("\\)[\t ]*,[\t ]*\\(");
            if (rules[0].startsWith("(")) {
                rules[0] = rules[0].substring(1);
            }
            if (rules[rules.length - 1].endsWith(")")) {
                rules[rules.length - 1] = rules[rules.length - 1].substring(0, rules[rules.length - 1].length() - 1);
            }
            for (int i = 0; i < rules.length; ++i) {
                rules[i] = rules[i].trim();
                while (rules[i].startsWith("\"") || rules[i].startsWith("'") || rules[i].startsWith("(")) {
                    rules[i] = rules[i].substring(1).trim();
                }
                while (rules[i].endsWith("\"") || rules[i].endsWith("'") || rules[i].endsWith(")")) {
                    rules[i] = rules[i].substring(0, rules[i].length() - 1).trim();
                }
                boolean ignored = false;
                for (int j = 0; j < ignoredRulesExprs.length; ++j) {
                    if (!rules[i].toLowerCase().matches(ignoredRulesExprs[j])) continue;
                    ignored = true;
                }
                if (ignored) continue;
                if (rules[i].toLowerCase().matches(".+ (on|off|invert)")) {
                    String action = rules[i].substring(rules[i].lastIndexOf(32)).trim();
                    String subject = rules[i].substring(0, rules[i].lastIndexOf(32)).trim();
                    try {
                        ArrayList<int[]> subjectDates = this.subject2dates(subject, startYear, endYear);
                        for (int[] currDate : subjectDates) {
                            if (action.equalsIgnoreCase("ON")) {
                                currCal.addDay(currDate[2], currDate[1], currDate[0]);
                            }
                            if (action.equalsIgnoreCase("OFF")) {
                                currCal.removeDay(currDate[2], currDate[1], currDate[0]);
                            }
                            if (!action.equalsIgnoreCase("INVERT")) continue;
                            currCal.invertDay(currDate[2], currDate[1], currDate[0]);
                        }
                        continue;
                    }
                    catch (CalendarRuleException e) {
                        this.addSuspect((String)currProps.get(CAL_NAME), rules[i]);
                        continue;
                    }
                }
                this.addSuspect((String)currProps.get(CAL_NAME), rules[i]);
            }
            this.convertedCalendars.add(currCal);
        }
        this.validateDependencies();
    }

    private void validateDependencies() {
        for (String suspectCal : this.suspectRules.keySet()) {
            Object msgElements;
            HashMap<String, String> depMap = new HashMap<String, String>();
            boolean isMultipleDependency = false;
            boolean isSecondaryDependency = false;
            boolean isLastUseOff = true;
            String confCal = null;
            if (this.calendarMessages.get(suspectCal) == null) {
                this.calendarMessages.put(suspectCal, new HashMap());
            }
            HashMap<String, ArrayList<String[]>> suspectCalMessages = this.calendarMessages.get(suspectCal);
            for (String suspect : this.suspectRules.get(suspectCal)) {
                if (!suspect.toLowerCase().matches(".+ (off|on|invert)")) continue;
                depMap.put(suspect.substring(0, suspect.indexOf(32)), suspect.substring(suspect.lastIndexOf(32) + 1));
                confCal = suspect.substring(0, suspect.indexOf(32));
            }
            if (depMap.keySet().size() > 1) {
                msgElements = new String[3];
                isMultipleDependency = true;
                StringBuilder tmpMsg = new StringBuilder();
                tmpMsg.append(suspectCal);
                tmpMsg.append(' ');
                tmpMsg.append("depends on multiple external calendars: ");
                for (String tmpCal : depMap.keySet()) {
                    tmpMsg.append(tmpCal);
                    tmpMsg.append(", ");
                }
                tmpMsg.replace(tmpMsg.lastIndexOf(","), tmpMsg.length(), ".");
                msgElements[0] = suspectCal;
                msgElements[1] = confCal;
                msgElements[2] = tmpMsg.toString();
                if (suspectCalMessages.get("WRN0008") == null) {
                    suspectCalMessages.put("WRN0008", new ArrayList());
                }
                suspectCalMessages.get("WRN0008").add((String[])msgElements);
            }
            for (String currDep : depMap.keySet()) {
                StringBuilder tmpMsg;
                String[] msgElements2;
                if (!((String)depMap.get(currDep)).equalsIgnoreCase("OFF")) {
                    msgElements2 = new String[3];
                    isLastUseOff = false;
                    tmpMsg = new StringBuilder();
                    tmpMsg.append("Last application  of dependency ");
                    tmpMsg.append(currDep);
                    tmpMsg.append(" is with action ");
                    tmpMsg.append((String)depMap.get(currDep));
                    tmpMsg.append(". Last action must be \"OFF\" in order to correctly convert  calendar");
                    msgElements2[0] = suspectCal;
                    msgElements2[1] = confCal;
                    msgElements2[2] = tmpMsg.toString();
                    if (suspectCalMessages.get("ERR0003") == null) {
                        suspectCalMessages.put("ERR0003", new ArrayList());
                    }
                    suspectCalMessages.get("ERR0003").add(msgElements2);
                }
                if (!this.suspectRules.containsKey(currDep)) continue;
                msgElements2 = new String[3];
                tmpMsg = new StringBuilder();
                tmpMsg.append(suspectCal);
                tmpMsg.append(" dependeds on ");
                tmpMsg.append(currDep);
                tmpMsg.append(" which also uses external dependency");
                isSecondaryDependency = true;
                msgElements2[0] = suspectCal;
                msgElements2[1] = confCal;
                msgElements2[2] = tmpMsg.toString();
                if (suspectCalMessages.get("WRN0008") == null) {
                    suspectCalMessages.put("WRN0008", new ArrayList());
                }
                suspectCalMessages.get("WRN0008").add(msgElements2);
            }
            if (isSecondaryDependency || !isLastUseOff || isMultipleDependency) {
                ArrayList<CtmCalendar> tmpCalList = new ArrayList<CtmCalendar>();
                this.failedConversions.add(suspectCal);
                for (CtmCalendar currCtmCal : this.convertedCalendars) {
                    if (currCtmCal.getName().equals(suspectCal)) continue;
                    tmpCalList.add(currCtmCal);
                }
                this.convertedCalendars = tmpCalList;
                continue;
            }
            if (confCal == null) continue;
            msgElements = new String[]{suspectCal, "not-" + confCal};
            if (suspectCalMessages.get("INF1003") == null) {
                suspectCalMessages.put("INF1003", new ArrayList());
            }
            suspectCalMessages.get("INF1003").add((String[])msgElements);
            this.confCals.put(suspectCal, confCal);
        }
    }

    private void addSuspect(String calName, String suspect) {
        if (!this.suspectRules.containsKey(calName)) {
            this.suspectRules.put(calName, new ArrayList());
        }
        this.suspectRules.get(calName).add(suspect);
    }

    public void writeResults() throws IOException {
        if (this.convertedCalendars == null) {
            return;
        }
        try (DefCalFile defcal = DefCalFile.createDefCalFile();){
            for (CtmCalendar currCal : this.convertedCalendars) {
                defcal.write(currCal, true);
                defcal.write(currCal, false);
            }
        }
    }

    private ArrayList<int[]> subject2dates(String subject, int startYear, int endYear) throws CalendarRuleException {
        ArrayList<int[]> toRet = new ArrayList<int[]>();
        for (int currYear = startYear; currYear <= endYear; ++currYear) {
            toRet.addAll(this.applySubject(subject.toLowerCase(), currYear));
        }
        return toRet;
    }

    private ArrayList<int[]> applySubject(String subject, int year) throws CalendarRuleException {
        if (subject.matches("([0-9]+|\\*)/([0-9]+|\\*)")) {
            return this.date2dates(subject, year);
        }
        if (subject.matches("(jan(uary)?|feb(ruary)?|mar(ch)?|apr(il)?|may|jun(e)?|jul(y)?|aug(ust)?|sep(tember)?|oct(ober)?|nov(ember)?|dec(ember)?) every (sun|mon|tues?|wed(n(es)?)?|thu(rs?)?|fri|sat(ur?)?)(days?)?")) {
            return this.monthDays2dates(subject, year);
        }
        if (subject.matches(weekDaysExpr)) {
            return this.day2dates(subject, year);
        }
        if (subject.matches(monthsExpr)) {
            return this.month2dates(subject, year);
        }
        if (subject.matches("week(day|end)s")) {
            return this.dayRange2dates(subject, year);
        }
        if (subject.equals("all")) {
            return this.all2dates(year);
        }
        throw new CalendarRuleException(subject);
    }

    private ArrayList<int[]> monthDays2dates(String subject, int year) {
        ArrayList<int[]> toRet = new ArrayList<int[]>();
        GregorianCalendar tmpCal = new GregorianCalendar(year, 0, 1);
        Pattern pattern = Pattern.compile("(.+) every (.+)");
        Matcher matcher = pattern.matcher(subject);
        matcher.matches();
        String monthStr = matcher.group(1).trim().substring(0, 3).toUpperCase();
        String weekDayStr = matcher.group(2).trim().substring(0, 3).toUpperCase();
        int monthInt = GlobalFunctions.getMonthIndex((String[])GlobalFunctions.getMonthsArray(), (String)monthStr) - 1;
        int weekDayInt = GlobalFunctions.getDayOfTheWeekIndex((String[])GlobalFunctions.getWeekDaysArray((String)"SUN"), (String)weekDayStr) + 1;
        while (tmpCal.get(1) == year && monthInt >= tmpCal.get(2)) {
            while (tmpCal.get(2) < monthInt) {
                tmpCal.add(2, 1);
            }
            while (tmpCal.get(7) != weekDayInt) {
                tmpCal.add(5, 1);
            }
            int[] currDate = new int[]{tmpCal.get(5), tmpCal.get(2) + 1, year};
            toRet.add(currDate);
            tmpCal.add(5, 7);
        }
        return toRet;
    }

    private ArrayList<int[]> date2dates(String subject, int year) {
        ArrayList<int[]> toRet = new ArrayList<int[]>();
        String monthStr = subject.substring(0, subject.indexOf(47));
        String dayStr = subject.substring(subject.indexOf(47) + 1);
        if (subject.contains("*")) {
            dayStr = !dayStr.contains("*") ? String.format("%02d", Integer.valueOf(dayStr)) : dayStr.replace("*", "[0-9]+");
            monthStr = !monthStr.contains("*") ? String.format("%02d", Integer.valueOf(monthStr)) : monthStr.replace("*", "[0-9]+");
            String expr = String.format("%s/%s", monthStr, dayStr);
            GregorianCalendar tmpCal = new GregorianCalendar(year, 0, 1);
            while (tmpCal.get(1) == year) {
                if (String.format("%02d/%02d", tmpCal.get(2) + 1, tmpCal.get(5)).matches(expr)) {
                    int[] currDate = new int[]{tmpCal.get(5), tmpCal.get(2) + 1, year};
                    toRet.add(currDate);
                }
                tmpCal.add(5, 1);
            }
        } else {
            int[] currDate = new int[]{Integer.parseInt(dayStr), Integer.parseInt(monthStr), year};
            toRet.add(currDate);
        }
        return toRet;
    }

    private ArrayList<int[]> day2dates(String subject, int year) {
        ArrayList<int[]> toRet = new ArrayList<int[]>();
        if (subject.length() > 3) {
            subject = subject.substring(0, 3);
        }
        subject = subject.toUpperCase();
        int dayInt = GlobalFunctions.getDayOfTheWeekIndex((String[])GlobalFunctions.getWeekDaysArray((String)"SUN"), (String)subject) + 1;
        GregorianCalendar tmpCal = new GregorianCalendar(year, 0, 1);
        while (tmpCal.get(1) == year) {
            while (tmpCal.get(7) != dayInt) {
                tmpCal.add(5, 1);
            }
            int[] currDate = new int[]{tmpCal.get(5), tmpCal.get(2) + 1, year};
            toRet.add(currDate);
            tmpCal.add(5, 7);
        }
        return toRet;
    }

    private ArrayList<int[]> month2dates(String subject, int year) {
        ArrayList<int[]> toRet = new ArrayList<int[]>();
        if (subject.length() > 3) {
            subject = subject.substring(0, 3);
        }
        int monthInt = GlobalFunctions.getMonthIndex((String[])GlobalFunctions.getMonthsArray(), (String)subject.toUpperCase());
        GregorianCalendar tmpCal = new GregorianCalendar(year, --monthInt, 1);
        while (tmpCal.get(2) == monthInt) {
            int[] currDate = new int[]{tmpCal.get(5), tmpCal.get(2) + 1, year};
            toRet.add(currDate);
            tmpCal.add(5, 1);
        }
        return toRet;
    }

    private ArrayList<int[]> all2dates(int year) {
        ArrayList<int[]> toRet = new ArrayList<int[]>();
        GregorianCalendar tmpCal = new GregorianCalendar(year, 0, 1);
        while (tmpCal.get(1) == year) {
            int[] currDate = new int[]{tmpCal.get(5), tmpCal.get(2) + 1, year};
            toRet.add(currDate);
            tmpCal.add(5, 1);
        }
        return toRet;
    }

    private ArrayList<int[]> dayRange2dates(String subject, int year) {
        ArrayList<int[]> toRet = new ArrayList<int[]>();
        GregorianCalendar tmpCal = new GregorianCalendar(year, 0, 1);
        boolean isWeekends = subject.equals("weekends");
        while (tmpCal.get(1) == year) {
            int currWeekDay = tmpCal.get(7);
            if ((currWeekDay == 7 || currWeekDay == 1) && isWeekends || currWeekDay != 7 && currWeekDay != 1 && !isWeekends) {
                int[] currDate = new int[]{tmpCal.get(5), tmpCal.get(2) + 1, year};
                toRet.add(currDate);
            }
            tmpCal.add(5, 1);
        }
        return toRet;
    }

    public boolean wasConverted(String calName) {
        for (CtmCalendar curCtmCal : this.convertedCalendars) {
            if (!curCtmCal.getName().equals(calName)) continue;
            return true;
        }
        return false;
    }

    public boolean wasDefined(String calName) {
        return this.failedConversions.contains(calName) || this.wasConverted(calName);
    }

    public HashMap<String, ArrayList<String[]>> getCalendarMessages(String calName) {
        return this.calendarMessages.get(calName);
    }

    public ArrayList<String> getFailed() {
        return this.failedConversions;
    }

    public String getConf(String cal) {
        return this.confCals.get(cal);
    }

    private class CalendarRuleException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private String rule;

        public CalendarRuleException(String rule) {
            this.setRule(rule);
        }

        public void setRule(String rule) {
            this.rule = rule;
        }

        public String getRule() {
            return this.rule;
        }
    }

    public class NamedCalendar {
        private final String name;
        private HashMap<String, ArrayList<String[]>> messages;
        private boolean defined = false;
        private boolean converted = false;
        private NamedCalendar dependsOn = null;

        public NamedCalendar(TngCalendars this$0, String name, TngCalendars allCals) {
            this.name = name;
            this.defined = allCals.wasDefined(name);
            if (this.defined) {
                this.converted = allCals.wasConverted(name);
            }
            if (this.defined) {
                if (allCals.getConf(name) != null) {
                    this.dependsOn = new NamedCalendar(this$0, allCals.getConf(name), allCals);
                }
                this.messages = allCals.getCalendarMessages(name);
            }
        }

        public String getName() {
            return this.name;
        }

        public HashMap<String, ArrayList<String[]>> getMessages() {
            return this.messages == null ? new HashMap<String, ArrayList<String[]>>() : this.messages;
        }

        public boolean isConverted() {
            return this.converted;
        }

        public boolean isDefined() {
            return this.defined;
        }

        public NamedCalendar getDependsOn() {
            return this.dependsOn;
        }
    }
}

