/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.tng.TngJob;
import com.bmc.ctmconvert.tng.TngSuccessorJob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JobTable
extends CsvFile {
    private HashMap<String, AttrHolderList> m_jobs = new HashMap();
    private static JobTable m_instance = null;
    private HashMap<String, IAttrHolder> m_jobList = new HashMap();
    private static Integer m_headerSize = 0;
    private static HashMap<String, Integer> m_header = new HashMap();
    private List<TngSuccessorJob> succecessorList = new ArrayList<TngSuccessorJob>();

    private JobTable() {
    }

    public void load() {
        String csvFile = Params.instance().getDatasourcePath() + Globs.DIRSEP + "JOB.csv";
        this.load(csvFile);
        m_headerSize = this.m_header2Index.size();
        m_header = this.m_header2Index;
    }

    public static JobTable instance() {
        if (m_instance == null) {
            m_instance = new JobTable();
            m_instance.load();
        }
        return m_instance;
    }

    public static void destroy() {
        m_instance = null;
    }

    public HashMap<String, AttrHolderList> getJobs() {
        return this.m_jobs;
    }

    public List<TngSuccessorJob> getTNGSuccessorList() {
        return this.succecessorList;
    }

    public TngSuccessorJob getTngSuccsorJob(TngSuccessorJob job) {
        TngSuccessorJob retVal = null;
        int index = this.succecessorList.indexOf(job);
        if (index > -1) {
            retVal = this.succecessorList.get(index);
        }
        return retVal;
    }

    public String getJno(TngSuccessorJob job, String successorJobName) {
        String retVal = null;
        int index = this.succecessorList.indexOf(job);
        if (index > -1) {
            List<TngSuccessorJob> subLsit = this.succecessorList.subList(index + 1, this.succecessorList.size() - 1);
            if (subLsit.indexOf(job) > -1) {
                String predecessorJobName = job.getJobId().equals("NULL") ? job.getSetId() : job.getJobId();
                TngJob.addReporterMessage("WRN1003", job.getSetId(), job.getJobId(), job.getJnoId(), predecessorJobName, successorJobName);
            } else {
                TngSuccessorJob successorJob = this.succecessorList.get(index);
                retVal = successorJob.getJnoId();
            }
        }
        return retVal;
    }

    protected void handleRecord(IAttrHolder new_record, int rec_number) {
        TngSuccessorJob successorJob = new TngSuccessorJob(new_record.getAttr("JOBSET_ID"), new_record.getAttr("JOB_ID"), new_record.getAttr("JNO_ID"));
        successorJob.setCrithact(new_record.getAttr("CRITHACT"));
        successorJob.setCritkeys(new_record.getAttr("CRITKEYS"));
        this.succecessorList.add(successorJob);
        String key = TngJob.buildJobIdKey(new_record.getAttr("JOBSET_ID"), new_record.getAttr("JOB_ID"), new_record.getAttr("JNO_ID"));
        this.m_jobList.put(key, new_record);
        AttrHolderList list = null;
        list = this.m_jobs.get(new_record.getAttr("JOBSET_ID"));
        if (list == null) {
            list = new AttrHolderList();
            this.m_jobs.put(new_record.getAttr("JOBSET_ID"), list);
        }
        list.add((Object)new_record);
    }

    public Integer getJobHeaderSize() {
        return m_headerSize;
    }

    public Integer getJobAttrIndex(String attr) {
        return m_header.get(attr);
    }

    public void appendJobAttributes(String[] jobAttributes) {
        int rec_number = this.m_jobList.size();
        this.handleRecord((IAttrHolder)new AttrHolder(jobAttributes, m_header), rec_number);
    }
}

