/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.tng.TngGlobals;
import com.bmc.ctmconvert.tng.TngJob;
import com.bmc.ctmconvert.tng.TngPredecessorJob;
import com.bmc.ctmconvert.tng.TngSuccessorJob;
import com.bmc.ctmconvert.tng.TngTrigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class JobPredTable
extends CsvFile {
    private HashMap<String, AttrHolderList> m_jobPredListByJob = new HashMap();
    private HashMap<String, AttrHolderList> m_jobPredListByPJob = new HashMap();
    private HashMap<String, AttrHolderList> m_jobPredListForTriggers = new HashMap();
    private HashMap<String, AttrHolderList> m_jobPredListOutCondByJob = new HashMap();
    private static JobPredTable m_instance = null;
    private static Integer m_headerSize = 0;
    private static HashMap<String, Integer> m_header = new HashMap();
    private List<TngSuccessorJob> succecessorList = new ArrayList<TngSuccessorJob>();
    private List<TngSuccessorJob> succecessorJobsTriggerList = new ArrayList<TngSuccessorJob>();

    private JobPredTable() {
    }

    public static JobPredTable instance() {
        if (m_instance == null) {
            m_instance = new JobPredTable();
            m_instance.load();
        }
        return m_instance;
    }

    public static void destroy() {
        m_instance = null;
    }

    public void load() {
        String csvFile = Params.instance().getDatasourcePath() + Globs.DIRSEP + "JOBPRED.csv";
        this.load(csvFile);
        m_headerSize = this.m_header2Index.size();
        m_header = this.m_header2Index;
    }

    public List<TngSuccessorJob> getTNGSuccessorList() {
        return this.succecessorList;
    }

    public List<TngSuccessorJob> getTNGJobTriggersList() {
        return this.succecessorJobsTriggerList;
    }

    private TngSuccessorJob handleTriggerObj(TngSuccessorJob successorJob, TngTrigger trigger) {
        if (successorJob.getTriggerList() != null && !successorJob.getTriggerList().contains(trigger)) {
            successorJob.getTriggerList().add(trigger);
        } else if (successorJob.getTriggerList() == null) {
            ArrayList<TngTrigger> triggerList = new ArrayList<TngTrigger>();
            triggerList.add(trigger);
            successorJob.setTriggerList(triggerList);
        } else {
            successorJob.getTriggerList().add(trigger);
        }
        return successorJob;
    }

    public void addJobsToTriggerList(String trid, String trev, TngSuccessorJob successorJob) {
        int index = -1;
        TngTrigger trigger = new TngTrigger(trid, trev, successorJob.getWorkday());
        if (this.succecessorJobsTriggerList.contains(successorJob)) {
            index = this.succecessorJobsTriggerList.indexOf(successorJob);
            successorJob = this.succecessorJobsTriggerList.get(index);
            successorJob = this.handleTriggerObj(successorJob, trigger);
        } else {
            successorJob.setTrigger(true);
            if (successorJob.getTriggerList() != null) {
                if (!successorJob.getTriggerList().contains(trid)) {
                    successorJob.getTriggerList().add(trigger);
                }
            } else if (successorJob.getTriggerList() == null) {
                ArrayList<TngTrigger> triggerList = new ArrayList<TngTrigger>();
                triggerList.add(trigger);
                successorJob.setTriggerList(triggerList);
            } else {
                successorJob.getTriggerList().add(trigger);
            }
        }
        this.succecessorJobsTriggerList.add(successorJob);
    }

    public void addJobs(String[] jobPredAttributes) {
        this.handleJob((IAttrHolder)new AttrHolder(jobPredAttributes, m_header));
    }

    public void handleJob(IAttrHolder new_record) {
        TngSuccessorJob successorJob = new TngSuccessorJob(new_record.getAttr("JOBSET_ID"), new_record.getAttr("JOB_ID"), new_record.getAttr("JNO_ID"), new_record.getAttr("TRID"), new_record.getAttr("TREV"));
        successorJob.setWorkday(new_record.getAttr("WORKDAY"));
        successorJob.setCrithact("NULL");
        successorJob.setCritkeys("NULL");
        TngPredecessorJob predecessorJob = new TngPredecessorJob(new_record.getAttr("PSET"), new_record.getAttr("PJOB"), new_record.getAttr("PJNO"), "NULL", "NULL");
        predecessorJob.setWorkday(new_record.getAttr("WORKDAY"));
        predecessorJob.setTrid(new_record.getAttr("TRID"));
        if (new_record.getAttr("TREV").equalsIgnoreCase(TngGlobals.EVENT_CLOSE_FILE)) {
            this.addJobsToTriggerList(new_record.getAttr("TRID"), new_record.getAttr("TREV"), successorJob);
        }
        if (!this.succecessorList.contains(successorJob)) {
            ArrayList<TngPredecessorJob> predecessorJobsList = new ArrayList<TngPredecessorJob>();
            predecessorJobsList.add(predecessorJob);
            successorJob.setPredecessorList(predecessorJobsList);
            this.succecessorList.add(successorJob);
        } else if (!this.succecessorList.get(this.succecessorList.indexOf(successorJob)).getPredecessorList().contains(predecessorJob)) {
            this.succecessorList.get(this.succecessorList.indexOf(successorJob)).getPredecessorList().add(predecessorJob);
        }
    }

    protected void handleRecord(IAttrHolder new_record, int rec_number) {
        this.handleJob(new_record);
        if (!new_record.getAttr("PSET").equalsIgnoreCase("NULL")) {
            this.updateListByJob(new_record);
            this.updateListByPJob(new_record);
        }
        if (new_record.getAttr("TREV").equalsIgnoreCase(TngGlobals.EVENT_IN_COND)) {
            this.updateListByJob(new_record);
        }
        if (new_record.getAttr("TREV").equalsIgnoreCase(TngGlobals.EVENT_OUT_COND)) {
            this.updateListForOutCondsByJob(new_record);
        }
        if (new_record.getAttr("TREV").equalsIgnoreCase(TngGlobals.EVENT_CLOSE_FILE)) {
            this.updateListForTriggers(new_record);
        }
    }

    private void updateListByJob(IAttrHolder new_record) {
        AttrHolderList list = null;
        String key = TngJob.buildJobIdKey(new_record.getAttr("JOBSET_ID"), new_record.getAttr("JOB_ID"), new_record.getAttr("JNO_ID"));
        list = this.m_jobPredListByJob.get(key);
        if (list == null) {
            list = new AttrHolderList();
            this.m_jobPredListByJob.put(key, list);
        }
        list.add((Object)new_record);
    }

    private void updateListByPJob(IAttrHolder new_record) {
        String key = TngJob.buildJobIdKey(new_record.getAttr("PSET"), new_record.getAttr("PJOB"), new_record.getAttr("PJNO"));
        AttrHolderList list = null;
        list = this.m_jobPredListByPJob.get(key);
        if (list == null) {
            list = new AttrHolderList();
            this.m_jobPredListByPJob.put(key, list);
        }
        list.add((Object)new_record);
    }

    private void updateListForOutCondsByJob(IAttrHolder new_record) {
        AttrHolderList list = null;
        String key = TngJob.buildJobIdKey(new_record.getAttr("JOBSET_ID"), new_record.getAttr("JOB_ID"), new_record.getAttr("JNO_ID"));
        list = this.m_jobPredListOutCondByJob.get(key);
        if (list == null) {
            list = new AttrHolderList();
            this.m_jobPredListOutCondByJob.put(key, list);
        }
        list.add((Object)new_record);
    }

    private void updateListForTriggers(IAttrHolder new_record) {
        AttrHolderList list = null;
        String key = TngJob.buildJobIdKey(new_record.getAttr("JOBSET_ID"), new_record.getAttr("JOB_ID"), new_record.getAttr("JNO_ID"));
        list = this.m_jobPredListForTriggers.get(key);
        if (list == null) {
            list = new AttrHolderList();
            this.m_jobPredListForTriggers.put(key, list);
        }
        list.add((Object)new_record);
    }

    public Set<String> getJobPredTriggerJobsList() {
        Set<String> keySet = this.m_jobPredListForTriggers.keySet();
        return keySet;
    }

    public AttrHolderList getJobPredTriggersForJob(String key) {
        AttrHolderList list = this.m_jobPredListForTriggers.get(key);
        return list;
    }

    public Integer getJobPredHeaderSize() {
        return m_headerSize;
    }

    public Integer getJobPredAttrIndex(String attr) {
        return m_header.get(attr);
    }
}

