/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tng;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.tng.JobPredTable;
import com.bmc.ctmconvert.tng.JobSetPredTable;
import com.bmc.ctmconvert.tng.JobSetTable;
import com.bmc.ctmconvert.tng.JobTable;
import com.bmc.ctmconvert.tng.TngGeneralJob;
import com.bmc.ctmconvert.tng.TngGlobals;
import com.bmc.ctmconvert.tng.TngJob;
import com.bmc.ctmconvert.tng.TngPredecessorJob;
import com.bmc.ctmconvert.tng.TngSuccessorJob;
import com.bmc.ctmconvert.tng.TngTrigger;
import com.bmc.ctmconvert.tng.TriggerTable;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;

public class DependenciesConvertor {
    private RulesDataSet rules = null;
    private static DependenciesConvertor instance;
    private static LinkedHashMap<TngGeneralJob, LinkedHashSet<Properties>> inConds;
    private static LinkedHashMap<TngGeneralJob, LinkedHashSet<Properties>> outConds;
    public static LinkedHashMap<String, LinkedHashSet<Properties>> triggerConds;
    private boolean outCondForAllDaysIND = false;
    private boolean createDummyJobs = false;
    private static String ruleFormat;
    private static boolean deleteCondition;
    private static boolean fWJobPerTrigger;
    private static boolean fwAvailable;
    private PRIOR_HANDLING priorHandling = null;
    private PRIOR_HANDLING_PREV_EVERYDAY priorHandlingPrevEveryday = PRIOR_HANDLING_PREV_EVERYDAY.ANY;

    private DependenciesConvertor() {
        this.rules = RuleManager.instance().getCurrentRules();
        inConds = new LinkedHashMap();
        outConds = new LinkedHashMap();
        triggerConds = new LinkedHashMap();
        ruleFormat = this.rules.getStringRule("TNG rules", new String[]{"CONDITION_CONVENTION_FORMAT", "FORMAT"});
        deleteCondition = this.rules.getBooleanRule("TNG rules", new String[]{"CLEANUP_CONDITIONS"});
        fWJobPerTrigger = this.rules.getBooleanRule("TNG rules", new String[]{"FW_JOB_PER_TRIGGER"});
        fwAvailable = this.rules.getBooleanRule("TNG rules", new String[]{"FW_AVAILABLE"});
        this.getPriorHandling();
        this.mapConditions();
    }

    public static DependenciesConvertor instance() {
        if (instance == null) {
            instance = new DependenciesConvertor();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    public static boolean isDirectJob() {
        return RuleManager.instance().getCurrentRules().getStringRule("TNG rules", new String[]{"CONDITION_CONVENTION_FORMAT", "FORMAT_OPTIONS"}).contains(TngGlobals.FORMAT_TYPE_TO);
    }

    public String getInCondName(TngSuccessorJob job, String triggerName) {
        if (job.getJobId() == null || job.getJobId().equalsIgnoreCase("NULL")) {
            job.setJobId(job.getSetId());
        }
        String retName = "";
        if (inConds.containsKey(job)) {
            LinkedHashSet<Properties> prop = inConds.get(job);
            for (Properties localProp : prop) {
                String name = localProp.getProperty("NAME");
                String trigJobName = localProp.getProperty(TngGlobals.TRIGGER_NAME);
                if (trigJobName == null || !trigJobName.equals(triggerName)) continue;
                retName = name;
                break;
            }
        }
        return retName;
    }

    private LinkedHashSet<Properties> returnFixedValue(LinkedHashSet<Properties> tmpProps) {
        for (Properties outcond : tmpProps) {
            String name = outcond.getProperty("NAME");
            String newIncondName = FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", name);
            if (newIncondName.compareTo(name) == 0) continue;
            outcond.remove("NAME");
            outcond.put("NAME", newIncondName);
        }
        return tmpProps;
    }

    public ArrayList<Properties> getOutConds(TngJob job) {
        LinkedHashSet<Properties> tmpProps;
        if (job.type() == SchedEntity.TYPE.SMART_TABLE) {
            TngPredecessorJob predecessorFolder = new TngPredecessorJob(job.getOriginalJobSet(), job.getOriginalJobSet(), "NULL");
            tmpProps = DependenciesConvertor.isDirectJob() ? outConds.get(predecessorFolder) : outConds.get(new TngSuccessorJob(job.getOriginalJobSet(), job.getOriginalJobSet(), "NULL"));
        } else {
            TngPredecessorJob predecessorJob = new TngPredecessorJob(job.getOriginalJobSet(), job.getOriginalJobName(), job.getOriginalJobNumber());
            tmpProps = DependenciesConvertor.isDirectJob() ? outConds.get(predecessorJob) : outConds.get(new TngSuccessorJob(job.getOriginalJobSet(), job.getOriginalJobName(), job.getOriginalJobNumber()));
        }
        return tmpProps == null ? null : new ArrayList<Properties>(this.returnFixedValue(tmpProps));
    }

    public ArrayList<Properties> getInconds(TngJob job) {
        TngSuccessorJob successorFolder = null;
        TngSuccessorJob successorJob = null;
        LinkedHashSet<Properties> tmpProps = null;
        if (job.type() == SchedEntity.TYPE.SMART_TABLE) {
            successorFolder = new TngSuccessorJob(job.getOriginalJobSet(), job.getOriginalJobSet(), "NULL");
            tmpProps = DependenciesConvertor.isDirectJob() ? inConds.get(successorFolder) : inConds.get(successorFolder);
        } else {
            successorJob = new TngSuccessorJob(job.getOriginalJobSet(), job.getOriginalJobName(), job.getOriginalJobNumber());
            tmpProps = DependenciesConvertor.isDirectJob() ? inConds.get(successorJob) : inConds.get(successorJob);
        }
        return tmpProps == null ? null : new ArrayList<Properties>(this.returnFixedValue(tmpProps));
    }

    private void mapConditions() {
        List<TngSuccessorJob> list;
        List<TngSuccessorJob> list2;
        List<TngSuccessorJob> successorJobs;
        List<TngSuccessorJob> successorJobsList = JobPredTable.instance().getTNGSuccessorList();
        if (successorJobsList != null) {
            for (TngSuccessorJob tngSuccessorJob : successorJobsList) {
                TngSuccessorJob tngSuccessorJob2 = JobTable.instance().getTngSuccsorJob(tngSuccessorJob);
                if (tngSuccessorJob2 != null) {
                    tngSuccessorJob.setCrithact(tngSuccessorJob2.getCrithact());
                    tngSuccessorJob.setCritkeys(tngSuccessorJob2.getCritkeys());
                }
                this.buildConditions(tngSuccessorJob, true);
            }
        }
        if ((successorJobs = JobTable.instance().getTNGSuccessorList()) != null) {
            for (TngSuccessorJob tngSuccessorJob : successorJobs) {
                this.buildConditions(tngSuccessorJob, false);
            }
        }
        if ((list2 = JobSetPredTable.instance().getTNGSuccessorFolderList()) != null) {
            for (TngSuccessorJob tngSuccessorJob : list2) {
                TngSuccessorJob tngSuccessorJob3 = JobSetTable.instance().getTNGSetJobByJob(new TngSuccessorJob(tngSuccessorJob.getSetId(), "NULL", "NULL"));
                if (tngSuccessorJob3 != null) {
                    tngSuccessorJob.setCritkeys(tngSuccessorJob3.getCritkeys());
                    tngSuccessorJob.setCrithact(tngSuccessorJob3.getCrithact());
                }
                this.buildConditions(tngSuccessorJob, true);
            }
        }
        if ((list = JobSetTable.instance().getTNGSetList()) != null) {
            for (TngSuccessorJob tngSuccessorJob : list) {
                this.buildConditions(tngSuccessorJob, true);
            }
        }
        if (fwAvailable) {
            List<TngSuccessorJob> list3;
            List<TngSuccessorJob> list4 = JobPredTable.instance().getTNGJobTriggersList();
            if (list4 != null) {
                for (TngSuccessorJob successorJob : list4) {
                    this.buildDependencyTriggers(successorJob, true);
                }
            }
            if ((list3 = JobSetPredTable.instance().getTNGFolderTriggersList()) != null) {
                TngSuccessorJob localJob;
                for (TngSuccessorJob successorJob : list3) {
                    localJob = JobSetTable.instance().getTNGSetJobByJob(new TngSuccessorJob(successorJob.getSetId(), "NULL", "NULL"));
                    if (localJob != null) {
                        successorJob.setCritkeys(localJob.getCritkeys());
                        successorJob.setCrithact(localJob.getCrithact());
                    }
                    this.buildDependencyTriggers(successorJob, false);
                }
                if (JobSetTable.instance().getTNGSetJobByJob(new TngSuccessorJob(TngGlobals.TRIGGERS_TABLE, "NULL", "NULL")) != null) {
                    localJob = JobSetTable.instance().getTNGSetJobByJob(new TngSuccessorJob(TngGlobals.TRIGGERS_TABLE, "NULL", "NULL"));
                    this.buildDependencyTriggers(localJob, false);
                }
            }
        }
    }

    private String getOdateForInCond(TngPredecessorJob predecessorJob, TngSuccessorJob successorJob) {
        String odat = "ODAT";
        if (predecessorJob.getWorkday().equalsIgnoreCase("PRIOR")) {
            if (this.priorHandling == PRIOR_HANDLING.PREV || predecessorJob.getTrev().equalsIgnoreCase(TngGlobals.EVENT_IN_COND)) {
                odat = "PREV";
                if (this.priorHandlingPrevEveryday == PRIOR_HANDLING_PREV_EVERYDAY.ANY && this.getjobRunsEveryDayIND(successorJob).booleanValue()) {
                    odat = "****";
                    this.outCondForAllDaysIND = true;
                }
            } else {
                this.createDummyJobs = true;
            }
        }
        return odat;
    }

    private String buildConditionNameForDummyJob(TngPredecessorJob tngPredecessorJob, TngSuccessorJob successorJob) {
        String jobID;
        String sep = this.rules.getStringRule("TNG rules", new String[]{"CONDITION_CONVENTION_FORMAT", "DELIMITER"});
        String format = TngGlobals.PRIOR_HANDLING_DUMMY_CONDNAME_FORMAT_FOR_JOBSET;
        String pSetID = tngPredecessorJob.getSetId();
        String pJobID = tngPredecessorJob.getJobId();
        if (pJobID.equals("NULL")) {
            pJobID = "";
        }
        String setID = successorJob.getSetId();
        String string = jobID = successorJob.getJobId().equals("NULL") ? "" : successorJob.getJobId();
        if (!jobID.equalsIgnoreCase("NULL")) {
            format = TngGlobals.PRIOR_HANDLING_DUMMY_CONDNAME_FORMAT_FOR_JOB;
        }
        return String.format(format, sep, pSetID, sep, pJobID, sep, sep, setID, sep, jobID);
    }

    private void handleDirectJobConditions(TngPredecessorJob predecessorJob, TngSuccessorJob tngSuccessorJob) {
        String preSet = predecessorJob.getSetId();
        String preJob = predecessorJob.getJobId();
        String preJno = predecessorJob.getJnoId();
        String sucSet = tngSuccessorJob.getSetId();
        String sucJob = tngSuccessorJob.getJobId();
        String sucJno = tngSuccessorJob.getJnoId();
        if (!preJob.equalsIgnoreCase("NULL") || !preSet.equalsIgnoreCase("NULL")) {
            String formatAll = this.formatCondString(preSet, preJob, preJno, sucSet, sucJob, sucJno, false);
            String odat = this.getOdateForInCond(predecessorJob, tngSuccessorJob);
            TngSuccessorJob localSucJob = null;
            localSucJob = tngSuccessorJob.getJobId() == null || tngSuccessorJob.getJobId().equalsIgnoreCase("NULL") ? new TngSuccessorJob(tngSuccessorJob.getSetId(), tngSuccessorJob.getSetId(), "NULL") : tngSuccessorJob;
            this.handleInCondsProp(formatAll, odat, "AND", localSucJob, "");
            if (deleteCondition) {
                TngPredecessorJob delSuccessorJob = null;
                delSuccessorJob = sucJob == null || sucJob.equalsIgnoreCase("NULL") ? new TngPredecessorJob(sucSet, sucSet, "NULL") : new TngPredecessorJob(sucSet, sucJob, sucJno);
                this.handleOutCondsProp(formatAll, odat, "DEL", delSuccessorJob);
            }
            TngPredecessorJob outJob = null;
            if (this.outCondForAllDaysIND) {
                this.outCondForAllDaysIND = false;
                TngPredecessorJob deleteJob = tngSuccessorJob.getJobId() == null || tngSuccessorJob.getJobId().equalsIgnoreCase("NULL") ? new TngPredecessorJob(tngSuccessorJob.getSetId(), tngSuccessorJob.getSetId(), "NULL") : new TngPredecessorJob(tngSuccessorJob.getSetId(), tngSuccessorJob.getJobId(), "NULL");
                this.handleOutCondsProp(formatAll, "****", "DEL", deleteJob);
            } else {
                if (preJob == null || preJob.equalsIgnoreCase("NULL")) {
                    outJob = new TngPredecessorJob(preSet, preSet, "NULL");
                } else {
                    String jno = preJno;
                    if (jno.equals("NULL")) {
                        String succesorJobNae = sucJob.equals("NULL") ? sucSet : sucJob;
                        jno = JobTable.instance().getJno(new TngSuccessorJob(preSet, preJob, preJno), succesorJobNae);
                    }
                    outJob = new TngPredecessorJob(preSet, preJob, jno);
                }
                this.handleOutCondsProp(formatAll, "ODAT", "ADD", outJob);
            }
        }
    }

    private void handleRegularJobsConditions(TngSuccessorJob tngSuccessorJob, TngPredecessorJob predecessorJob, Boolean smartTableInd) {
        String preSet = predecessorJob.getSetId();
        String preJob = predecessorJob.getJobId();
        String preJno = predecessorJob.getJnoId();
        String sucSet = tngSuccessorJob.getSetId();
        String sucJob = tngSuccessorJob.getJobId();
        if (!sucSet.equalsIgnoreCase("NULL") && sucJob.equalsIgnoreCase("NULL") && !preSet.equalsIgnoreCase("NULL")) {
            String formatAll;
            String deleteFormatAll = formatAll = this.formatCondString(null, null, null, preSet, preJob, preJno, false);
            this.handleOutCondsProp(formatAll, "ODAT", "ADD", tngSuccessorJob);
            TngSuccessorJob localJob = new TngSuccessorJob(tngSuccessorJob.getSetId(), tngSuccessorJob.getSetId(), "NULL");
            localJob.setCrithact(tngSuccessorJob.getCrithact());
            localJob.setCritkeys(tngSuccessorJob.getCritkeys());
            localJob.setWorkday(tngSuccessorJob.getWorkday());
            String odat = this.getOdateForInCond(predecessorJob, localJob);
            if (this.createDummyJobs) {
                String condName = this.buildConditionNameForDummyJob(predecessorJob, tngSuccessorJob);
                this.handleInCondsProp(condName, "ODAT", "AND", localJob, "");
            } else {
                this.handleInCondsProp(formatAll, odat, "AND", localJob, "");
            }
            if (deleteCondition || this.outCondForAllDaysIND && smartTableInd.booleanValue()) {
                this.outCondForAllDaysIND = false;
                this.handleOutCondsProp(formatAll, odat, "DEL", localJob);
            }
        } else if (!(sucSet.equalsIgnoreCase("NULL") || sucJob.equalsIgnoreCase("NULL") || preSet.equalsIgnoreCase("NULL"))) {
            String formatAll;
            String deleteFormatAll = formatAll = this.formatCondString(null, null, null, preSet, preJob, preJno, false);
            String odat = this.getOdateForInCond(predecessorJob, tngSuccessorJob);
            this.handleInCondsProp(formatAll, odat, "AND", tngSuccessorJob, "");
            if ((deleteCondition || this.outCondForAllDaysIND) && !deleteFormatAll.equalsIgnoreCase("")) {
                this.outCondForAllDaysIND = false;
                this.handleOutCondsProp(deleteFormatAll, odat, "DEL", tngSuccessorJob);
            }
        }
    }

    private void buildConditions(TngSuccessorJob tngSuccessorJob, boolean smartTableInd) {
        if (tngSuccessorJob.getPredecessorList() != null) {
            for (TngPredecessorJob predecessorJob : tngSuccessorJob.getPredecessorList()) {
                if (predecessorJob.getSetId() != null && predecessorJob.getSetId().equalsIgnoreCase("NULL") && predecessorJob.getJobId() != null && predecessorJob.getJobId().equalsIgnoreCase("NULL") && predecessorJob.getJnoId() != null && predecessorJob.getJnoId().equalsIgnoreCase("NULL") && DependenciesConvertor.isDirectJob()) continue;
                if (DependenciesConvertor.isDirectJob()) {
                    this.handleDirectJobConditions(predecessorJob, tngSuccessorJob);
                    continue;
                }
                this.handleRegularJobsConditions(tngSuccessorJob, predecessorJob, smartTableInd);
            }
        } else if (!DependenciesConvertor.isDirectJob()) {
            String sucSet = tngSuccessorJob.getSetId();
            String sucJob = tngSuccessorJob.getJobId();
            String sucJno = tngSuccessorJob.getJnoId();
            String formatAll = this.formatCondString(null, null, null, sucSet, sucJob, sucJno, false);
            if (sucSet.equalsIgnoreCase(TngGlobals.TRIGGERS_TABLE) && sucJob.equalsIgnoreCase("NULL") && sucJno.equalsIgnoreCase("NULL")) {
                TngSuccessorJob smartFolderJob = tngSuccessorJob;
                smartFolderJob.setJobId(TngGlobals.TRIGGERS_TABLE);
                this.handleOutCondsProp(formatAll, "ODAT", "ADD", smartFolderJob);
            } else if (!sucSet.equalsIgnoreCase(TngGlobals.TRIGGERS_TABLE)) {
                TngSuccessorJob localJob = null;
                localJob = sucJob.equals("NULL") ? new TngSuccessorJob(sucSet, sucSet, "NULL") : tngSuccessorJob;
                this.handleOutCondsProp(formatAll, "ODAT", "ADD", localJob);
                if (!localJob.getJobId().equalsIgnoreCase(TngGlobals.TRIGGERS_TABLE)) {
                    TngSuccessorJob outTriggerJob = new TngSuccessorJob(localJob.getSetId(), localJob.getJobId(), localJob.getJnoId());
                    this.handleOutCondsProp(formatAll, "ODAT", "ADD", outTriggerJob);
                }
            }
        }
    }

    private void buildDependencyTriggers(TngSuccessorJob tngSuccessorJob, boolean jobTrigIND) {
        List<TngTrigger> triggerList;
        String sucSet = tngSuccessorJob.getSetId();
        String sucJob = tngSuccessorJob.getJobId();
        String sucJno = tngSuccessorJob.getJnoId();
        String trev = tngSuccessorJob.getTrev();
        if (trev.equals(TngGlobals.EVENT_CLOSE_FILE) && (triggerList = tngSuccessorJob.getTriggerList()) != null && !triggerList.isEmpty()) {
            for (TngTrigger trigger : triggerList) {
                TngTrigger checkTrig = TriggerTable.instance().getTngTrigger(trigger);
                if (checkTrig == null) continue;
                String odat = trigger.getWorkday().equalsIgnoreCase("CURRENT") ? "ODAT" : "PREV";
                TngSuccessorJob triggerSuccessorJob = new TngSuccessorJob(sucSet, sucJob, sucJno);
                if (fWJobPerTrigger) {
                    if (!DependenciesConvertor.isDirectJob()) {
                        this.handleRegularJobsFWPerTrigger(trigger.getId(), sucSet, sucJob, sucJno, odat, triggerSuccessorJob);
                        continue;
                    }
                    this.handleDirectJobsFWPerJobTriggers(trigger.getId(), sucSet, sucJob, sucJno, odat, triggerSuccessorJob);
                    continue;
                }
                if (!DependenciesConvertor.isDirectJob()) {
                    this.handleRegularJobsForTriggers(trigger.getId(), sucSet, sucJob, sucJno, odat, triggerSuccessorJob);
                    continue;
                }
                this.handleDirectJobsForTriggers(trigger.getId(), sucSet, sucJob, sucJno, odat, triggerSuccessorJob);
            }
        }
    }

    private void handleDirectJobsForTriggers(String triggerId, String sucSet, String sucJob, String sucJno, String odat, TngSuccessorJob triggerSuccessorJob) {
        String jno = sucJno == null || sucJno.equalsIgnoreCase("NULL") ? "1" : sucJno;
        sucJob = sucJob.equalsIgnoreCase("NULL") ? "" : sucJob;
        String jobName = String.format(TngGlobals.CTMFW_ORDER_ID_FORMAT, sucSet, sucJob, jno);
        String condName = String.format(TngGlobals.CTMFW_DO_CONDNAME_FORMAT, triggerId).concat(TngGlobals.FORMAT_TYPE_TO).concat(sucJob);
        TngSuccessorJob job = new TngSuccessorJob(TngGlobals.TRIGGERS_TABLE, jobName, jno);
        job.setWorkday("CURRENT");
        this.handleInCondsProp(condName, odat, "AND", job, triggerId);
        TngPredecessorJob outJobTrigger = new TngPredecessorJob(TngGlobals.TRIGGERS_TABLE, jobName, jno);
        this.handleOutCondsProp(condName, odat, "DEL", outJobTrigger);
    }

    private void handleRegularJobsForTriggers(String triggerId, String sucSet, String sucJob, String sucJno, String odat, TngSuccessorJob triggerSuccessorJob) {
        String jno = sucJno == null || sucJno.equalsIgnoreCase("NULL") ? "1" : sucJno;
        sucJob = sucJob.equalsIgnoreCase("NULL") ? "" : sucJob;
        String jobName = String.format(TngGlobals.CTMFW_ORDER_ID_FORMAT, sucSet, sucJob, jno);
        String condName = String.format(TngGlobals.CTMFW_DO_CONDNAME_FORMAT, triggerId);
        TngSuccessorJob job = new TngSuccessorJob(TngGlobals.TRIGGERS_TABLE, jobName, jno);
        job.setWorkday("CURRENT");
        this.handleInCondsProp(condName, odat, "AND", job, "");
        this.handleOutCondsProp(condName, odat, "DEL", job);
    }

    private void handleRegularJobsFWPerTrigger(String triggerId, String sucSet, String sucJob, String sucJno, String odat, TngSuccessorJob triggerSuccessorJob) {
        String jobName = String.format(TngGlobals.CTMFW_ID_FORMAT, triggerId);
        String formatAll = this.formatCondString(TngGlobals.TRIGGERS_TABLE, jobName, sucJno, sucSet, sucJob, sucJno, true);
        TngSuccessorJob job = null;
        if (triggerSuccessorJob.getJobId().equalsIgnoreCase("NULL")) {
            job = new TngSuccessorJob(triggerSuccessorJob.getSetId(), triggerSuccessorJob.getSetId(), "NULL");
            job.setCrithact(triggerSuccessorJob.getCrithact());
            job.setCritkeys(triggerSuccessorJob.getCritkeys());
        } else {
            job = triggerSuccessorJob;
        }
        this.handleInCondsProp(formatAll, odat, "AND", job, "");
        if (deleteCondition) {
            this.handleOutCondsProp(formatAll, odat, "DEL", job);
        }
        formatAll = this.formatCondString(TngGlobals.TRIGGERS_TABLE, jobName, "0001", "NULL", "NULL", TngGlobals.TRIGGERS_TABLE, true);
        TngSuccessorJob localJob = new TngSuccessorJob(TngGlobals.TRIGGERS_TABLE, jobName, "0001");
        this.handleOutCondsProp(formatAll, "ODAT", "ADD", localJob);
    }

    private void handleDirectJobsFWPerJobTriggers(String triggerId, String sucSet, String sucJob, String sucJno, String odat, TngSuccessorJob triggerSuccessorJob) {
        String jobName = String.format(TngGlobals.CTMFW_ID_FORMAT, triggerId);
        String formatAll = this.formatCondString(TngGlobals.TRIGGERS_TABLE, jobName, "0001", sucSet, sucJob, sucJno, true);
        TngSuccessorJob job = null;
        if (triggerSuccessorJob.getJobId().equalsIgnoreCase("NULL")) {
            job = new TngSuccessorJob(triggerSuccessorJob.getSetId(), triggerSuccessorJob.getSetId(), "NULL");
            job.setCrithact(triggerSuccessorJob.getCrithact());
            job.setCritkeys(triggerSuccessorJob.getCritkeys());
        } else {
            job = triggerSuccessorJob;
        }
        this.handleInCondsProp(formatAll, odat, "AND", job, "");
        sucJob = sucJob.equalsIgnoreCase("NULL") ? sucSet : sucJob;
        Properties trigCond = new Properties();
        trigCond.setProperty(TngGlobals.JOB_NAME, sucJob);
        trigCond.setProperty(TngGlobals.FORMAT_NAME, formatAll);
        if (!triggerConds.containsKey(jobName)) {
            triggerConds.put(jobName, new LinkedHashSet());
        }
        triggerConds.get(jobName).add(trigCond);
        TngPredecessorJob localJob = new TngPredecessorJob(sucSet, sucJob, sucJno);
        if (deleteCondition) {
            this.handleOutCondsProp(formatAll, odat, "DEL", localJob);
        }
        localJob = new TngPredecessorJob(TngGlobals.TRIGGERS_TABLE, jobName, "0001");
        this.handleOutCondsProp(formatAll, "ODAT", "ADD", localJob);
    }

    private void handleOutCondsProp(String format, String odat, String sign, TngGeneralJob generalJob) {
        Properties outCond = new Properties();
        outCond.setProperty("SIGN", sign);
        outCond.setProperty("ODATE", odat);
        outCond.setProperty("NAME", format);
        if (!outConds.containsKey(generalJob)) {
            outConds.put(generalJob, new LinkedHashSet());
        }
        outConds.get(generalJob).add(outCond);
    }

    private void handleInCondsProp(String format, String odat, String sign, TngGeneralJob generalJob, String triggerName) {
        Properties inCond = new Properties();
        inCond.setProperty("AND_OR", sign);
        inCond.setProperty("ODATE", odat);
        inCond.setProperty("NAME", format);
        inCond.setProperty(TngGlobals.TRIGGER_NAME, triggerName);
        if (!inConds.containsKey(generalJob)) {
            inConds.put(generalJob, new LinkedHashSet());
        }
        inConds.get(generalJob).add(inCond);
    }

    public ArrayList<Properties> getTriggerListPerJobTrigger(String jobTriggerName) {
        LinkedHashSet<Properties> tmpProps = triggerConds.get(jobTriggerName);
        return tmpProps == null ? null : new ArrayList(triggerConds.get(jobTriggerName));
    }

    public void appendStationsToOutConds(String station) {
        String jobName = String.format(TngGlobals.CTMFW_ID_FORMAT, station);
        if (!DependenciesConvertor.isDirectJob()) {
            String format = this.formatCondString(TngGlobals.TRIGGERS_TABLE, jobName, "0001", "NULL", "NULL", "NULL", true);
            TngSuccessorJob successorJob = new TngSuccessorJob(TngGlobals.TRIGGERS_TABLE, jobName, "0001");
            this.handleOutCondsProp(format, "ODAT", "ADD", successorJob);
        }
    }

    public void appendTriggerJobs(TngTrigger tngTrigger, TngSuccessorJob tngSuccessorJob, boolean jobIND) {
        if (!DependenciesConvertor.isDirectJob()) {
            String set_id = tngSuccessorJob.getSetId();
            String job_id = tngSuccessorJob.getJobId() == null || tngSuccessorJob.getJobId().equals("NULL") ? "" : tngSuccessorJob.getJobId();
            String jno_id = tngSuccessorJob.getJnoId() == null || tngSuccessorJob.getJnoId().equals("NULL") ? "1" : tngSuccessorJob.getJnoId();
            String jobName = jobIND ? String.format(TngGlobals.CTMFW_ORDER_ID_FORMAT, set_id, job_id, jno_id) : String.format(TngGlobals.CTMFW_ORDER_ID_FORMAT, set_id, set_id, "NULL");
            String condName = String.format(TngGlobals.CTMFW_DO_CONDNAME_FORMAT, tngTrigger.getId());
            TngSuccessorJob successorJob = new TngSuccessorJob(TngGlobals.TRIGGERS_TABLE, jobName, jno_id);
            successorJob.setWorkday("CURRENT");
            JobPredTable.instance().addJobsToTriggerList(condName, TngGlobals.EVENT_IN_COND, successorJob);
        }
    }

    private String formatCondString(String preSet, String preJob, String preJno, String sucSet, String sucJob, String sucJno, boolean indTrig) {
        String format = this.rules.getStringRule("TNG rules", new String[]{"CONDITION_CONVENTION_FORMAT", "FORMAT"});
        if (!DependenciesConvertor.isDirectJob()) {
            if (indTrig) {
                format = format.replace(TngGlobals.FORMATED_PSET, preSet);
                format = format.replace(TngGlobals.FORMATED_PJOB, preJob);
                if (!fWJobPerTrigger) {
                    format = preJno != null && !preJno.equalsIgnoreCase("NULL") ? format.replace(TngGlobals.FORMATED_PJNO, preJno) : format.replace(TngGlobals.FORMATED_PJNO, "");
                } else if (!sucJno.equals(TngGlobals.TRIGGERS_TABLE) && preJob.startsWith("CTMFW_FOR_")) {
                    String localformat = this.rules.getStringRule("TNG rules", new String[]{"CONDITION_CONVENTION_FORMAT", "FORMAT"});
                    localformat = localformat.replace(TngGlobals.FORMATED_PSET, sucSet);
                    localformat = sucJob != null && !sucJob.equalsIgnoreCase("NULL") ? localformat.replace(TngGlobals.FORMATED_PJOB, sucJob) : localformat.replace(TngGlobals.FORMATED_PJOB, "");
                    localformat = localformat.replace(TngGlobals.FORMATED_PJOB, sucJob);
                    localformat = sucJno != null && !sucJno.equalsIgnoreCase("NULL") ? localformat.replace(TngGlobals.FORMATED_PJNO, sucJno) : localformat.replace(TngGlobals.FORMATED_PJNO, "");
                    format = format.replace(TngGlobals.FORMATED_PJNO, localformat);
                } else if (sucJno != null && sucJno.equalsIgnoreCase(TngGlobals.TRIGGERS_TABLE)) {
                    format = sucJno != null && !sucJno.equalsIgnoreCase("NULL") ? format.replace(TngGlobals.FORMATED_PJNO, preJno) : format.replace(TngGlobals.FORMATED_PJNO, "");
                }
            } else {
                format = format.replace(TngGlobals.FORMATED_PSET, sucSet);
                if (sucJob != null && !sucJob.equalsIgnoreCase("NULL")) {
                    format = format.replace(TngGlobals.FORMATED_PJOB, sucJob);
                    format = format.replace(TngGlobals.FORMATED_PJNO, sucJno);
                } else {
                    format = format.replace(TngGlobals.FORMATED_PJOB, "");
                    format = format.replace(TngGlobals.FORMATED_PJNO, "");
                }
            }
        } else {
            if (!format.contains("{PSET}") && !format.contains("{PSET_A}")) {
                format = preJob.equals("NULL") ? format.replace(TngGlobals.FORMATED_PJOB_A, preSet) : format.replace(TngGlobals.FORMATED_PJOB_A, preJob + (String)(DependenciesConvertor.isNotNull(preJno) ? "_" + preJno : ""));
                format = sucJob.equals("NULL") ? format.replace(TngGlobals.FORMATED_JOB_B, sucSet) : format.replace(TngGlobals.FORMATED_JOB_B, sucJob + (String)(DependenciesConvertor.isNotNull(sucJno) ? "_" + sucJno : ""));
            }
            if (indTrig) {
                format = format.replace(TngGlobals.FORMATED_PSET_A, preSet);
                format = format.replace(TngGlobals.FORMATED_PJOB_A, preJob);
                format = format.replace(TngGlobals.FORMATED_SET_B, sucSet);
                format = preJno != null && !preJno.equalsIgnoreCase("NULL") ? format.replace(TngGlobals.FORMATED_PJNO_A, preJno) : format.replace(TngGlobals.FORMATED_PJNO_A, "");
                if (!fWJobPerTrigger) {
                    format = sucJob != null && !sucJob.equalsIgnoreCase("NULL") ? format.replace(TngGlobals.FORMATED_JOB_B, sucJob) : format.replace(TngGlobals.FORMATED_JOB_B, "");
                    format = sucJno != null && !sucJno.equalsIgnoreCase("NULL") ? format.replace(TngGlobals.FORMATED_JNO_B, sucJno) : format.replace(TngGlobals.FORMATED_JNO_B, "");
                }
                if (fWJobPerTrigger) {
                    format = sucJob != null && !sucJob.equalsIgnoreCase("NULL") ? format.replace(TngGlobals.FORMATED_JOB_B, sucJob) : format.replace(TngGlobals.FORMATED_JOB_B, "");
                    format = sucJno != null && !sucJno.equalsIgnoreCase("NULL") ? format.replace(TngGlobals.FORMATED_JNO_B, sucJno) : format.replace(TngGlobals.FORMATED_JNO_B, "");
                }
            } else {
                format = preJob != null && !preJob.equalsIgnoreCase("NULL") ? format.replace(TngGlobals.FORMATED_PJOB_A, preJob) : format.replace(TngGlobals.FORMATED_PJOB_A, "");
                format = preJno != null && !preJno.equalsIgnoreCase("NULL") ? format.replace(TngGlobals.FORMATED_PJNO_A, preJno) : format.replace(TngGlobals.FORMATED_PJNO_A, "");
                format = sucJob != null && !sucJob.equalsIgnoreCase("NULL") ? format.replace(TngGlobals.FORMATED_JOB_B, sucJob) : format.replace(TngGlobals.FORMATED_JOB_B, "");
                format = sucJno != null && !sucJno.equalsIgnoreCase("NULL") ? format.replace(TngGlobals.FORMATED_JNO_B, sucJno) : format.replace(TngGlobals.FORMATED_JNO_B, "");
                format = format.replace(TngGlobals.FORMATED_PSET_A, preSet);
                format = format.replace(TngGlobals.FORMATED_SET_B, sucSet);
            }
        }
        return format;
    }

    public String buildDefaultCondName(String jobSet, String job, String jno) {
        if (ruleFormat == null) {
            DependenciesConvertor.instance().mapConditions();
        }
        String format = ruleFormat;
        if (!DependenciesConvertor.isDirectJob()) {
            format = format.replace(TngGlobals.FORMATED_PSET, jobSet);
            if (job != null && !job.equalsIgnoreCase("NULL")) {
                format = format.replace(TngGlobals.FORMATED_PJOB, job);
                format = format.replace(TngGlobals.FORMATED_PJNO, jno);
            } else {
                format = format.replace(TngGlobals.FORMATED_PJOB, "");
                format = format.replace(TngGlobals.FORMATED_PJNO, "");
            }
        }
        return format;
    }

    private String getAttrWithDefault(String Attribute, String parentAttrCtm, String parentAttrOrig, String DefaultValue, String MessageId, TngGlobals.CASE_HANDLING caseHandle, QUOTES_HANDLING removeQuotes, PARENTHESES_HANDLING removeParentheses) {
        String attrValue = Attribute;
        if (attrValue == null) {
            attrValue = "";
        }
        if (removeQuotes == QUOTES_HANDLING.REMOVE_DELIMITER && attrValue.startsWith("\"") && attrValue.endsWith("\"")) {
            attrValue = attrValue.substring(1, attrValue.length() - 1);
        }
        if (removeParentheses == PARENTHESES_HANDLING.REMOVE_DELIMITER && attrValue.startsWith("(") && attrValue.endsWith(")")) {
            attrValue = attrValue.substring(1, attrValue.length() - 1);
        }
        if (caseHandle == TngGlobals.CASE_HANDLING.TOUPPER) {
            attrValue = attrValue.toUpperCase();
        } else if (caseHandle == TngGlobals.CASE_HANDLING.TOLOWER) {
            attrValue = attrValue.toLowerCase();
        }
        return attrValue;
    }

    public Boolean getjobRunsEveryDayIND(TngSuccessorJob successorJob) {
        boolean jobRunsEveryDay = false;
        StringBuilder daysStr = new StringBuilder("");
        ArrayList<CallSite> Specific_Dates = new ArrayList<CallSite>();
        Integer dayIndex = 0;
        Integer monthIndex = 0;
        String[] monthsArray = GlobalFunctions.getMonthsArray();
        String[] monthStr = new String[monthsArray.length];
        monthIndex = 0;
        while (monthIndex < monthsArray.length) {
            monthStr[monthIndex.intValue()] = "0";
            Integer n = monthIndex;
            monthIndex = monthIndex + 1;
        }
        String critHact = this.getAttrWithDefault(successorJob.getCrithact(), null, null, "", null, TngGlobals.CASE_HANDLING.TOUPPER, QUOTES_HANDLING.REMOVE_DELIMITER, PARENTHESES_HANDLING.REMOVE_DELIMITER);
        if (successorJob.getCritkeys().equalsIgnoreCase("DAILY")) {
            daysStr.replace(0, daysStr.length(), "ALL");
        } else if (successorJob.getCritkeys().equalsIgnoreCase("HOLIDAYS")) {
            daysStr.replace(0, daysStr.length(), "ALL");
        } else if (successorJob.getCritkeys().equalsIgnoreCase("WORKDAYS")) {
            daysStr.replace(0, daysStr.length(), "ALL");
        } else if (successorJob.getCritkeys().startsWith("WORKD")) {
            if (daysStr.toString().equalsIgnoreCase("ALL")) {
                daysStr.delete(0, daysStr.length());
            } else if (successorJob.getCritkeys().length() >= 3 && GlobalFunctions.getMonthIndex((String[])monthsArray, (String)successorJob.getCritkeys().substring(0, 3)) >= 0) {
                monthIndex = GlobalFunctions.getMonthIndex((String[])monthsArray, (String)successorJob.getCritkeys().substring(0, 3));
                if (successorJob.getCritkeys().length() > 3 && successorJob.getCritkeys().length() <= 3) {
                    daysStr.replace(0, daysStr.length(), "ALL");
                }
            } else if (successorJob.getCritkeys().length() >= 5 && (successorJob.getCritkeys().substring(2, 3).equalsIgnoreCase("/") || successorJob.getCritkeys().substring(4, 5).equalsIgnoreCase("/"))) {
                String[] yy_mm_dd = successorJob.getCritkeys().split("\\.+|/+");
                if (yy_mm_dd[1].equals("**") && yy_mm_dd[2].equals("**")) {
                    daysStr.replace(0, daysStr.length(), "ALL");
                } else {
                    yy_mm_dd[1] = yy_mm_dd[1].replace("*", "\\d");
                    yy_mm_dd[2] = yy_mm_dd[2].replace("*", "\\d");
                    monthIndex = 1;
                    while (monthIndex <= 12) {
                        String mm = String.format("%02d", monthIndex);
                        if (mm.matches(yy_mm_dd[1].toString())) {
                            dayIndex = 1;
                            while (dayIndex <= 31) {
                                String dd = String.format("%02d", dayIndex);
                                if (dd.matches(yy_mm_dd[2].toString())) {
                                    Specific_Dates.add((CallSite)((Object)(mm.toString() + dd.toString())));
                                }
                                Integer n = dayIndex;
                                dayIndex = dayIndex + 1;
                            }
                        }
                        Integer n = monthIndex;
                        monthIndex = monthIndex + 1;
                    }
                }
            }
        }
        if (Specific_Dates.size() > 0 && daysStr.toString().equalsIgnoreCase("ALL")) {
            daysStr.replace(0, daysStr.length(), "");
        }
        if (critHact.equalsIgnoreCase("O")) {
            daysStr.replace(0, daysStr.length(), "ALL");
        }
        if (daysStr.toString().equalsIgnoreCase("ALL")) {
            jobRunsEveryDay = true;
        }
        return jobRunsEveryDay;
    }

    private void getPriorHandling() {
        if (this.priorHandling == null) {
            String prior = this.rules.getStringRule("TNG rules", new String[]{"PRIOR"});
            if (prior != null && prior.equalsIgnoreCase("Prev")) {
                this.priorHandling = PRIOR_HANDLING.PREV;
                String prevEveryday = this.rules.getStringRule("TNG rules", new String[]{"PRIOR_EVERYDAY"});
                if (prevEveryday != null && prevEveryday.equalsIgnoreCase("Prev")) {
                    this.priorHandlingPrevEveryday = PRIOR_HANDLING_PREV_EVERYDAY.PREV;
                }
            } else {
                this.priorHandling = PRIOR_HANDLING.DUMMY_JOB;
            }
        }
    }

    private static boolean isNotNull(String value) {
        return value != null && !value.equalsIgnoreCase("NULL");
    }

    static {
        inConds = null;
        outConds = null;
        triggerConds = null;
        ruleFormat = null;
        deleteCondition = false;
        fWJobPerTrigger = false;
        fwAvailable = false;
    }

    private static enum PRIOR_HANDLING {
        PREV,
        DUMMY_JOB;

    }

    private static enum PRIOR_HANDLING_PREV_EVERYDAY {
        ANY,
        PREV;

    }

    private static enum QUOTES_HANDLING {
        REMOVE_DELIMITER,
        LEAVE_DELIMITER;

    }

    private static enum PARENTHESES_HANDLING {
        REMOVE_DELIMITER,
        LEAVE_DELIMITER;

    }
}

