/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws.tasks;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.tws.TwsBaseConvertor;
import com.bmc.ctmconvert.tws.TwsJob;
import com.bmc.ctmconvert.tws.tasks.TWSUnsupportedTaskType;
import com.bmc.ctmconvert.tws.tasks.TwsDatabaseConvertor;
import com.bmc.ctmconvert.tws.tasks.TwsTaskExecutableConvertor;
import com.bmc.ctmconvert.tws.tasks.TwsTaskFiletransferConvertor;
import com.bmc.ctmconvert.tws.tasks.TwsTaskInformaticaConvertor;
import com.bmc.ctmconvert.tws.tasks.TwsTaskMfJclConvertor;
import com.bmc.ctmconvert.tws.tasks.TwsTaskOS400Convertor;
import com.bmc.ctmconvert.tws.tasks.TwsTaskRestfulConvertor;
import com.bmc.ctmconvert.tws.tasks.TwsTaskSapBOConvertor;
import com.bmc.ctmconvert.tws.tasks.TwsTaskSapR3Convertor;
import java.util.HashMap;
import java.util.Map;

public class TaskFactory {
    private final Map<String, TwsBaseConvertor> mapTASKConvertor = new HashMap<String, TwsBaseConvertor>();

    public TaskFactory() {
        this.mapTASKConvertor.put("database", new TwsDatabaseConvertor());
        this.mapTASKConvertor.put("executable", new TwsTaskExecutableConvertor());
        this.mapTASKConvertor.put("jcl", new TwsTaskMfJclConvertor());
        this.mapTASKConvertor.put("filetransfer", new TwsTaskFiletransferConvertor());
        this.mapTASKConvertor.put("restful", new TwsTaskRestfulConvertor());
        this.mapTASKConvertor.put("ibmi", new TwsTaskOS400Convertor());
        this.mapTASKConvertor.put("r3", new TwsTaskSapR3Convertor());
        this.mapTASKConvertor.put("processchain", new TwsTaskSapR3Convertor());
        this.mapTASKConvertor.put("sapbusinessobjects", new TwsTaskSapBOConvertor());
        this.mapTASKConvertor.put("powercenter", new TwsTaskInformaticaConvertor());
        this.mapTASKConvertor.put("NotSupported", new TWSUnsupportedTaskType());
    }

    public TwsBaseConvertor getConvertor(TwsJob twsJob) {
        String taskXml = twsJob.getSourceJobAttribute("TASK").trim();
        XmlElement taskDefinitionXml = XmlLoader.from((String)taskXml);
        String taskType = taskDefinitionXml.getFirstChildElementByName("jsdl:application").getAttribute("name");
        TwsBaseConvertor twsConvertor = !this.mapTASKConvertor.containsKey(taskType) ? this.mapTASKConvertor.get("NotSupported") : this.mapTASKConvertor.get(taskType);
        twsConvertor.init(twsJob, taskDefinitionXml);
        return twsConvertor;
    }
}

