/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.csvreader.CsvWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;

public class Vars2csv {
    private File m_varTablesFile;
    private File m_varsFlatFile;
    private File m_parmsDir;
    private File m_targetCsv;
    private String m_defaultTable = "MAIN_TABLE";
    private static final String[] m_csvHeader = new String[]{"WORKSTATION", "TABLE", "ISDEFAULT", "NAME", "VALUE"};
    private HashMap<String, HashMap<String, String>> m_agent2parmMap = new HashMap();
    private HashMap<String, HashMap<String, String>> m_table2varMap = new HashMap();

    public Vars2csv(File varTablesFile, File varsFlatFile, File parmsDir, File targetCsv) {
        this.m_varTablesFile = varTablesFile;
        this.m_varsFlatFile = varsFlatFile;
        this.m_parmsDir = parmsDir;
        this.m_targetCsv = targetCsv;
    }

    public void createCsv() throws IOException {
        this.mapAgentParms();
        this.mapVars();
        this.dumpMaps2Csv();
    }

    private void mapAgentParms() throws IOException {
        if (this.m_parmsDir == null || !this.m_parmsDir.exists()) {
            return;
        }
        File[] filesArr = this.m_parmsDir.listFiles();
        for (int i = 0; i < filesArr.length; ++i) {
            if (!filesArr[i].getName().matches(".+_parms[.]txt") || !filesArr[i].isFile()) continue;
            String agName = filesArr[i].getName();
            agName = agName.substring(0, agName.lastIndexOf(95));
            this.m_agent2parmMap.put(agName, this.file2NameValueMap(filesArr[i]));
        }
    }

    private HashMap<String, String> file2NameValueMap(File file) throws IOException {
        String currLine;
        HashMap<String, String> toRet = new HashMap<String, String>();
        BufferedReader inputStream = new BufferedReader(new FileReader(file));
        while ((currLine = inputStream.readLine()) != null) {
            String[] lineArr = this.getNameVal(currLine);
            if (lineArr == null) continue;
            toRet.put(lineArr[0], lineArr[1]);
        }
        inputStream.close();
        return toRet;
    }

    private String[] getNameVal(String line) {
        if (!(line = line.trim()).matches("^[^\t ]+[\t ]+[^\t ]+$") && !line.matches("^[^\t ]+[\t ]+[\"].+[\"]$")) {
            return null;
        }
        return line.split("[ \t]+", 2);
    }

    private void mapVars() throws IOException {
        if (this.m_varTablesFile != null && this.m_varTablesFile.exists()) {
            this.mapTableFile();
        }
        if (this.m_varsFlatFile != null && this.m_varsFlatFile.exists()) {
            this.mapFlatFile();
        }
    }

    private void mapFlatFile() throws IOException {
        HashMap<String, String> tmpMap = this.file2NameValueMap(this.m_varsFlatFile);
        for (String fullName : tmpMap.keySet()) {
            String name;
            String table = this.m_defaultTable;
            String value = tmpMap.get(fullName);
            if (fullName.contains(".")) {
                table = fullName.substring(0, fullName.indexOf(46));
                name = fullName.substring(fullName.indexOf(46) + 1);
            } else {
                name = fullName;
            }
            if (!this.m_table2varMap.containsKey(table)) {
                this.m_table2varMap.put(table, new HashMap());
            }
            this.m_table2varMap.get(table).put(name, value);
        }
    }

    private void mapTableFile() throws IOException {
        String currLine;
        if (!this.m_varTablesFile.exists()) {
            return;
        }
        FileReader fileReader = new FileReader(this.m_varTablesFile);
        BufferedReader inputStream = new BufferedReader(fileReader);
        String tableName = "";
        boolean readMembers = false;
        while ((currLine = inputStream.readLine()) != null) {
            String[] nameVal;
            if ((currLine = currLine.trim()).toUpperCase().startsWith("VARTABLE ")) {
                tableName = currLine.split("[\t ]+", 2)[1];
                continue;
            }
            if (currLine.equalsIgnoreCase("ISDEFAULT") && !tableName.isEmpty()) {
                this.m_defaultTable = tableName;
                continue;
            }
            if (currLine.equalsIgnoreCase("MEMBERS")) {
                readMembers = true;
                continue;
            }
            if (currLine.equalsIgnoreCase("END")) {
                tableName = "";
                readMembers = false;
                continue;
            }
            if (!readMembers || (nameVal = this.getNameVal(currLine)) == null) continue;
            if (!this.m_table2varMap.containsKey(tableName)) {
                this.m_table2varMap.put(tableName, new HashMap());
            }
            this.m_table2varMap.get(tableName).put(nameVal[0], nameVal[1]);
        }
        fileReader.close();
        inputStream.close();
    }

    private void dumpMaps2Csv() throws IOException {
        String[] newRecord;
        CsvWriter writer = new CsvWriter(this.m_targetCsv.getPath());
        writer.writeRecord(m_csvHeader);
        if (this.m_agent2parmMap != null) {
            for (String workstation : this.m_agent2parmMap.keySet()) {
                for (String name : this.m_agent2parmMap.get(workstation).keySet()) {
                    newRecord = new String[m_csvHeader.length];
                    newRecord[this.getHeaderIndex((String)"WORKSTATION")] = workstation;
                    newRecord[this.getHeaderIndex((String)"NAME")] = name;
                    newRecord[this.getHeaderIndex((String)"VALUE")] = this.m_agent2parmMap.get(workstation).get(name);
                    writer.writeRecord(newRecord);
                }
            }
        }
        if (this.m_table2varMap != null) {
            for (String varTable : this.m_table2varMap.keySet()) {
                for (String name : this.m_table2varMap.get(varTable).keySet()) {
                    newRecord = new String[m_csvHeader.length];
                    newRecord[this.getHeaderIndex((String)"TABLE")] = varTable;
                    newRecord[this.getHeaderIndex((String)"ISDEFAULT")] = this.isDefaultVariableTable(varTable) ? "Y" : "";
                    newRecord[this.getHeaderIndex((String)"NAME")] = name;
                    newRecord[this.getHeaderIndex((String)"VALUE")] = this.m_table2varMap.get(varTable).get(name);
                    writer.writeRecord(newRecord);
                }
            }
        }
        writer.close();
    }

    private boolean isDefaultVariableTable(String varTable) {
        return varTable.equalsIgnoreCase(this.m_defaultTable) || varTable.isEmpty();
    }

    private int getHeaderIndex(String column) {
        for (int i = 0; i < m_csvHeader.length; ++i) {
            if (!m_csvHeader[i].equals(column)) continue;
            return i;
        }
        return -1;
    }
}

