/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.tws.OS400Handler;
import com.bmc.ctmconvert.tws.PeopleSoftHandler;
import com.bmc.ctmconvert.tws.SapHandler;
import com.bmc.ctmconvert.tws.TwsAssessmentJobTypeData;
import com.bmc.ctmconvert.tws.TwsJobAttributes;

public class TwsJobTypeRecognizer {
    public TwsAssessmentJobTypeData recognizeJobType(TwsJobAttributes jobAttr) {
        TwsAssessmentJobTypeData toRet = null;
        IAttrHolder jobAttributes = jobAttr.getJobAttributes();
        if (jobAttributes != null) {
            String commandType = jobAttributes.getAttr("commandType");
            toRet = commandType != null && commandType.equals("TASK") ? this.handleTaskTypeJob(jobAttributes) : this.handleOtherTypeJob(jobAttributes);
        }
        return toRet;
    }

    private TwsAssessmentJobTypeData handleOtherTypeJob(IAttrHolder jobAttributes) {
        TwsAssessmentJobTypeData toRet = new TwsAssessmentJobTypeData();
        String taskType = jobAttributes.getAttr("tasktype");
        String command = jobAttributes.getAttr("scriptname/docommand");
        switch (taskType) {
            case "SAP": {
                toRet.originalType = "SAP";
                if (SapHandler.isSapProcessChain(command)) {
                    toRet.targetType = "SAP Business Warehouse";
                    break;
                }
                toRet.targetType = "SAP R3";
                break;
            }
            case "other": 
            case "OTHER": {
                toRet.originalType = "OTHER";
                if (OS400Handler.isOS400(jobAttributes)) {
                    toRet.targetType = "OS400";
                    break;
                }
                toRet.targetType = "OS";
                break;
            }
            case "UNIX": 
            case "WINDOWS": {
                toRet = this.handleTargetTypeOS(jobAttributes);
                break;
            }
            default: {
                toRet.originalType = taskType;
                toRet.targetType = "Dummy";
                toRet.isSupported = false;
            }
        }
        return toRet;
    }

    private TwsAssessmentJobTypeData handleTargetTypeOS(IAttrHolder jobAttributes) {
        TwsAssessmentJobTypeData toRet = new TwsAssessmentJobTypeData();
        String taskType = jobAttributes.getAttr("tasktype");
        String command = jobAttributes.getAttr("scriptname/docommand");
        toRet.originalType = taskType;
        toRet.targetType = PeopleSoftHandler.isPeopleSoftJob(command) ? "PeopleSoft" : "OS";
        return toRet;
    }

    private TwsAssessmentJobTypeData handleTaskTypeJob(IAttrHolder jobAttributes) {
        String taskType;
        TwsAssessmentJobTypeData toRet = new TwsAssessmentJobTypeData();
        String taskXml = jobAttributes.getAttr("TASK");
        XmlElement taskDefintionXml = XmlLoader.from((String)taskXml);
        XmlElement taskApplctionXml = taskDefintionXml.getFirstChildElementByName("jsdl:application");
        switch (taskType = taskApplctionXml.getAttribute("name")) {
            case "database": {
                toRet.originalType = "TASK databases";
                toRet.targetType = "Databases";
                break;
            }
            case "executable": {
                toRet.originalType = "TASK executable";
                toRet.targetType = "OS";
                break;
            }
            case "jcl": {
                toRet.originalType = "TASK jcl";
                toRet.targetType = "z/OS";
                break;
            }
            case "filetransfer": {
                toRet.originalType = "TASK file transfer";
                toRet.targetType = "File Transfer";
                break;
            }
            case "restful": {
                toRet.originalType = "TASK restful";
                toRet.targetType = "Web Services";
                break;
            }
            case "ibmi": {
                toRet.originalType = "TASK ibmi";
                toRet.targetType = "OS400";
                break;
            }
            case "r3": {
                toRet.originalType = "TASK SAP R3";
                toRet.targetType = "SAP R3";
                break;
            }
            case "processchain": {
                toRet.originalType = "TASK SAP Process Chain";
                toRet.targetType = "SAP Business Warehouse";
                break;
            }
            case "sapbusinessobjects": {
                toRet.originalType = "TASK SAP Business Objects";
                toRet.targetType = "SAP Business Objects";
                break;
            }
            case "powercenter": {
                toRet.originalType = "TASK powercenter";
                toRet.targetType = "Informatica";
                break;
            }
            default: {
                toRet.originalType = String.format("TASK %s", taskType);
                toRet.targetType = "Dummy";
                toRet.isSupported = false;
            }
        }
        return toRet;
    }
}

