/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CtmPriority;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.MessageIdTable;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SchedEntityUtils;
import com.bmc.ctmconvert.common.message.MessageHandler;
import com.bmc.ctmconvert.common.message_id.MessageId;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.shouts.ShoutsGenerator;
import com.bmc.ctmconvert.tws.InConditionBuilder;
import com.bmc.ctmconvert.tws.JobIDParser;
import com.bmc.ctmconvert.tws.NameBuilder;
import com.bmc.ctmconvert.tws.OS400Handler;
import com.bmc.ctmconvert.tws.OutConditionsManager;
import com.bmc.ctmconvert.tws.RuncycleConvertor;
import com.bmc.ctmconvert.tws.SapHandler;
import com.bmc.ctmconvert.tws.TwsBaseConvertor;
import com.bmc.ctmconvert.tws.TwsCyclicConverter;
import com.bmc.ctmconvert.tws.TwsDefs;
import com.bmc.ctmconvert.tws.TwsGlobals;
import com.bmc.ctmconvert.tws.TwsJobAttributes;
import com.bmc.ctmconvert.tws.TwsOpenToFw;
import com.bmc.ctmconvert.tws.TwsScheduleAttributes;
import com.bmc.ctmconvert.tws.TwsTimeZone;
import com.bmc.ctmconvert.tws.VarTable;
import com.bmc.ctmconvert.tws.variables.VariablesHandler;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import com.bmc.ctmconvert.vc.FieldValidation;
import dependencies.CleanUpConditionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TwsJob
implements SchedEntity {
    private RulesDataSet rules = null;
    private final HashMap<String, String> attributes = new HashMap();
    private final LinkedHashMap<String, String> autoedits = new LinkedHashMap();
    private TwsScheduleAttributes sourceSched;
    private TwsJobAttributes sourceJob;
    private TwsDefs sourceDefinition;
    private TwsJob parent;
    private SchedEntity.TYPE type;
    private ArrayList<String> optionalAttributes;
    ArrayList<Properties> tags;
    private final ArrayList<String> messages = new ArrayList();
    private ArrayList<AssistingJob> assistingJobs;
    private ArrayList<Properties> inConds;
    private ArrayList<Properties> outConds = new ArrayList();
    private ArrayList<Properties> onStmts;
    private static final CtmPriority priorityCalculator = new CtmPriority(0, 101);
    private ArrayList<Properties> shouts = null;
    private boolean convertToPSFT = false;
    private boolean convertToOS400 = false;
    private boolean convertOS400Call2Pgm = false;
    private String date_format = "MMddyyyy";
    private List<Properties> controlResources = null;
    private boolean dsJob = true;
    private UniqueValueGenerator uniqueValueGenerator;
    private final TwsCyclicConverter twsCyclicConverter = new TwsCyclicConverter();

    public TwsJob() {
    }

    public TwsJob(String id, TwsJob parent, TwsDefs sourceDefs) {
        this.sourceDefinition = sourceDefs;
        if (parent != null) {
            this.parent = parent;
            this.type = SchedEntity.TYPE.JOB;
            this.sourceJob = this.sourceDefinition.getJobAttributes(id, parent.getOriginalJobName());
        } else if (!sourceDefs.getSchedules().containsKey(id)) {
            this.handleOrphanJob(id);
        } else {
            this.sourceSched = this.sourceDefinition.getSchedules().get(id);
            this.type = SchedEntity.TYPE.SMART_TABLE;
        }
    }

    public boolean isConvertToOS400() {
        return this.convertToOS400;
    }

    public boolean isConvertOS400Call2Pgm() {
        return this.convertOS400Call2Pgm;
    }

    private boolean isOrphanJob() {
        return this.type == SchedEntity.TYPE.JOB && this.parent == null;
    }

    private void handleOrphanJob(String id) {
        this.type = SchedEntity.TYPE.JOB;
        IAttrHolder attrHeader = this.createEmptySchedulerAttrs(id);
        this.sourceJob = new TwsJobAttributes(attrHeader);
        this.sourceJob.setJobAttributes(this.sourceDefinition.getJobAttributes(id));
    }

    private IAttrHolder createEmptySchedulerAttrs(String id) {
        HashMap headers = AttrHolder.buildHeadersMap((String)Arrays.toString(TwsGlobals.SCHEDULE_ATTRIBUTES).replaceAll("(\\[|\\]|\\s)", ""));
        String[] values = new String[]{this.sourceDefinition.getJobAttributes(id).getAttr("ID"), " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " "};
        return new AttrHolder(values, (Map)headers);
    }

    public static TwsJob createTwsJob(String id, TwsJob parent, TwsDefs sourceDefs) {
        TwsJob twsJob = new TwsJob(id, parent, sourceDefs);
        twsJob.init(sourceDefs.getRules());
        return twsJob;
    }

    private void init(RulesDataSet rules) {
        this.rules = rules;
        this.uniqueValueGenerator = this.sourceDefinition.getUniqueValueGenerator();
        this.convertToPSFT = this.rules.getBooleanRule("PeopleSoft", new String[]{"PSFT_AVAILABLE"});
        if (this.rules.getBooleanRule("OS400", new String[]{"OS400_AVAILABLE"}).booleanValue()) {
            this.convertToOS400 = true;
            this.convertOS400Call2Pgm = this.rules.getBooleanRule("OS400", new String[]{"CALL2PGM"});
        }
        this.date_format = this.rules.getStringRule("TWS rules", new String[]{"DATE_FORMAT"});
        if (this.date_format == null) {
            this.date_format = "MMddyyyy";
        }
        this.attributes.put("JOBNAME", this.applyFieldConversion(this.type == SchedEntity.TYPE.JOB ? "JOBNAME" : "FOLDER_NAME"));
        this.attributes.put("APPLICATION", this.applyFieldConversion("APPLICATION"));
        this.attributes.put("ACTIVE_FROM", "");
        this.attributes.put("ACTIVE_TILL", "");
        this.attributes.put("PRIORITY", this.convertPriority());
        this.attributes.put("GROUP", this.applyFieldConversion("GROUP"));
        this.attributes.put("AUTHOR", this.applyFieldConversion("AUTHOR"));
        this.attributes.put("DESCRIPTION", this.applyFieldConversion("DESCRIPTION"));
        this.setTags();
        String cpuName = this.getOriginalJobName().split("#", 2)[0];
        String validatationKey = "NODEID";
        if (this.sourceDefinition.getCpus().isCpuClass(cpuName)) {
            validatationKey = "NODEGRP";
            Set<String> members = this.sourceDefinition.getCpus().getMembers(cpuName);
            if (!members.isEmpty()) {
                Reporter.addNodeGroupAction((String)cpuName, members, (String)this.generateUniqueID());
            }
        } else {
            cpuName = this.sourceDefinition.getCpus().getPhysName(cpuName);
        }
        this.attributes.put("NODEID", FieldValidation.instance().validateAndReturnFixedValue(validatationKey, cpuName, true, null, null, this.messages));
        if (this.type == SchedEntity.TYPE.JOB) {
            this.attributes.put("OWNER", this.applyFieldConversion("OWNER"));
            this.convertTaskType();
            this.twsCyclicConverter.convertCyclicJob(this);
            this.convertTime();
            String paramVal = this.sourceJob.getscheduleJob().getAttr("critical");
            if (paramVal != null && paramVal.equalsIgnoreCase("Y")) {
                this.attributes.put("CRITICAL", "1");
            }
            if ((paramVal = this.sourceJob.getscheduleJob().getAttr("keyjob")) != null && paramVal.equalsIgnoreCase("Y")) {
                this.attributes.put("CRITICAL", "1");
            }
            if ((paramVal = this.sourceJob.getscheduleJob().getAttr("onuntil")) != null && !paramVal.isEmpty()) {
                Reporter.addMessage(this.messages, (String)"WRN6026", (String)this.generateUniqueID(), (String[])new String[]{this.getOriginalJobName(), this.getJobName(), "onuntil=" + paramVal});
            }
            this.convertMaxDurOnMaxDur();
        }
        if (this.type == SchedEntity.TYPE.SMART_TABLE) {
            this.convertTimeForTable();
            this.handleLimit();
            String attrVal = this.sourceSched.getAttributes().getAttr("keysched").trim();
            if (attrVal != null && attrVal.equalsIgnoreCase("Y")) {
                Reporter.addMessage(this.messages, (String)"INF6107", (String)this.generateUniqueID(), (String[])new String[]{this.getOriginalJobName(), this.getJobName(), "keysched=" + attrVal});
            }
            if ((attrVal = this.sourceSched.getAttributes().getAttr("onuntil").trim()) != null && !attrVal.isEmpty()) {
                Reporter.addMessage(this.messages, (String)"WRN6026", (String)this.generateUniqueID(), (String[])new String[]{this.getOriginalJobName(), this.getJobName(), "onuntil=" + attrVal});
            }
            if ((attrVal = this.sourceSched.getAttributes().getAttr("draft")) != null && attrVal.trim().equalsIgnoreCase("Y")) {
                this.attributes.put("TABLE_USERDAILY", "");
            }
            this.attributes.put("TABLE_DSN", "CTM.SCHEDULE");
        }
        this.generateInConditions();
        this.generateOutConditions();
        this.createAssistingJobs();
        this.handleCarryforward();
        this.handleDeadLine();
        this.handlePrompt();
        String timezone = this.getTimeZone(false);
        if (timezone != null && !timezone.isEmpty()) {
            this.attributes.put("TIMEZONE", timezone);
        }
    }

    public void convertMaxDurOnMaxDur() {
        Optional<Integer> maxDur = this.getMaxDuration();
        maxDur.ifPresent(maxDurValue -> {
            ShoutsGenerator generatorShouts = new ShoutsGenerator();
            this.convertMaxDur(generatorShouts, (Integer)maxDurValue);
            this.convertOnMaxDur(generatorShouts, (int)maxDurValue);
        });
    }

    private Optional<Integer> getMaxDuration() {
        return Optional.ofNullable(this.getSourceJob().getscheduleJob().getAttr("maxdur")).flatMap(GlobalFunctions::getNumberFrom);
    }

    private void convertMaxDur(ShoutsGenerator generatorShouts, Integer maxDurValue) {
        this.getShouts().add(generatorShouts.generateShoutOnRunTime("ALERTS", String.format("Job %%%%JOBNAME is executing from more than %d minutes", maxDurValue), ">", String.valueOf(maxDurValue)));
    }

    private void convertOnMaxDur(ShoutsGenerator generatorShouts, int maxDur) {
        String onMaxDur = Optional.ofNullable(this.getSourceJob().getscheduleJob().getAttr("onmaxdur")).orElse("");
        if (onMaxDur.equalsIgnoreCase("KILL")) {
            if (SettingsBooleanKeys.isSaas()) {
                this.handleOnMaxDurSaas(generatorShouts, maxDur);
            } else {
                this.handleOnMaxDurOnPremise(generatorShouts, maxDur);
            }
        }
    }

    private void handleOnMaxDurOnPremise(ShoutsGenerator generatorShouts, int maxDur) {
        this.getShouts().add(generatorShouts.generateShoutOnRunTime("KILLJOB", "%%%%ORDERID", ">", String.valueOf(maxDur)));
        this.sourceDefinition.addGeneralMessage("WRN6043");
    }

    private void handleOnMaxDurSaas(ShoutsGenerator generatorShouts, int maxDur) {
        if (SchedEntityUtils.isOsJob((SchedEntity)this)) {
            this.sourceDefinition.addGeneralMessage("WRN6047");
            this.getShouts().add(generatorShouts.generateShoutOnRunTime("NotifyScriptLnx", "KILLJOB %%%%ORDERID", ">", String.valueOf(maxDur)));
        } else {
            this.getShouts().add(generatorShouts.generateShoutOnRunTime("EM", "Job %%%%JOBNAME %%%%ORDERID runs for too long, and should be killed.", ">", String.valueOf(maxDur)));
            this.addMessage("WRN6044", this.getOriginalJobName(), this.getJobName());
        }
    }

    public TwsJobAttributes getSourceJob() {
        return this.sourceJob;
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    private void handleLimit() {
        String attrVal = this.sourceSched.getAttributes().getAttr("limit").trim();
        if (attrVal != null && !attrVal.isEmpty()) {
            if (GlobalFunctions.isNumber((String)attrVal)) {
                HashMap<String, String> action = new HashMap<String, String>();
                action.put("ACTENTTYPE", "QR");
                action.put("JOBID", this.generateUniqueID());
                action.put("ACTENTNAME", this.sourceSched.getAttributes().getAttr("schedule"));
                action.put("ACTENTQTY", attrVal);
                action.put("ACTSTATUS", "0");
                Reporter.addAction(action);
            } else {
                String msgidIllegalNumberParameters = "WRN0015";
                String string = "limit";
                String attr = this.getAttr("schedule");
                this.addMessage(msgidIllegalNumberParameters, string, attr);
            }
        }
    }

    public void addMessage(String msgid, String ... stringsArr) {
        Reporter.addMessage(this.messages, (String)msgid, (String)this.generateUniqueID(), (String[])stringsArr);
    }

    private void handlePrompt() {
        ArrayList<String> arrList = this.getParamValues("PROMPT");
        if (arrList == null || arrList.size() == 0) {
            return;
        }
        String twsOriginalName = "";
        twsOriginalName = this.type == SchedEntity.TYPE.JOB ? this.sourceJob.getName() : this.sourceSched.getName();
        for (int i = 0; i < arrList.size(); ++i) {
            Reporter.addMessage(this.messages, (String)"INF6106", (String)this.generateUniqueID(), (String[])new String[]{arrList.get(i), twsOriginalName, this.attributes.get("JOBNAME")});
            this.attributes.put("CONFIRM", "1");
        }
    }

    private void handleDeadLine() {
        String typeString;
        String deadline;
        String name;
        if (this.type == SchedEntity.TYPE.JOB) {
            name = this.sourceJob.getName();
            ArrayList<String> arrList = this.getParamValues("deadline");
            if (arrList == null || arrList.size() == 0) {
                return;
            }
            if (arrList.size() > 1) {
                Reporter.addMessage(this.messages, (String)"WRN6014", (String)this.generateUniqueID(), (String[])new String[]{"deadline", name});
                return;
            }
            if (arrList.size() == 0) {
                return;
            }
            deadline = arrList.get(0);
            typeString = "Job";
        } else {
            deadline = this.sourceSched.getAttributes().getAttr("deadline").trim();
            name = this.sourceSched.getName();
            typeString = "SMART";
        }
        if (deadline == null || deadline.trim().isEmpty()) {
            return;
        }
        String[] params = deadline.split("[ ]+");
        String preValue = "";
        for (int i = 0; i < params.length; ++i) {
            String nextVal;
            String val = params[i];
            String string = nextVal = i < params.length - 1 ? params[i + 1] : "";
            if (val.matches("^[+-][0-9]+$")) {
                Reporter.addMessage(this.messages, (String)"WRN6042", (String)this.generateUniqueID(), (String[])new String[]{this.getJobName(), String.format("%s %s %s", preValue, val, nextVal)});
                break;
            }
            preValue = val;
        }
        Properties shout = new Properties();
        shout.put("DEST", "EM");
        shout.put("MESSAGE", String.format("Submission of %s %s delayed beyond %s", typeString, name, params[0]));
        shout.put("TIME", params[0]);
        shout.put("URGENCY", "R");
        shout.put("WHEN", "LATESUB");
        this.getShouts().add(shout);
        shout = new Properties();
        shout.put("DEST", "EM");
        shout.put("MESSAGE", String.format("Execution of %s %s delayed beyond %s", typeString, name, params[0]));
        shout.put("TIME", params[0]);
        shout.put("URGENCY", "R");
        shout.put("WHEN", "LATETIME");
        this.getShouts().add(shout);
    }

    private void handleCarryforward() {
        String carryforward = null;
        if (this.type == SchedEntity.TYPE.JOB) {
            if (this.parent != null) {
                carryforward = this.parent.getSourceSched().getAttributes().getAttr("carryforward");
            }
            if (carryforward != null && carryforward.equalsIgnoreCase("Y")) {
                this.setOptionalAtrribute("MAXWAIT", this.rules.getStringRule("TWS rules", new String[]{"MAXWAIT"}));
            }
        }
    }

    private void setTags() {
        this.attributes.put("TAG_RELATIONSHIP", "OR");
        if (this.type.equals((Object)SchedEntity.TYPE.SMART_TABLE)) {
            String carryforward;
            String rawValidFrom;
            boolean emptyRBCNeeded;
            if (this.sourceSched.getParams() != null) {
                String[] tmpArr;
                String freeDays = this.sourceSched.getAttributes().getAttr("freedays").trim();
                if (!freeDays.isEmpty() && (tmpArr = freeDays.split(" ", 2)).length > 1) {
                    Reporter.addMessage(this.messages, (String)"WRN6013", (String)this.generateUniqueID(), (String[])new String[]{this.getJobName(), freeDays});
                    freeDays = tmpArr[0];
                }
                HashMap allCycles = new HashMap();
                allCycles.put(true, new ArrayList());
                allCycles.put(false, new ArrayList());
                for (Object parameter : this.sourceSched.getParams()) {
                    if (parameter.getAttr("PARAMETER").equals("ON")) {
                        ((ArrayList)allCycles.get(true)).add(parameter.getAttr("VALUE"));
                        continue;
                    }
                    if (!parameter.getAttr("PARAMETER").equals("EXCEPT")) continue;
                    ((ArrayList)allCycles.get(false)).add(parameter.getAttr("VALUE"));
                }
                Integer tagUniqueIndex = 0;
                for (Object isOn : allCycles.keySet()) {
                    for (String cycle : (ArrayList)allCycles.get(isOn)) {
                        Properties tag = new Properties();
                        if (!freeDays.isEmpty()) {
                            tag.setProperty("CONFCAL", "not-" + freeDays);
                        }
                        RuncycleConvertor runcycleConvertor = this.getRunCycleConvertor();
                        if (((Boolean)isOn).booleanValue()) {
                            runcycleConvertor.convertOnRuncycle(cycle, tag, this.messages, this.generateUniqueID());
                        } else {
                            runcycleConvertor.convertExceptRuncycle(cycle, tag, this.messages, this.generateUniqueID());
                        }
                        if (tag != null) {
                            if (this.tags == null) {
                                this.tags = new ArrayList();
                            }
                            if (tag.containsKey("NAME")) {
                                String tagName = (String)tag.get("NAME");
                                String newTagName = FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", tagName, true, null, null, this.messages);
                                if (newTagName.compareTo(tagName) != 0) {
                                    tag.remove("NAME");
                                    if (newTagName.length() < tagName.length()) {
                                        Integer n = tagUniqueIndex;
                                        tagUniqueIndex = tagUniqueIndex + 1;
                                        newTagName = this.generateUniqueTagName(newTagName, n);
                                        Reporter.addMessage(this.messages, (String)"INF0013", (String)this.generateUniqueID(), (String[])new String[]{"NAME", "", tagName, newTagName});
                                    }
                                    tag.put("NAME", newTagName);
                                }
                                this.tags.add(tag);
                            }
                        }
                        if (!cycle.toLowerCase().contains("request")) continue;
                        this.attributes.put("TABLE_USERDAILY", "");
                    }
                }
            }
            boolean bl = emptyRBCNeeded = this.tags == null || this.tags.size() == 0;
            if (!emptyRBCNeeded) {
                emptyRBCNeeded = true;
                for (Properties tag : this.tags) {
                    emptyRBCNeeded = emptyRBCNeeded && tag.getProperty("NAME").startsWith("!");
                }
            }
            if (emptyRBCNeeded) {
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.add(this.generateEmptyTag());
            }
            if ((rawValidFrom = this.sourceSched.getAttributes().getAttr("validfrom")) != null && !rawValidFrom.isEmpty()) {
                String[] tmpArr = rawValidFrom.split("/", 3);
                String activeFrom = String.format("%s%s%s", tmpArr[2], tmpArr[0], tmpArr[1]);
                if (this.date_format.equalsIgnoreCase("ddMMyyyy")) {
                    activeFrom = String.format("%s%s%s", tmpArr[2], tmpArr[1], tmpArr[0]);
                } else if (this.date_format.equalsIgnoreCase("yyyyMMdd")) {
                    activeFrom = String.format("%s%s%s", tmpArr[0], tmpArr[1], tmpArr[2]);
                }
                for (Properties tag : this.tags) {
                    if (tag.containsKey("ACTIVE_FROM") && !activeFrom.equals(tag.get("ACTIVE_FROM"))) {
                        Reporter.addMessage(this.messages, (String)"INF0010", (String)this.generateUniqueID(), (String[])new String[]{"TWS", "validfrom", activeFrom, "RUNCYLCLE validfrom", (String)tag.get("ACTIVE_FROM"), "ACTIVE_FROM", activeFrom});
                    }
                    tag.put("ACTIVE_FROM", activeFrom);
                }
            }
            if ((carryforward = this.sourceSched.getAttributes().getAttr("carryforward")) != null && carryforward.equalsIgnoreCase("Y")) {
                for (Properties tag : this.tags) {
                    tag.put("MAXWAIT", this.rules.getStringRule("TWS rules", new String[]{"MAXWAIT"}));
                }
            }
        }
    }

    private RuncycleConvertor getRunCycleConvertor() {
        return this.sourceDefinition.getRunCycleConvertor();
    }

    private Properties generateEmptyTag() {
        Properties toRet = new Properties();
        toRet.put("NAME", "Manual_order");
        String[] monthsArr = GlobalFunctions.getMonthsArray();
        for (int i = 0; i < monthsArr.length; ++i) {
            toRet.put(monthsArr[i], "0");
        }
        return toRet;
    }

    private void convertTime() {
        String timeTo;
        if (this.sourceJob == null) {
            return;
        }
        if (this.sourceJob.getscheduleJobParms() != null) {
            for (IAttrHolder ah : this.sourceJob.getscheduleJobParms()) {
                String param = ah.getAttr("PARAMETER");
                String value = ah.getAttr("VALUE");
                if (param.equalsIgnoreCase("AT") && !value.isEmpty()) {
                    this.resolveTime(value, true);
                }
                if (!param.equalsIgnoreCase("schedtime") || value.isEmpty()) continue;
                Reporter.addMessage(this.messages, (String)"INF6107", (String)this.generateUniqueID(), (String[])new String[]{this.getOriginalJobName(), this.getJobName(), "schedtime".toUpperCase() + "=" + value});
            }
        }
        if (!(timeTo = this.sourceJob.getscheduleJob().getAttr("until")).trim().isEmpty()) {
            this.resolveTime(timeTo, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertTimeForTable() {
        if (this.sourceSched == null) {
            return;
        }
        if (this.sourceSched.getAttributes() == null) {
            return;
        }
        String schedTime = this.sourceSched.getAttributes().getAttr("schedtime");
        if (schedTime != null && !schedTime.isEmpty()) {
            Reporter.addMessage(this.messages, (String)"INF6107", (String)this.generateUniqueID(), (String[])new String[]{this.getOriginalJobName(), this.getJobName(), "schedtime".toUpperCase() + "=" + schedTime});
        }
        String timeFrom = this.sourceSched.getAttributes().getAttr("at");
        this.resolveTime(timeFrom, true);
        String timeTo = this.sourceSched.getAttributes().getAttr("until");
        this.resolveTime(timeTo, false);
        if (this.sourceSched.getParams() == null) {
            return;
        }
        String schedtimeExpr = ".*SCHEDTIME[ \t]+([0-9]{4}).*";
        ArrayList<String> cycleSchedTimes = null;
        ArrayList<String> runCycles = null;
        for (Object attrs : this.sourceSched.getParams()) {
            String parm = attrs.getAttr("PARAMETER");
            if (!parm.equalsIgnoreCase("ON") && !parm.equalsIgnoreCase("EXCEPT") && !parm.equalsIgnoreCase("SCHEDTIME")) continue;
            if (runCycles == null) {
                runCycles = new ArrayList<String>();
            }
            runCycles.add(attrs.getAttr("VALUE"));
        }
        if (runCycles != null) {
            Pattern schedtimePattern = Pattern.compile(".*SCHEDTIME[ \t]+([0-9]{4}).*");
            for (String runCycle : runCycles) {
                Matcher matcher = schedtimePattern.matcher(runCycle);
                if (!matcher.matches()) continue;
                if (cycleSchedTimes == null) {
                    cycleSchedTimes = new ArrayList<String>();
                }
                cycleSchedTimes.add(matcher.group(1));
            }
            this.twsCyclicConverter.convertCyclicFolder(this, runCycles);
            this.setFolderTimes(runCycles);
            if (cycleSchedTimes != null) {
                Reporter.addMessage(this.messages, (String)"INF6107", (String)this.generateUniqueID(), (String[])new String[]{this.getOriginalJobName(), this.getJobName(), "schedtime".toUpperCase() + "=" + cycleSchedTimes.toString()});
            }
            String[] params = null;
            if ((timeTo == null || timeTo.isEmpty()) && timeFrom != null && !timeFrom.isEmpty() && timeFrom.matches("(.*[0-9]+(.*[0-9]+?) [+-][0-9]+.*)")) {
                params = timeFrom.split("[\\t ]+");
            } else if ((timeFrom == null || timeFrom.isEmpty()) && timeTo != null && !timeTo.isEmpty() && timeTo.matches("(.*[0-9]+(.*[0-9]+?) [+-][0-9]+.*)")) {
                params = timeTo.split("[\\t ]+");
            }
            if (params != null) {
                ArrayList<String> offsetArray = new ArrayList<String>();
                for (String parm : params) {
                    if (!parm.toLowerCase().matches("((day|weekday|workday)s?)|([-+][0-9]+)")) continue;
                    offsetArray.add(parm);
                }
                if (offsetArray.size() == 2) {
                    if (this.tags != null) {
                        for (Properties tag : this.tags) {
                            if (tag.contains("CONFCAL")) {
                                Reporter.addMessage(this.messages, (String)"WRN0014", (String)this.generateUniqueID(), (String[])new String[]{"TWS", "CONFCAL", tag.get("CONFCAL").toString(), (String)offsetArray.get(1), "Offset definition is not simple"});
                            }
                            tag.put("CONFCAL", offsetArray.get(1));
                            tag.put("SHIFT", "NOCONFCAL");
                            int shiftnum = 0;
                            try {
                                shiftnum = Integer.valueOf(((String)offsetArray.get(0)).replace("+", ""));
                                if (shiftnum >= -62 && shiftnum <= 62) continue;
                                Reporter.addMessage(this.messages, (String)"WRN0020", (String)this.generateUniqueID(), (String[])new String[]{"TWS", "Shift", (String)offsetArray.get(0), "SHIFTNUM", String.valueOf(shiftnum), "Number from -62 to 62"});
                            }
                            catch (NumberFormatException e) {
                                Reporter.addMessage(this.messages, (String)"WRN0010", (String)this.generateUniqueID(), (String[])new String[]{"TWS", "Shift", (String)offsetArray.get(0), "SHIFTNUM", String.valueOf(shiftnum)});
                                shiftnum = 0;
                            }
                            finally {
                                tag.put("SHIFTNUM", String.valueOf(shiftnum));
                            }
                        }
                    }
                } else {
                    Reporter.addMessage(this.messages, (String)"WRN6007", (String)this.generateUniqueID(), (String[])new String[]{this.getJobName(), "Offset definition is not simple " + offsetArray.toString().replace(",", "")});
                }
            }
        }
    }

    private void setFolderTimes(ArrayList<String> runCycles) {
        if (this.attributes.containsKey("TIMEFROM") && this.attributes.containsKey("TIMETO")) {
            return;
        }
        String atTimeExpr = ".*AT[ \t]+([0-9]{4}).*";
        String untilTimeExpr = ".*UNTIL[ \t]+([0-9]{4}).*";
        Pattern atPattern = Pattern.compile(".*AT[ \t]+([0-9]{4}).*");
        Pattern untilPattern = Pattern.compile(".*UNTIL[ \t]+([0-9]{4}).*");
        for (String runCycle : runCycles) {
            Matcher matcher = atPattern.matcher(runCycle);
            if (!matcher.matches()) continue;
            this.resolveTime(matcher.group(1), true);
            Object timeToWarning = "";
            timeToWarning = (String)timeToWarning + "AT = " + matcher.group(1);
            matcher = untilPattern.matcher(runCycle);
            if (matcher.matches()) {
                this.resolveTime(matcher.group(1), false);
                timeToWarning = (String)timeToWarning + " UNTIL = " + matcher.group(1);
            }
            if (runCycles.size() > 1) {
                ArrayList<String> cycleAtTimes = new ArrayList<String>();
                for (String multiAtDefinition : runCycles) {
                    matcher = atPattern.matcher(multiAtDefinition);
                    if (!matcher.matches()) continue;
                    if (cycleAtTimes == null) {
                        cycleAtTimes = new ArrayList();
                    }
                    cycleAtTimes.add(matcher.group(1));
                }
                if (cycleAtTimes.size() > 1) {
                    Reporter.addMessage(this.messages, (String)"WRN6040", (String)this.generateUniqueID(), (String[])new String[]{this.getJobName(), cycleAtTimes.toString()});
                }
            }
            return;
        }
    }

    private void resolveTime(String value, boolean isTimeFrom) {
        String[] splittedValue = value.split(" ", 2);
        String time = splittedValue[0].trim();
        if (time.length() == 4 && GlobalFunctions.isNumber((String)time)) {
            if (isTimeFrom) {
                this.attributes.put("TIMEFROM", time);
            } else {
                this.attributes.put("TIMETO", time);
            }
        } else if (!time.isEmpty()) {
            Reporter.addMessage(this.messages, (String)"WRN0017", (String)this.generateUniqueID(), (String[])new String[]{isTimeFrom ? "AT" : "UNTIL", "TWS", value, "hhmm"});
        }
    }

    private String convertPriority() {
        Integer intPrioirty;
        String rawPriority = this.type == SchedEntity.TYPE.JOB ? this.sourceJob.getscheduleJob().getAttr("priority") : this.sourceSched.getAttributes().getAttr("priority");
        if ((rawPriority = rawPriority.toUpperCase().replace("HI", "100").replace("GO", "101")).matches("^0+$")) {
            this.attributes.put("CONFIRM", "1");
        }
        if (rawPriority.isEmpty() || !rawPriority.matches("[0-9]+")) {
            rawPriority = "0";
        }
        if ((intPrioirty = Integer.valueOf(rawPriority)) > 101) {
            intPrioirty = 101;
        }
        if (intPrioirty < 0) {
            intPrioirty = 0;
        }
        return priorityCalculator.calculatePriority(intPrioirty.intValue());
    }

    public void setOptionalAtrribute(String attribute, String value) {
        if (this.optionalAttributes == null) {
            this.optionalAttributes = new ArrayList();
        }
        this.optionalAttributes.add(attribute);
        this.attributes.put(attribute, value);
    }

    public ArrayList<String> getListOfTables() {
        String varTable = "";
        ArrayList<String> tables = new ArrayList<String>();
        if (this.type.equals((Object)SchedEntity.TYPE.SMART_TABLE)) {
            varTable = this.sourceSched.getAttributes().getAttr("vartable");
            if (varTable != null && !varTable.isEmpty()) {
                tables.add(varTable);
            }
        } else if (this.type.equals((Object)SchedEntity.TYPE.JOB) && !this.isOrphanJob() && (varTable = this.parent.getSourceSched().getAttributes().getAttr("vartable")) != null && !varTable.isEmpty()) {
            tables.add(varTable);
        }
        String cpuName = this.GetOrigNodeid();
        String tempParamTable = this.sourceDefinition.getCpus().getTable(cpuName);
        if (tempParamTable != null && !tempParamTable.isEmpty()) {
            tables.add(tempParamTable);
        }
        return tables;
    }

    private void convertTaskType() {
        String taskType = "Command";
        String tws_tasktype = this.getSourceJobAttribute("tasktype").trim();
        String commandtype_task = this.getSourceJobAttribute("commandType").trim();
        if (commandtype_task.equals("TASK")) {
            TwsBaseConvertor twsTaskJob = this.sourceDefinition.getTaskFactory().getConvertor(this);
            twsTaskJob.convert();
            return;
        }
        String command = this.getSourceJobAttribute("scriptname/docommand").trim();
        command = this.convertCommand(this, command);
        if (this.convertToPSFT && this.psftFilter(command)) {
            this.convert2PsftJob(command);
            Reporter.addMessage(this.messages, (String)"INF6101", (String)this.generateUniqueID(), (String[])new String[]{this.getOriginalJobName()});
            return;
        }
        if (this.convertToOS400 && this.os400Filter(command, tws_tasktype)) {
            this.convert2Os400Job(command);
            Reporter.addMessage(this.messages, (String)"INF0012", (String)this.generateUniqueID(), (String[])new String[]{this.getOriginalJobName(), this.attributes.get("JOBNAME")});
            return;
        }
        if (SapHandler.isSap(tws_tasktype)) {
            SapHandler sapHandler = new SapHandler();
            sapHandler.convertToSap(command, this);
            return;
        }
        if (this.rules.getTaskTypeHandler().isToJobType()) {
            for (String taskTypeFilter : this.rules.getTaskTypeHandler().getTaskTypeFilters()) {
                if (taskTypeFilter == null || !command.contains(taskTypeFilter)) continue;
                taskType = "Job";
                break;
            }
            if (!taskType.equals("Job")) {
                this.validateCmdline(command);
            } else {
                ArrayList argsArray = GlobalFunctions.cmdline2ArgArr((String)command.trim());
                if (argsArray == null) {
                    taskType = "Command";
                    this.validateCmdline(command);
                    Reporter.addMessage(this.messages, (String)"INF0008", (String)this.generateUniqueID(), (String[])new String[]{Params.instance().getVendorName(), "MEMLIB", command});
                } else {
                    String memlib = FieldValidation.instance().validateAndReturnFixedValue("MEMLIB", (String)argsArray.get(0), true, null, null, this.messages);
                    String memname = FieldValidation.instance().validateAndReturnFixedValue("MEMNAME", (String)argsArray.get(1), true, null, null, this.messages);
                    this.attributes.put("MEMLIB", memlib);
                    this.attributes.put("MEMNAME", memname);
                    for (int i = 2; argsArray.size() > 2 && i < argsArray.size(); ++i) {
                        this.autoedits.put(String.format("%%%%PARM%d", i - 1), (String)argsArray.get(i));
                    }
                }
            }
        } else {
            this.validateCmdline(command);
        }
        if (this.isDummyConversion()) {
            if (!Params.instance().getGUIVersion().equals("7")) {
                this.autoedits.put("%%$BMCWAIORIGTYPE", taskType);
            }
            this.attributes.put("TASKTYPE", "Dummy");
        } else {
            this.attributes.put("TASKTYPE", taskType);
        }
    }

    private String convertCommand(SchedEntity job, String command) {
        MessageHandler messageHandler = VariablesHandler.createMessageHandler(job, "WRN6012");
        return new VariablesHandler(this, VarTable.instance()).convert(command, messageHandler);
    }

    boolean isDummyConversion() {
        return this.rules.getTaskTypeHandler().isToDummy();
    }

    private void validateCmdline(String command) {
        FieldValidation.instance().cmdLineValidateAndReportMessages(command, this.generateUniqueID(), this.messages);
        this.attributes.put("CMDLINE", command);
    }

    private void convert2PsftJob(String command) {
        HashMap<String, String> psftParameters = new HashMap<String, String>();
        psftParameters.put("PROCESSNAME", this.rules.getStringRule("PeopleSoft", new String[]{"PROCESSNAME"}));
        psftParameters.put("TYPE", this.rules.getStringRule("PeopleSoft", new String[]{"TYPE"}));
        psftParameters.put("RUNCONTROL", this.rules.getStringRule("PeopleSoft", new String[]{"RUNCONTROL"}));
        psftParameters.put("RUNLOCATION", this.rules.getStringRule("PeopleSoft", new String[]{"RUNLOCATION"}));
        StringBuilder sb = new StringBuilder();
        psftParameters.keySet().forEach(parameterKey -> {
            if (sb.toString().isEmpty()) {
                sb.append("(");
            } else {
                sb.append("|");
            }
            String parameterValue = (String)psftParameters.get(parameterKey);
            if (parameterValue != null && !parameterValue.isEmpty()) {
                sb.append(parameterValue);
            }
        });
        sb.append(")");
        String keyWordsGroup = sb.toString();
        String expr = "(.*)" + keyWordsGroup + " (.+)";
        String head = command;
        Pattern varPattern = Pattern.compile(expr);
        Matcher matcher = varPattern.matcher(head);
        HashMap<String, String> psftCmdlineParameters = new HashMap<String, String>();
        while (matcher.matches()) {
            String key = matcher.group(2);
            String value = matcher.group(3);
            psftCmdlineParameters.put(key, value);
            head = matcher.group(1);
            matcher = varPattern.matcher(head);
        }
        String processName = (String)psftCmdlineParameters.get(psftParameters.get("PROCESSNAME"));
        String type = (String)psftCmdlineParameters.get(psftParameters.get("TYPE"));
        String runControl = (String)psftCmdlineParameters.get(psftParameters.get("RUNCONTROL"));
        String runLocation = (String)psftCmdlineParameters.get(psftParameters.get("RUNLOCATION"));
        if (processName == null || processName.isEmpty()) {
            processName = "PSFT_PROCESSNAME_DEFAULT";
            Reporter.addMessage(this.messages, (String)"WRN6017", (String)this.generateUniqueID(), (String[])new String[]{"PeopleSoft Process Name", processName});
        }
        if (type == null || type.isEmpty()) {
            type = " PSFT_TYPE_DEFAULT";
            Reporter.addMessage(this.messages, (String)"WRN6017", (String)this.generateUniqueID(), (String[])new String[]{"PeopleSoft Type", type});
        } else if ((type = type.trim()).startsWith("'") && type.endsWith("'")) {
            type = type.replaceAll("^'", "");
            type = type.replaceAll("'$", "");
        }
        if (runControl == null || runControl.isEmpty()) {
            runControl = " PSFT_RUNCONTROL_DEFAULT";
            Reporter.addMessage(this.messages, (String)"WRN6017", (String)this.generateUniqueID(), (String[])new String[]{"PeopleSoft Run Control", runControl});
        }
        if (runLocation == null || runLocation.isEmpty()) {
            runLocation = " PSFT_RUNLOCATION_DEFAULT";
            Reporter.addMessage(this.messages, (String)"WRN6017", (String)this.generateUniqueID(), (String[])new String[]{"PeopleSoft Run Location", runLocation});
        }
        processName = processName.trim();
        type = type.trim();
        runControl = runControl.trim();
        runLocation = runLocation.trim();
        String owner = this.attributes.get("OWNER");
        String userID = owner == null || owner.isEmpty() ? "DEFAULT_USERID" : owner;
        this.autoedits.put("%%PS8-CON_PROFILE", this.attributes.get("OWNER"));
        this.autoedits.put("%%PS8-USERID", userID);
        this.autoedits.put("%%PS8-RUNCONTROLID", runControl);
        this.autoedits.put("%%PS8-SERVERNAME", runLocation);
        this.autoedits.put("%%PS8-PRCSTYPE", type);
        this.autoedits.put("%%PS8-PRCSNAME", processName);
        this.autoedits.put("%%PS8-APOUT", "1");
        if (this.isDummyConversion()) {
            this.attributes.put("TASKTYPE", "Dummy");
        } else {
            this.attributes.put("TASKTYPE", "Job");
        }
        this.attributes.put("MEMLIB", "Not in use for PeopleSoft jobs");
        this.validateCmdline(command);
        String memname = FieldValidation.instance().validateAndReturnFixedValue("MEMNAME", this.getOriginalJobName(), true, null, null, this.messages);
        this.attributes.put("MEMNAME", memname);
        this.setOptionalAtrribute("APPL_FORM", "PEOPLESOFT");
        this.setOptionalAtrribute("APPL_TYPE", "PS8");
        this.setOptionalAtrribute("APPL_VER", "9.0.0.000");
        this.setOptionalAtrribute("CM_VER", "6.1.01");
    }

    private void convert2Os400Job(String command) {
        String os400Command = command;
        StringBuffer cmdline = new StringBuffer("");
        StringBuffer jobname = new StringBuffer(OS400Handler.getOs400JobName(this.attributes.get("JOBNAME"), this.getOriginalJobName()));
        StringBuffer user = new StringBuffer(OS400Handler.getOS400Owner(this.attributes.get("OWNER"), this.getSourceJobAttribute("streamlogon")));
        StringBuffer memname = new StringBuffer("NOTINUSE");
        StringBuffer memlib = new StringBuffer("NOTINUSE");
        StringBuffer objtyp = new StringBuffer("*CMDLINE");
        String os400Action = "SUBMIT";
        int actionEnd = os400Command.indexOf(":");
        if (actionEnd > 0) {
            os400Action = os400Command.substring(0, actionEnd);
            os400Command = os400Command.substring(actionEnd + 1).trim();
        }
        if (os400Action.equalsIgnoreCase("SUBMIT")) {
            OS400Handler.parseCommandLineWithActionSubmit(os400Command, jobname, user, cmdline, this.autoedits);
        } else if (os400Action.equalsIgnoreCase("DOCOMMAND")) {
            cmdline = new StringBuffer(os400Command);
        }
        if (this.convertOS400Call2Pgm) {
            OS400Handler.converstCallCommand(cmdline, objtyp, memlib, memname, this.autoedits);
        }
        this.attributes.put("TASKTYPE", "Job");
        this.attributes.put("OWNER", user.toString());
        this.attributes.put("JOBNAME", jobname.toString());
        this.attributes.put("MEMLIB", memlib.toString());
        this.attributes.put("MEMNAME", memname.toString());
        this.attributes.put("PARENT_TABLE", this.getParentName());
        OS400Handler.setOS400DefaultAttribute(this);
        OS400Handler.setOS400AutoeditVariables(cmdline.toString(), objtyp.toString(), this.attributes.get("OWNER"), this.attributes.get("JOBNAME"), this.attributes.get("MEMNAME"), this.attributes.get("MEMLIB"), this.autoedits);
    }

    private boolean psftFilter(String command) {
        HashMap<String, String> psftParameters = new HashMap<String, String>();
        psftParameters.put("PROCESSNAME", this.rules.getStringRule("PeopleSoft", new String[]{"PROCESSNAME"}));
        psftParameters.put("TYPE", this.rules.getStringRule("PeopleSoft", new String[]{"TYPE"}));
        psftParameters.put("RUNCONTROL", this.rules.getStringRule("PeopleSoft", new String[]{"RUNCONTROL"}));
        psftParameters.put("RUNLOCATION", this.rules.getStringRule("PeopleSoft", new String[]{"RUNLOCATION"}));
        if (psftParameters.isEmpty()) {
            return false;
        }
        for (String parameterValue : psftParameters.values()) {
            if (command.contains(parameterValue.trim() + " ")) continue;
            return false;
        }
        return true;
    }

    private boolean os400Filter(String command, String tasktype) {
        if (!tasktype.equalsIgnoreCase("other")) {
            return false;
        }
        HashMap<String, String> os400Parameters = new HashMap<String, String>();
        os400Parameters.put("SUBMIT", this.rules.getStringRule("OS400", new String[]{"SUBMIT"}));
        os400Parameters.put("DOCOMMAND", this.rules.getStringRule("OS400", new String[]{"DOCOMMAND"}));
        if (os400Parameters.isEmpty()) {
            return false;
        }
        for (String parameterValue : os400Parameters.values()) {
            if (!command.startsWith(parameterValue.trim() + ":")) continue;
            return true;
        }
        return false;
    }

    public String getApplication() {
        return this.attributes.get("APPLICATION");
    }

    public List<AssistingJob> getAssistingJobs() {
        return this.assistingJobs;
    }

    private void createAssistingJobs() {
        TwsOpenToFw twsOpenToFw = new TwsOpenToFw(this, this.attributes, this.sourceDefinition);
        ArrayList<AssistingJob> opensJobs = twsOpenToFw.createOpensJobs();
        if (this.assistingJobs == null) {
            this.assistingJobs = opensJobs;
        } else if (opensJobs != null) {
            this.assistingJobs.addAll(opensJobs);
        }
        AssistingJob recoveryJob = this.convertRecovery();
        if (recoveryJob != null) {
            if (this.assistingJobs == null) {
                this.assistingJobs = new ArrayList();
            }
            this.assistingJobs.add(recoveryJob);
        }
    }

    private AssistingJob convertRecovery() {
        AssistingJob retJob = null;
        if (this.type == SchedEntity.TYPE.JOB) {
            Properties tmpStatement;
            String[] tailArr;
            String recoveryStatement = this.sourceJob.getJobAttributes().getAttr("recovery").replaceAll("[\r\n\t ]+", " ").trim();
            String[] tmpArr = recoveryStatement.split(" ", 2);
            String recoveryAction = tmpArr[0];
            String tail = tmpArr.length > 1 ? tmpArr[1] : null;
            String after = null;
            String prompt = null;
            while (tail != null && (tailArr = tail.split(" ", 2)).length > 1) {
                String key = tailArr[0];
                String expr = tailArr[1].startsWith("\"") ? "\"(.+)\"( (.*))?" : "(.+?)( (.*))?";
                Pattern pattern = Pattern.compile(expr);
                Matcher matcher = pattern.matcher(tailArr[1]);
                if (!matcher.matches()) break;
                if (key.equalsIgnoreCase("AFTER")) {
                    after = matcher.group(1);
                } else {
                    prompt = matcher.group(1);
                }
                tail = matcher.group(3);
            }
            if (after != null && !after.isEmpty()) {
                if (!after.matches(".+#.+")) {
                    after = String.format("%s#%s", after, this.GetOrigNodeid());
                }
                if (recoveryAction.equalsIgnoreCase("RERUN")) {
                    Reporter.addMessage(this.messages, (String)"WRN0016", (String)this.generateUniqueID(), (String[])new String[]{"RECOVERY AFTER", "TWS", "Unable to create recovery jobs for recovery action RERUN"});
                } else {
                    IAttrHolder recoveryAttrs = this.sourceDefinition.getJobAttributes(after);
                    if (recoveryAttrs == null) {
                        Reporter.addMessage(this.messages, (String)"WRN0016", (String)this.generateUniqueID(), (String[])new String[]{"RECOVERY AFTER", "TWS", String.format("Failed to find job %s in job definitions", after)});
                    } else {
                        retJob = new AssistingJob((SchedEntity)this);
                        retJob.setAttribute("JOBNAME", String.format("%s_RECOVERY", recoveryAttrs.getAttr("ID")));
                        Reporter.addMessage(this.messages, (String)"WRN6045", (String)this.generateUniqueID(), (String[])new String[]{this.getOriginalJobName(), this.getParentName(), this.getJobName(), retJob.getJobName()});
                        if (this.isDummyConversion()) {
                            if (!Params.instance().getGUIVersion().equals("7")) {
                                retJob.setAutoedit("%%$BMCWAIORIGTYPE", "Job");
                            }
                            retJob.setAttribute("TASKTYPE", "Dummy");
                        } else {
                            retJob.setAttribute("TASKTYPE", "Command");
                        }
                        retJob.setAttribute("CMDLINE", recoveryAttrs.getAttr("scriptname/docommand"));
                        retJob.setAttribute("TABLE_NAME", this.createTableNameForAssistingJob());
                        retJob.setAttribute("PARENT_TABLE", this.createTableNameForAssistingJob());
                        retJob.setM_tags(null);
                        String twsTaskType = recoveryAttrs.getAttr("tasktype").trim();
                        String command = recoveryAttrs.getAttr("scriptname/docommand");
                        command = this.convertCommand((SchedEntity)retJob, command);
                        retJob.setAttribute("CMDLINE", command);
                        if (this.convertToPSFT && this.psftFilter(command)) {
                            this.convert2PsftJob(command, retJob);
                            Reporter.addMessage(this.messages, (String)"INF6101", (String)retJob.getAttr("JOBNAME"), (String[])new String[]{retJob.getAttr("JOBNAME")});
                        }
                        if (this.convertToOS400 && this.os400Filter(command, twsTaskType)) {
                            this.convert2Os400Job(command);
                            Reporter.addMessage(this.messages, (String)"INF0012", (String)this.generateUniqueID(), (String[])new String[]{this.getOriginalJobName(), this.attributes.get("JOBNAME")});
                        }
                        tmpStatement = new Properties();
                        tmpStatement.setProperty("CODE", "NOTOK");
                        tmpStatement.setProperty("STMT", "*");
                        tmpStatement.setProperty("ACTION", "DOFORCEJOB");
                        tmpStatement.setProperty("ODATE", "ODAT");
                        tmpStatement.setProperty("NAME", retJob.getJobName());
                        tmpStatement.setProperty("TABLE_NAME", this.getParentName());
                        if (this.onStmts == null) {
                            this.onStmts = new ArrayList();
                        }
                        this.onStmts.add(tmpStatement);
                    }
                }
            }
            if (prompt != null && !prompt.isEmpty()) {
                this.addMessage("WRN6039", this.getOriginalJobName(), this.getJobName(), recoveryStatement);
            }
            if (recoveryAction.equalsIgnoreCase("CONTINUE")) {
                outCondList = this.getOutConds();
                if (outCondList != null) {
                    for (Properties tmpCond : outCondList) {
                        tmpStatement = new Properties();
                        tmpStatement.setProperty("CODE", "NOTOK");
                        tmpStatement.setProperty("STMT", "*");
                        tmpStatement.setProperty("ACTION", "DOCOND");
                        tmpStatement.putAll((Map<?, ?>)tmpCond);
                        if (this.onStmts == null) {
                            this.onStmts = new ArrayList();
                        }
                        this.onStmts.add(tmpStatement);
                    }
                }
            } else if (recoveryAction.equalsIgnoreCase("STOP")) {
                outCondList = this.getOutConds();
                if (retJob != null && outCondList != null) {
                    for (Properties tmpCond : outCondList) {
                        retJob.addOutCondition(tmpCond);
                    }
                }
            } else if (recoveryAction.equalsIgnoreCase("RERUN")) {
                Properties tmpStatement2 = new Properties();
                tmpStatement2.setProperty("CODE", "NOTOK");
                tmpStatement2.setProperty("STMT", "*");
                tmpStatement2.setProperty("ACTION", "RERUN");
                if (this.onStmts == null) {
                    this.onStmts = new ArrayList();
                }
                this.onStmts.add(tmpStatement2);
                String currRerun = this.attributes.get("MAXRERUN");
                if (currRerun == null || currRerun.equals("0")) {
                    this.attributes.put("MAXRERUN", "1");
                }
            }
        }
        return retJob;
    }

    private void convert2PsftJob(String command, AssistingJob assistingPsftJob) {
        HashMap<String, String> psftParameters = new HashMap<String, String>();
        psftParameters.put("PROCESSNAME", this.rules.getStringRule("PeopleSoft", new String[]{"PROCESSNAME"}));
        psftParameters.put("TYPE", this.rules.getStringRule("PeopleSoft", new String[]{"TYPE"}));
        psftParameters.put("RUNCONTROL", this.rules.getStringRule("PeopleSoft", new String[]{"RUNCONTROL"}));
        psftParameters.put("RUNLOCATION", this.rules.getStringRule("PeopleSoft", new String[]{"RUNLOCATION"}));
        StringBuilder sb = new StringBuilder();
        for (String parameterKey : psftParameters.keySet()) {
            String parameterValue;
            if (sb.toString().isEmpty()) {
                sb.append("(");
            } else {
                sb.append("|");
            }
            if ((parameterValue = (String)psftParameters.get(parameterKey)) == null || parameterValue.isEmpty()) continue;
            sb.append(parameterValue);
        }
        sb.append(")");
        String keyWordsGroup = sb.toString();
        String expr = "(.*)" + keyWordsGroup + " (.+)";
        String head = command;
        Pattern varPattern = Pattern.compile(expr);
        Matcher matcher = varPattern.matcher(head);
        HashMap<String, String> psftCmdlineParameters = new HashMap<String, String>();
        while (matcher.matches()) {
            String key = matcher.group(2);
            String value = matcher.group(3);
            psftCmdlineParameters.put(key, value);
            head = matcher.group(1);
            matcher = varPattern.matcher(head);
        }
        String processName = (String)psftCmdlineParameters.get(psftParameters.get("PROCESSNAME"));
        String type = (String)psftCmdlineParameters.get(psftParameters.get("TYPE"));
        String runControl = (String)psftCmdlineParameters.get(psftParameters.get("RUNCONTROL"));
        String runLocation = (String)psftCmdlineParameters.get(psftParameters.get("RUNLOCATION"));
        if (processName == null || processName.isEmpty()) {
            processName = "PSFT_PROCESSNAME_DEFAULT";
            Reporter.addMessage(this.messages, (String)"WRN6017", (String)this.generateUniqueID(), (String[])new String[]{"PeopleSoft Process Name", processName});
        }
        if (type == null || type.isEmpty()) {
            type = " PSFT_TYPE_DEFAULT";
            Reporter.addMessage(this.messages, (String)"WRN6017", (String)this.generateUniqueID(), (String[])new String[]{"PeopleSoft Type", type});
        }
        if (runControl == null || runControl.isEmpty()) {
            runControl = " PSFT_RUNCONTROL_DEFAULT";
            Reporter.addMessage(this.messages, (String)"WRN6017", (String)this.generateUniqueID(), (String[])new String[]{"PeopleSoft Run Control", runControl});
        }
        if (runLocation == null || runLocation.isEmpty()) {
            runLocation = " PSFT_RUNLOCATION_DEFAULT";
            Reporter.addMessage(this.messages, (String)"WRN6017", (String)this.generateUniqueID(), (String[])new String[]{"PeopleSoft Run Location", runLocation});
        }
        processName = processName.trim();
        type = type.trim();
        runControl = runControl.trim();
        runLocation = runLocation.trim();
        String owner = assistingPsftJob.getAttr("OWNER");
        String userID = owner == null || owner.isEmpty() ? "DEFAULT_USERID" : owner;
        assistingPsftJob.setAutoedit("%%PS8-CON_PROFILE", assistingPsftJob.getAttr("OWNER"));
        assistingPsftJob.setAutoedit("%%PS8-USERID", userID);
        assistingPsftJob.setAutoedit("%%PS8-RUNCONTROLID", runControl);
        assistingPsftJob.setAutoedit("%%PS8-SERVERNAME", runLocation);
        assistingPsftJob.setAutoedit("%%PS8-PRCSTYPE", type);
        assistingPsftJob.setAutoedit("%%PS8-PRCSNAME", processName);
        assistingPsftJob.setAutoedit("%%PS8-APOUT", "1");
        if (this.isDummyConversion()) {
            assistingPsftJob.setAttribute("TASKTYPE", "Dummy");
        } else {
            assistingPsftJob.setAttribute("TASKTYPE", "Job");
        }
        assistingPsftJob.setAttribute("MEMLIB", "Not in use for PeopleSoft jobs");
        this.validateCmdline(command);
        String memname = FieldValidation.instance().validateAndReturnFixedValue("MEMNAME", this.getOriginalJobName(), true, null, null, this.messages);
        assistingPsftJob.setAttribute("MEMNAME", memname);
        assistingPsftJob.setOptionalAttribute("APPL_FORM", "PEOPLESOFT");
        assistingPsftJob.setOptionalAttribute("APPL_TYPE", "PS8");
        assistingPsftJob.setOptionalAttribute("APPL_VER", "9.0.0.000");
        assistingPsftJob.setOptionalAttribute("CM_VER", "6.1.01");
    }

    public String getAttr(String attrName) {
        return this.attributes.get(attrName);
    }

    public LinkedHashMap<String, String> getAutoedits() {
        return this.autoedits;
    }

    public List<SchedEntity> getChildren() {
        if (this.type == SchedEntity.TYPE.JOB) {
            return null;
        }
        ArrayList<SchedEntity> children = new ArrayList<SchedEntity>();
        for (TwsJobAttributes job : this.sourceSched.getJobs().values()) {
            if (job.getJobAttributes() == null) {
                Reporter.addMessage(this.messages, (String)"ERR6001", (String)this.generateUniqueID(), (String[])new String[]{job.getName(), this.getOriginalJobName()});
                continue;
            }
            children.add(this.sourceDefinition.spawnJob(this, job.getscheduleJob()));
        }
        return children;
    }

    public List<Properties> getCtrlResources() {
        if (this.controlResources == null) {
            this.controlResources = this.generateControlResources();
        }
        return this.controlResources;
    }

    private List<Properties> generateControlResources() {
        ArrayList<Properties> retList = new ArrayList<Properties>();
        if (this.type.equals((Object)SchedEntity.TYPE.SMART_TABLE)) {
            AttrHolderList scheduleAttrs = new AttrHolderList();
            AttrHolderList sourceSchedParams = this.sourceSched.getParams();
            if (sourceSchedParams != null) {
                scheduleAttrs.addAll((Collection)sourceSchedParams);
            }
            ArrayList<String> alreadyConvertedList = new ArrayList<String>();
            for (IAttrHolder scheduleAttr : scheduleAttrs) {
                String[] splittedNEEDS;
                String parameter = scheduleAttr.getAttr("PARAMETER");
                if (!parameter.equalsIgnoreCase("NEEDS")) continue;
                String needs = scheduleAttr.getAttr("VALUE");
                for (String need : splittedNEEDS = needs.split("\\s*,\\s*")) {
                    Properties controlResource = this.convertNeedToControlResource(need, alreadyConvertedList);
                    if (controlResource.isEmpty()) continue;
                    retList.add(controlResource);
                }
            }
        }
        return retList;
    }

    private Properties convertNeedToControlResource(String need, List<String> alreadyConvertedList) {
        Properties controlResource = new Properties();
        String[] resourceDetails = need.trim().split("\\s+", 2);
        String resourceQuantity = this.getResourceQuantity(resourceDetails);
        String resourceName = this.getResourceName(resourceDetails);
        if (!resourceQuantity.equals("1")) {
            this.addMessage("WRN6028", this.getOriginalJobName(), this.getJobName(), need);
        } else if (!alreadyConvertedList.contains(resourceName)) {
            alreadyConvertedList.add(resourceName);
            controlResource.setProperty("NAME", resourceName);
            controlResource.setProperty("TYPE", "E");
        }
        return controlResource;
    }

    public String getGroup() {
        return this.attributes.get("GROUP");
    }

    public List<Properties> getInConds() {
        return this.inConds;
    }

    void generateInConditions() {
        ArrayList<Object> toRet = new ArrayList();
        AttrHolderList fullAttrs = this.type == SchedEntity.TYPE.JOB ? this.sourceJob.getscheduleJobParms() : this.sourceSched.getParams();
        if (fullAttrs != null) {
            ArrayList<String> rawFollows = this.getJobDependency(fullAttrs);
            toRet = this.convertToCtmInConditions(rawFollows);
        }
        if (this.inConds != null) {
            this.inConds.addAll(toRet);
        } else {
            this.inConds = toRet;
        }
    }

    List<Properties> getCleanUpConditions(List<Properties> inconds) {
        List<Properties> toRet = new ArrayList<Properties>();
        if (inconds != null && this.isCleanUpChecked()) {
            CleanUpConditionHandler cleanUpConditionHandler = new CleanUpConditionHandler();
            toRet = cleanUpConditionHandler.getCleanUpOutConds(inconds);
        }
        return toRet;
    }

    boolean isCleanUpChecked() {
        return this.rules.getBooleanRule("TWS rules", new String[]{"CLEANUP_CONDITIONS"});
    }

    public void addInCond(Properties inCond) {
        if (this.inConds == null) {
            this.inConds = new ArrayList();
        }
        this.inConds.add(inCond);
    }

    private ArrayList<String> getJobDependency(AttrHolderList fullAttrs) {
        ArrayList<String> rawFollows = new ArrayList<String>();
        for (IAttrHolder attrs : fullAttrs) {
            String tmp;
            if (!attrs.getAttr("PARAMETER").equalsIgnoreCase("FOLLOWS") || (tmp = attrs.getAttr("VALUE")).isEmpty()) continue;
            rawFollows.add(tmp);
        }
        return rawFollows;
    }

    private ArrayList<Properties> convertToCtmInConditions(ArrayList<String> rawFollows) {
        ArrayList<Properties> toRet = new ArrayList<Properties>();
        for (String follow : rawFollows) {
            String[] followArr;
            for (String flw : followArr = follow.split("\\s*,\\s*")) {
                NameBuilder nameBuilder = new NameBuilder(this, this.sourceDefinition, flw);
                InConditionBuilder inConditionBuilder = new InConditionBuilder(this, this.sourceDefinition, nameBuilder);
                String inCondonditionName = inConditionBuilder.buildInConditionName();
                String inCondonditionODAT = inConditionBuilder.getInConditionODAT();
                Properties toAdd = new Properties();
                toAdd.put("NAME", inCondonditionName);
                toAdd.put("ODATE", inCondonditionODAT);
                toAdd.put("AND_OR", "AND");
                toRet.add(toAdd);
            }
        }
        return toRet.size() > 0 ? toRet : null;
    }

    public String getJobName() {
        return this.attributes.get("JOBNAME");
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    public List<Properties> getOnStmt() {
        ArrayList<Properties> condSuccStmts = this.convertRcCondSucc();
        if (condSuccStmts != null) {
            if (this.onStmts == null) {
                this.onStmts = condSuccStmts;
            } else {
                this.onStmts.addAll(condSuccStmts);
            }
        }
        return this.onStmts;
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        return null;
    }

    private ArrayList<Properties> convertRcCondSucc() {
        String rawCondSucc;
        ArrayList<Properties> toRet = null;
        if (this.type == SchedEntity.TYPE.JOB && !(rawCondSucc = this.sourceJob.getJobAttributes().getAttr("rccondsucc")).isEmpty()) {
            String operatorRegex;
            String mangledCondSucc = this.replaceParenthesesWithSpace(rawCondSucc);
            if (!mangledCondSucc.matches("(NOT )?RC *" + (operatorRegex = "(<[=>]?|>=?|=|!=) *") + "-?\\d+( +(AND|OR) (NOT )?+RC *" + operatorRegex + "-?\\d+)*")) {
                Reporter.addMessage(this.messages, (String)"WRN0017", (String)this.generateUniqueID(), (String[])new String[]{"rccondsucc", "TWS", rawCondSucc, "RC {=|<>|!=|<|>|>=|<=} <number>[<AND|OR> [NOT] RC {=|<>|!=|<|>|>=|<=} <number>...]"});
            } else if (mangledCondSucc.contains("AND") || mangledCondSucc.contains("NOT")) {
                this.addMessage("WRN0005", this.getOriginalJobName(), this.getJobName(), "AND/NOT operators in RCCONDSUCC=" + rawCondSucc);
            } else {
                Pattern pattern = Pattern.compile("( *OR *)?RC *" + operatorRegex + "(-?\\d+)(.*)");
                Matcher matcher = pattern.matcher(mangledCondSucc);
                while (matcher.matches()) {
                    String operator = matcher.group(2);
                    Integer value = Integer.valueOf(matcher.group(3));
                    matcher = pattern.matcher(matcher.group(4));
                    if (operator.equals(">=")) {
                        var9_9 = value;
                        value = value - 1;
                    } else if (operator.equals("<=")) {
                        var9_9 = value;
                        value = value + 1;
                    }
                    switch (operator) {
                        case "=": {
                            operator = "EQ";
                            break;
                        }
                        case "<>": 
                        case "!=": {
                            operator = "NE";
                            break;
                        }
                        case ">": 
                        case ">=": {
                            operator = "GT";
                            break;
                        }
                        case "<": 
                        case "<=": {
                            operator = "LT";
                        }
                    }
                    Properties tmpStatement = new Properties();
                    tmpStatement.setProperty("CODE", String.format("COMPSTAT %s %d", operator, value));
                    tmpStatement.setProperty("STMT", "*");
                    tmpStatement.setProperty("ACTION", "OK");
                    if (toRet == null) {
                        toRet = new ArrayList<Properties>();
                    }
                    toRet.add(tmpStatement);
                }
            }
        }
        return toRet;
    }

    private String replaceParenthesesWithSpace(String rawCondSucc) {
        return rawCondSucc.replaceAll("[\"()]", " ").replaceAll("\\s+", " ").trim().toUpperCase();
    }

    public List<String> getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public String getOriginalJobName() {
        if (this.type == SchedEntity.TYPE.JOB) {
            return this.sourceJob.getName();
        }
        return this.sourceSched.getName();
    }

    protected String getOriginalJobName(boolean fullName) {
        if (fullName) {
            return this.getOriginalJobName();
        }
        String name = this.getOriginalJobName();
        name = name.substring(name.indexOf("#") + 1);
        return name;
    }

    void generateOutConditions() {
        OutConditionsManager outConditionsManager = new OutConditionsManager(this, this.sourceDefinition);
        ArrayList<Properties> outcondlist = outConditionsManager.generateOutConditions();
        this.outConds.addAll(outcondlist);
        List<Properties> incondList = this.getInConds();
        List<Properties> cleanUpList = this.getCleanUpConditions(incondList);
        this.outConds.addAll(cleanUpList);
    }

    public List<Properties> getOutConds() {
        return this.outConds;
    }

    public void addOutCond(Properties outCond) {
        if (this.outConds == null) {
            this.outConds = new ArrayList();
        }
        this.outConds.add(outCond);
    }

    public String getParentName() {
        return this.parent == null ? "" : this.parent.getJobName();
    }

    public String getOriginalParentName(boolean fullName) {
        return this.parent == null ? "" : this.parent.getOriginalJobName(fullName);
    }

    private Properties limitOption() {
        if (this.type == SchedEntity.TYPE.SMART_TABLE) {
            return null;
        }
        if (this.parent == null) {
            return null;
        }
        String limit = this.parent.sourceSched.getAttributes().getAttr("limit");
        if (limit == null || limit.isEmpty()) {
            return null;
        }
        Properties qr = new Properties();
        qr.setProperty("NAME", this.parent.sourceSched.getAttributes().getAttr("schedule"));
        qr.setProperty("QUANT", "1");
        return qr;
    }

    public List<Properties> getQuantResources() {
        Properties qr;
        AttrHolderList attrs = this.type != SchedEntity.TYPE.JOB ? null : this.sourceJob.getscheduleJobParms();
        ArrayList<Properties> retList = new ArrayList<Properties>();
        if (attrs != null) {
            ArrayList<String> resourceList = new ArrayList<String>();
            for (IAttrHolder ah : attrs) {
                String[] splittedNEEDS;
                String param = ah.getAttr("PARAMETER");
                if (!param.equalsIgnoreCase("NEEDS")) continue;
                String needs = ah.getAttr("VALUE");
                for (String need : splittedNEEDS = needs.split("\\s*,\\s*")) {
                    this.convertNeedToQuantitveResource(need, ah, retList, resourceList);
                }
            }
        }
        if ((qr = this.limitOption()) != null) {
            retList.add(qr);
        }
        return retList;
    }

    private void convertNeedToQuantitveResource(String need, IAttrHolder ah, List<Properties> retList, List<String> resourceList) {
        String[] resourceDetails = need.trim().split("\\s+", 2);
        String resourceQuantity = this.getResourceQuantity(resourceDetails);
        String resourceName = this.getResourceName(resourceDetails);
        if (!GlobalFunctions.isNumber((String)resourceQuantity)) {
            Reporter.addMessage(this.messages, (String)"WRN6008", (String)this.generateUniqueID(), (String[])new String[]{resourceQuantity, "NEEDS", ah.getAttr("ID")});
        } else if (!resourceList.contains(resourceName)) {
            resourceList.add(resourceName);
            Properties qr = new Properties();
            qr.setProperty("NAME", resourceName);
            qr.setProperty("QUANT", resourceQuantity);
            retList.add(qr);
            this.addQrActionToReporter(resourceQuantity, resourceName);
        }
    }

    private void addQrActionToReporter(String resourceQuantity, String resourceName) {
        HashMap<String, String> action = new HashMap<String, String>();
        action.put("ACTENTTYPE", "QR");
        action.put("JOBID", this.generateUniqueID());
        action.put("ACTENTNAME", resourceName);
        action.put("ACTENTQTY", resourceQuantity);
        action.put("ACTSTATUS", "0");
        Reporter.addAction(action);
    }

    private String getResourceName(String[] resourceDetails) {
        String resourceName = resourceDetails[0];
        if (resourceDetails.length >= 2) {
            resourceName = resourceDetails[1];
        }
        return resourceName;
    }

    private String getResourceQuantity(String[] resourceDetails) {
        String resourceQuantity = "1";
        if (resourceDetails.length >= 2) {
            resourceQuantity = resourceDetails[0];
        }
        return resourceQuantity;
    }

    public List<Properties> getShouts() {
        if (this.shouts == null) {
            this.shouts = new ArrayList();
        }
        return this.shouts;
    }

    public String getTableName() {
        return this.type == SchedEntity.TYPE.SMART_TABLE ? this.attributes.get("JOBNAME") : (this.isOrphanJob() ? this.getJobName() : this.parent.getTableName());
    }

    public String getTablePathForSons() {
        return null;
    }

    public List<Properties> getTags() {
        ArrayList<Properties> toRet;
        if (this.tags != null || this.parent == null) {
            toRet = this.generateUniquePropertyListByKey("NAME", this.tags, 20);
        } else {
            toRet = new ArrayList();
            for (Properties tag : this.parent.getTags()) {
                if (tag.getProperty("NAME").startsWith("!")) continue;
                toRet.add(tag);
            }
        }
        return toRet;
    }

    public boolean hasMessages() {
        return this.messages.size() > 0;
    }

    public boolean hasWarnings() {
        if (this.messages.isEmpty()) {
            return false;
        }
        HashMap messageIds = MessageIdTable.instance().getMessageIds();
        for (String id : messageIds.keySet()) {
            if (!((MessageId)messageIds.get(id)).getMessageType(id).equals("W")) continue;
            for (String currMessage : this.messages) {
                if (!currMessage.startsWith(id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCyclic() {
        return this.attributes.containsKey("CYCLIC") && this.attributes.get("CYCLIC").equalsIgnoreCase("1");
    }

    public boolean isDSJob() {
        return this.dsJob;
    }

    public void setDsJob(boolean dsJob) {
        this.dsJob = dsJob;
        if (!dsJob) {
            this.handleMfFolderName();
        }
    }

    private void handleMfFolderName() {
        TwsJob mfParent = this.getParent();
        if (mfParent == null) {
            return;
        }
        String mfParentFolderName = mfParent.getAttr("FOLDER_MF_NAME");
        if (mfParentFolderName == null) {
            String parentFolderName = mfParent.getJobName();
            String mfShortFolderName = this.uniqueValueGenerator.getUniqueValue("TABLE_NAME", parentFolderName, 8);
            mfParent.addAttribute("FOLDER_MF_NAME", mfShortFolderName);
            mfParent.addMessage("INF6108", mfParent.getJobName(), mfShortFolderName);
        }
    }

    public boolean isValid() {
        return true;
    }

    public String originalProductID() {
        return this.generateUniqueID();
    }

    public SchedEntity.TYPE type() {
        return this.type;
    }

    ArrayList<String> getParamValues(String param) {
        AttrHolderList params;
        ArrayList<String> toRet = null;
        AttrHolderList attrHolderList = params = this.type == SchedEntity.TYPE.SMART_TABLE ? this.sourceSched.getParams() : this.sourceJob.getscheduleJobParms();
        if (params != null) {
            for (IAttrHolder attrs : params) {
                if (!attrs.getAttr("PARAMETER").equalsIgnoreCase(param)) continue;
                if (toRet == null) {
                    toRet = new ArrayList<String>();
                }
                String paramVal = attrs.getAttr("VALUE");
                List<String> splitedValues = this.splitByCommaQuotesSensitive(paramVal);
                toRet.addAll(splitedValues);
            }
        }
        return toRet;
    }

    private List<String> splitByCommaQuotesSensitive(String str) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        boolean inQuotes = false;
        int current = 0;
        for (current = 0; current < str.length(); ++current) {
            String arg;
            boolean atLastChar;
            boolean bl = atLastChar = current == str.length() - 1;
            if (current == 0 && str.charAt(current) == '\"') {
                inQuotes = !inQuotes;
            } else if (str.charAt(current) == '\"' && str.charAt(current - 1) != '\\') {
                boolean bl2 = inQuotes = !inQuotes;
            }
            if ((str.charAt(current) != ',' || inQuotes) && !atLastChar) continue;
            if (atLastChar && str.charAt(current) != ',') {
                ++current;
            }
            if (!(arg = str.substring(start, current).trim()).isEmpty() && !arg.equals(",")) {
                result.add(arg);
            }
            start = current + 1;
        }
        return result;
    }

    public String generateUniqueID() {
        Object name = this.attributes.get("JOBNAME");
        if (this.type == SchedEntity.TYPE.JOB) {
            name = (String)name + "@" + this.getParentName();
        }
        return name;
    }

    public String applyFieldConversion(String field) {
        String convertedString = this.sourceDefinition.getRules().getFieldEditor().generateCTMField(field, fieldName -> this.getValueForFieldConversion(fieldName));
        String validatedValue = FieldValidation.instance().validateAndReturnFixedValue(field, convertedString, true, null, null, this.messages);
        if (validatedValue.compareTo(convertedString) != 0) {
            String msgID = convertedString.length() != validatedValue.length() ? "INF0013" : "INF0014";
            Reporter.addMessage(this.messages, (String)msgID, (String)this.generateUniqueID(), (String[])new String[]{this.getAttr("JOBNAME"), convertedString, validatedValue});
            convertedString = validatedValue;
        }
        return convertedString;
    }

    private String getValueForFieldConversion(String field) {
        String toRet = "";
        toRet = field.equalsIgnoreCase("JOBNAME") || field.equalsIgnoreCase("FOLDER_NAME") ? this.getOriginalJobName().split("#")[1] : (field.equalsIgnoreCase("CPU") ? this.getOriginalJobName().split("#")[0] : (field.equalsIgnoreCase("STREAMLOGON") ? (this.type == SchedEntity.TYPE.JOB ? this.getSourceJobAttribute("streamlogon") : "") : (field.equalsIgnoreCase("DESCRIPTION") ? (this.type == SchedEntity.TYPE.JOB ? this.getSourceJobAttribute("description") : this.sourceSched.getAttributes().getAttr("description")) : (field.equalsIgnoreCase("SCHEDULE_NAME") ? (this.parent == null ? this.getOriginalJobName(false) : this.parent.getOriginalJobName(false)) : (field.equalsIgnoreCase("SCHEDULE_CPU") ? (this.parent == null ? this.getOriginalJobName().split("#")[0] : this.parent.getOriginalJobName().split("#")[0]) : "")))));
        if (toRet.contains("*")) {
            toRet = toRet.replaceFirst("\\*.*", " ").trim();
        }
        toRet = this.replaceVars(toRet);
        while (toRet.matches("^\".*\"$")) {
            toRet = toRet.replaceAll("^\"", "").replaceAll("\"$", "");
        }
        return toRet;
    }

    private String replaceVars(String string) {
        String varExpr = ".*(\\^(.+?)\\^).*";
        Pattern pattern = Pattern.compile(".*(\\^(.+?)\\^).*");
        Matcher matcher = pattern.matcher(string);
        while (matcher.matches()) {
            String cpuName = this.GetOrigNodeid();
            ArrayList<String> tables = this.getListOfTables();
            String value = VarTable.instance().getVariable(cpuName, tables, matcher.group(2));
            if (value == null) {
                value = matcher.group(2);
            } else if (value.matches("^\".*\"$")) {
                value = value.replaceAll("^\"", "").replaceAll("\"$", "");
            }
            string = string.replace(matcher.group(1), value);
            matcher = pattern.matcher(string);
        }
        return string;
    }

    String createTableNameForAssistingJob() {
        Object toRet = this.type() == SchedEntity.TYPE.JOB ? this.getTableName() : (this.sourceDefinition.isStandAloneGrouped() ? "StandAloneJobs" : this.getTableName() + "_TABLE");
        return toRet;
    }

    protected String getTimeZone(boolean suppressWarning) {
        Pattern tzPattern = Pattern.compile(".*(timezone|tz)[\t ]+([^ \t]+).*", 2);
        String timezone = "";
        boolean inheritedTz = false;
        HashSet<String> allTz = new HashSet<String>();
        if (this.type() == SchedEntity.TYPE.JOB) {
            String tempStr = this.sourceJob.getscheduleJob().getAttr("until");
            Matcher tzMatcher = tzPattern.matcher(tempStr);
            if (tzMatcher.matches()) {
                timezone = tzMatcher.group(2);
                allTz.add(timezone);
            }
            if (this.sourceJob.getscheduleJobParms() != null) {
                for (IAttrHolder currAttrs : this.sourceJob.getscheduleJobParms()) {
                    String parm = currAttrs.getAttr("PARAMETER");
                    if (!parm.equalsIgnoreCase("AT") && !parm.equalsIgnoreCase("SCHEDTIME") && !parm.equalsIgnoreCase("DEADLINE") || !(tzMatcher = tzPattern.matcher(currAttrs.getAttr("VALUE"))).matches()) continue;
                    timezone = tzMatcher.group(2);
                    allTz.add(timezone);
                }
            }
            if (allTz.isEmpty() && !this.isOrphanJob() && (timezone = this.parent.getTimeZone(true)) != null && !timezone.isEmpty()) {
                inheritedTz = true;
            }
        } else {
            String tmpStr;
            Matcher tzMatcher;
            timezone = this.sourceSched.getAttributes().getAttr("timezone");
            if (!timezone.isEmpty()) {
                allTz.add(timezone);
            }
            if ((tzMatcher = tzPattern.matcher(tmpStr = this.sourceSched.getAttributes().getAttr("at"))).matches()) {
                timezone = tzMatcher.group(2);
                allTz.add(timezone);
            }
            if ((tzMatcher = tzPattern.matcher(tmpStr = this.sourceSched.getAttributes().getAttr("until"))).matches()) {
                timezone = tzMatcher.group(2);
                allTz.add(timezone);
            }
            if ((tzMatcher = tzPattern.matcher(tmpStr = this.sourceSched.getAttributes().getAttr("schedtime"))).matches()) {
                timezone = tzMatcher.group(2);
                allTz.add(timezone);
            }
            if ((tzMatcher = tzPattern.matcher(tmpStr = this.sourceSched.getAttributes().getAttr("deadline"))).matches()) {
                timezone = tzMatcher.group(2);
                allTz.add(timezone);
            }
            if (this.sourceSched.getParams() != null) {
                for (IAttrHolder currAttrs : this.sourceSched.getParams()) {
                    String parm = currAttrs.getAttr("PARAMETER");
                    if (!parm.equalsIgnoreCase("ON") && !parm.equalsIgnoreCase("EXPECT") || !(tzMatcher = tzPattern.matcher(currAttrs.getAttr("VALUE"))).matches()) continue;
                    timezone = tzMatcher.group(2);
                    allTz.add(timezone);
                }
            }
        }
        if (timezone == null || timezone.isEmpty()) {
            timezone = this.sourceDefinition.getCpus().getTimeZone(this.GetOrigNodeid());
        }
        String toRet = null;
        TwsTimeZone timeZone = this.sourceDefinition.getTimeZone();
        if (timezone != null && !timezone.isEmpty()) {
            toRet = inheritedTz ? timezone : timeZone.convertTimezone(timezone);
        }
        if (!(toRet != null && !toRet.isEmpty() && timeZone.isCtmTz(toRet) || suppressWarning || timezone == null || timezone.isEmpty() || allTz.size() > 1)) {
            toRet = timezone;
            HashMap<String, String> action = new HashMap<String, String>();
            action.put("ACTENTTYPE", "TZ");
            action.put("JOBID", this.generateUniqueID());
            action.put("ACTENTNAME", timezone);
            action.put("ACTENTQTY", "0");
            action.put("ACTSTATUS", "0");
            Reporter.addAction(action);
        }
        if (allTz.size() > 1 && !suppressWarning) {
            Reporter.addMessage(this.messages, (String)"WRN6021", (String)this.generateUniqueID(), (String[])new String[]{allTz.toString()});
            toRet = "";
        }
        if (this.sourceDefinition.getDefaultTz().equalsIgnoreCase(toRet)) {
            toRet = "";
        }
        if (!(timezone == null || timezone.isEmpty() || toRet == null || toRet.isEmpty() || inheritedTz || toRet.equals(timezone) || suppressWarning)) {
            Reporter.addMessage(this.messages, (String)"INF6104", (String)this.generateUniqueID(), (String[])new String[]{timezone, toRet});
        }
        return toRet;
    }

    private ArrayList<Properties> generateUniquePropertyListByKey(String key, ArrayList<Properties> inList, int maxLength) {
        if (inList == null || inList.isEmpty() || key == null || !inList.get(0).keySet().contains(key)) {
            return inList;
        }
        HashSet<String> usedKeys = new HashSet<String>();
        HashSet<String> nonUnique = new HashSet<String>();
        for (Properties props : inList) {
            if (usedKeys.contains(props.getProperty(key))) {
                nonUnique.add(props.getProperty(key));
                continue;
            }
            usedKeys.add(props.getProperty(key));
        }
        if (nonUnique.isEmpty()) {
            return inList;
        }
        for (Properties currProps : inList) {
            if (!nonUnique.contains(currProps.getProperty(key))) continue;
            Integer j = 0;
            while (usedKeys.contains(currProps.getProperty(key))) {
                Object replacement = currProps.getProperty(key);
                int overFlow = ((String)replacement + "_" + j).length() - maxLength;
                if (overFlow > 0) {
                    replacement = ((String)replacement).replaceAll(".{" + overFlow + "}$", "");
                }
                replacement = j == 0 || overFlow > 0 ? (String)replacement + "_" + j : ((String)replacement).replaceAll("[0-9]+$", j.toString());
                currProps.setProperty(key, (String)replacement);
                Integer n = j;
                j = j + 1;
            }
            usedKeys.add(currProps.getProperty(key));
        }
        return inList;
    }

    private String generateUniqueTagName(String name, Integer index) {
        Object retName = name;
        int overFlow = ((String)retName + "_" + index.toString()).length() - 20;
        if (overFlow > 0) {
            retName = ((String)retName).replaceAll(".{" + overFlow + "}$", "");
        }
        retName = index == 0 || overFlow > 0 ? (String)retName + "_" + index : ((String)retName).replaceAll("[0-9]+$", index.toString());
        return retName;
    }

    public String GetOrigNodeid() {
        return this.getOriginalJobName().split("#", 2)[0];
    }

    public String getSourceJobAttribute(String attributeName) {
        String attrValue = null;
        if (this.sourceJob.getscheduleJobParms() != null) {
            for (IAttrHolder attrFromSched : this.sourceJob.getscheduleJobParms()) {
                if (!attrFromSched.getAttr("PARAMETER").equalsIgnoreCase(attributeName)) continue;
                attrValue = attrFromSched.getAttr("VALUE");
            }
        }
        if (attrValue == null) {
            attrValue = this.sourceJob.getJobAttributes().getAttr(attributeName).trim();
        }
        return attrValue;
    }

    public String getOriginalJobData() {
        StringBuilder jobData = new StringBuilder();
        if (this.sourceJob != null) {
            this.attrHolderToString(jobData, this.sourceJob.getJobAttributes());
        } else if (this.sourceSched != null) {
            this.attrHolderToString(jobData, this.sourceSched.getAttributes());
        }
        return jobData.toString();
    }

    private void attrHolderToString(StringBuilder jobData, IAttrHolder jobAttributes) {
        if (jobAttributes != null) {
            String[] header;
            for (String field : header = jobAttributes.getCsvHeader().split(",")) {
                jobData.append(String.format("%-20s\t: %s%s", field, jobAttributes.getAttr(field), "\r\n"));
            }
        }
    }

    public TwsJob getParent() {
        return this.parent;
    }

    public SchedEntity.TYPE getType() {
        return this.type;
    }

    public String getFullQualifiedJobName() {
        SchedEntity.TYPE jobtype = this.type();
        String node = "";
        String sched = "";
        if (jobtype == SchedEntity.TYPE.SMART_TABLE) {
            node = this.GetOrigNodeid();
        } else if (!this.isOrphanJob()) {
            node = this.getParent().GetOrigNodeid();
        }
        sched = jobtype == SchedEntity.TYPE.SMART_TABLE ? this.getOriginalJobName(false) : this.getOriginalParentName(false);
        String job = jobtype == SchedEntity.TYPE.SMART_TABLE ? null : this.getOriginalJobName(false);
        return String.format("%s#%s.%s", node, sched, job == null ? "" : job);
    }

    public String getBaseJobName() {
        IAttrHolder attributes = this.type == SchedEntity.TYPE.JOB ? this.sourceJob.getscheduleJob() : this.sourceSched.getAttributes();
        String fullId = attributes.getAttr("ID");
        JobIDParser jobIdParser = new JobIDParser(fullId);
        return jobIdParser.getJobId();
    }

    public TwsScheduleAttributes getSourceSched() {
        if (this.type == SchedEntity.TYPE.JOB) {
            TwsJob parent = this.getParent();
            return parent.getSourceSched();
        }
        return this.sourceSched;
    }

    public void addAutoEdits(String key, String value) {
        if (value != null) {
            this.autoedits.put(key, value);
        }
    }

    public void removeAutoEdits(String key) {
        this.autoedits.remove(key);
    }

    public void addAttribute(String key, String value) {
        if (value != null) {
            this.attributes.put(key, value);
        }
    }

    public boolean isOpensToFileWatcher() {
        return this.rules.getBooleanRule("TWS rules", new String[]{"OPENS_TO_FILE_WATCHER"});
    }
}

