/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.tws.TwsJob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TwsCyclicConverter {
    public void convertCyclicJob(TwsJob twsJob) {
        Object interval = twsJob.getSourceJob().getscheduleJob().getAttr("every");
        HashMap<String, String> jobAttributes = twsJob.getAttributes();
        ArrayList<String> messages = twsJob.getMessages();
        if (interval == null || ((String)interval).trim().isEmpty()) {
            jobAttributes.put("CYCLIC", "0");
            jobAttributes.put("MAXRERUN", "0");
            return;
        }
        switch (((String)interval).trim().length()) {
            case 1: {
                interval = "000" + (String)interval;
                break;
            }
            case 2: {
                interval = "00" + (String)interval;
                break;
            }
            case 3: {
                interval = "0" + (String)interval;
                break;
            }
            case 4: {
                break;
            }
            default: {
                jobAttributes.put("CYCLIC", "0");
                jobAttributes.put("MAXRERUN", "0");
                Reporter.addMessage(messages, (String)"WRN0017", (String)twsJob.generateUniqueID(), (String[])new String[]{"INTERVAL", "TWS", interval, "up to four digits (hhmm)"});
                return;
            }
        }
        String hours = ((String)interval).substring(0, 2);
        String minutes = ((String)interval).substring(2, 4);
        if (!GlobalFunctions.isNumber((String)hours) || !GlobalFunctions.isNumber((String)minutes)) {
            Reporter.addMessage(messages, (String)"WRN6008", (String)twsJob.generateUniqueID(), (String[])new String[]{interval, "INTERVAL", twsJob.getOriginalJobName()});
            return;
        }
        int timeInMinutes = Integer.parseInt(hours) * 60 + Integer.parseInt(minutes);
        jobAttributes.put("CYCLIC", "1");
        jobAttributes.put("MAXRERUN", "0");
        jobAttributes.put("CYCLIC_TYPE", "Interval");
        jobAttributes.put("INTERVAL", timeInMinutes + "M");
        jobAttributes.put("IND_CYCLIC", "START");
    }

    public void convertCyclicFolder(TwsJob twsFolder, ArrayList<String> runCycles) {
        ArrayList<String> messages = twsFolder.getMessages();
        String everyExpr = ".*EVERY[ \\t]+([0-9]{4}).*";
        Pattern everyExprPattern = Pattern.compile(".*EVERY[ \\t]+([0-9]{4}).*");
        String everyEndTimeExpr = ".*EVERYENDTIME[ \\t]+([0-9]{4}).*";
        Pattern everyEndTimePattern = Pattern.compile(".*EVERYENDTIME[ \\t]+([0-9]{4}).*");
        String atTimeExpr = ".*AT[ \t]+([0-9]{4}).*";
        Pattern atPattern = Pattern.compile(".*AT[ \t]+([0-9]{4}).*");
        ArrayList<String> cycleAtTimes = null;
        for (String runCycle : runCycles) {
            Matcher matcherEvery = everyExprPattern.matcher(runCycle);
            Matcher matcherEveryEndTime = everyEndTimePattern.matcher(runCycle);
            Matcher matcherAtTime = atPattern.matcher(runCycle);
            if (!matcherEvery.matches() || !matcherEveryEndTime.matches() || !matcherAtTime.matches()) continue;
            if (runCycles.size() > 1) {
                for (String multiAtDefinition : runCycles) {
                    Matcher matcher = atPattern.matcher(multiAtDefinition);
                    if (!matcher.matches()) continue;
                    if (cycleAtTimes == null) {
                        cycleAtTimes = new ArrayList<String>();
                    }
                    cycleAtTimes.add(matcher.group(1));
                }
                if (cycleAtTimes != null && cycleAtTimes.size() > 1) {
                    Reporter.addMessage(messages, (String)"WRN6040", (String)twsFolder.generateUniqueID(), (String[])new String[]{twsFolder.getJobName(), cycleAtTimes.toString()});
                }
            }
            this.resolveTime(matcherAtTime.group(1), "AT", twsFolder);
            this.resolveTime(matcherEveryEndTime.group(1), "EVERYENDTIME", twsFolder);
            this.resolveTime(matcherEvery.group(1), "EVERY", twsFolder);
            return;
        }
    }

    private void resolveTime(String time, String typeOfTime, TwsJob twsFolder) {
        HashMap<String, String> attributes = twsFolder.getAttributes();
        ArrayList<String> messages = twsFolder.getMessages();
        if (time.length() == 4 && GlobalFunctions.isNumber((String)time)) {
            switch (typeOfTime) {
                case "EVERYENDTIME": {
                    attributes.put("TIMETO", time);
                    break;
                }
                case "AT": {
                    attributes.put("TIMEFROM", time);
                    break;
                }
                case "EVERY": {
                    String hours = time.substring(0, 2);
                    String minutes = time.substring(2, 4);
                    Integer timeInMinutes = Integer.parseInt(hours) * 60 + Integer.parseInt(minutes);
                    attributes.put("CYCLIC", "1");
                    attributes.put("MAXRERUN", "0");
                    attributes.put("CYCLIC_TYPE", "Interval");
                    attributes.put("INTERVAL", timeInMinutes + "M");
                }
            }
        } else if (!time.isEmpty()) {
            Reporter.addMessage(messages, (String)"WRN0017", (String)twsFolder.generateUniqueID(), (String[])new String[]{typeOfTime, "TWS", time, "hhmm"});
        }
    }
}

