/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.ExceptionHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;

public class TWSAssessmentCalendarTXTReader {
    private HashMap<String, String> m_CalendarID_CalendarDescription = new HashMap();

    public TWSAssessmentCalendarTXTReader(String textCalendarFileName) {
        this.readCalendars(textCalendarFileName);
    }

    private void readCalendars(String textCalendarFileName) {
        try {
            FileInputStream sourceStream = new FileInputStream(textCalendarFileName);
            Scanner sourceScanner = new Scanner(sourceStream);
            String name = "";
            Object desc = "";
            while (sourceScanner.hasNext()) {
                String line = sourceScanner.nextLine().trim();
                if (line.matches("^[a-zA-Z][a-zA-Z0-9_-]{0,7}")) {
                    if (!name.isEmpty()) {
                        this.m_CalendarID_CalendarDescription.put(name, (String)desc);
                    }
                    name = line;
                    continue;
                }
                if (!name.isEmpty() && line.matches("^[\"][^\"]+[\"]$")) {
                    desc = line + "\n\n";
                    continue;
                }
                desc = (String)desc + line + "\n";
            }
            if (!name.isEmpty()) {
                this.m_CalendarID_CalendarDescription.put(name, (String)desc);
            }
            sourceStream.close();
            sourceScanner.close();
        }
        catch (IOException ioe) {
            ExceptionHandler.writeToExceptionFile((Exception)ioe);
        }
    }

    public ArrayList<String> getAllCalendarsNames() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String calendarID : this.m_CalendarID_CalendarDescription.keySet()) {
            resultList.add(calendarID);
        }
        return resultList;
    }

    public String getCalendarDescription(String calendarName) {
        if (null != this.m_CalendarID_CalendarDescription) {
            return this.m_CalendarID_CalendarDescription.get(calendarName);
        }
        return "";
    }
}

