/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.sap.SapR3CommonWrapper;
import com.bmc.ctmconvert.sap.SapR3CopyWrapper;
import com.bmc.ctmconvert.sap.SapR3CreateWrapper;
import com.bmc.ctmconvert.sap.Step;
import com.bmc.ctmconvert.tws.TWSSAPArgumentsParser;
import com.bmc.ctmconvert.tws.TwsJob;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class SapR3Convertor {
    public void convert(String command, TwsJob twsJob) {
        TWSSAPArgumentsParser parser = new TWSSAPArgumentsParser(command);
        Optional<List<String>> flagList = parser.getGeneralArgList("flag");
        if (flagList.isPresent() && flagList.get().contains("type=exec")) {
            this.convertToRunNew(command, twsJob);
        } else {
            this.convertToRunCopy(command, twsJob);
        }
        this.setCommonArguments(parser, twsJob);
    }

    private void setCommonArguments(TWSSAPArgumentsParser parser, TwsJob twsJob) {
        String empty = "";
        SapR3CommonWrapper commonWrapper = new SapR3CommonWrapper((SchedEntity)twsJob);
        Optional<String> job = parser.getGeneralArg("job");
        commonWrapper.setSapJobName(job.orElse(empty));
        Optional<String> user = parser.getGeneralArg("user");
        user.ifPresent(arg_0 -> ((SapR3CommonWrapper)commonWrapper).setSapAccount(arg_0));
    }

    private void convertToRunCopy(String command, TwsJob twsJob) {
        TWSSAPArgumentsParser parser = new TWSSAPArgumentsParser(command);
        SapR3CopyWrapper sapJob = SapR3CopyWrapper.convertToSapJob((SchedEntity)twsJob);
        Optional<String> specificJobId = parser.getGeneralArg("i");
        specificJobId.ifPresent(arg_0 -> ((SapR3CopyWrapper)sapJob).setSpecificJob(arg_0));
    }

    private void convertToRunNew(String command, TwsJob twsJob) {
        TWSSAPArgumentsParser parser = new TWSSAPArgumentsParser(command);
        SapR3CreateWrapper sapJob = SapR3CreateWrapper.convertToSapJob((SchedEntity)twsJob);
        Optional<String> jobClass = parser.getGeneralArg("c");
        jobClass.ifPresent(arg_0 -> ((SapR3CreateWrapper)sapJob).setClass(arg_0));
        Optional<String> jobrecipient = parser.getGeneralArg("recipient");
        jobrecipient.ifPresent(arg_0 -> ((SapR3CreateWrapper)sapJob).setRecipient(arg_0));
        this.setRecipinetType(parser, sapJob);
        List<Integer> stepsNumberd = parser.getStepsNumber();
        for (Integer stepNumber : stepsNumberd) {
            Step step = this.createStep(parser, stepNumber);
            sapJob.addStep(step);
        }
        Optional<List<String>> flagList = parser.getGeneralArgList("flag");
        if (flagList.isPresent()) {
            Iterator<String> iterator = flagList.get().iterator();
            while (iterator.hasNext()) {
                String flag;
                switch (flag = iterator.next()) {
                    case "pc_launch_on": {
                        sapJob.setDetectOption();
                        break;
                    }
                    case "DISABLE_JOBLOG": {
                        sapJob.setDisableJoblog();
                        break;
                    }
                    case "ENABLE_SPOOLLIST": {
                        sapJob.setSpool();
                        break;
                    }
                }
            }
        }
    }

    private void setRecipinetType(TWSSAPArgumentsParser parser, SapR3CreateWrapper sapJob) {
        Optional<String> jobrecipienttype = parser.getGeneralArg("rectype");
        jobrecipienttype.filter("U"::equals).ifPresent(v -> sapJob.setInternetAddressRecipientType());
    }

    private Step createStep(TWSSAPArgumentsParser parser, Integer stepNumber) {
        Step step = new Step(stepNumber.intValue());
        Optional<String> user = parser.getGeneralArg("user");
        user.ifPresent(arg_0 -> ((Step)step).setOwner(arg_0));
        Optional<String> program = parser.getStepArgs(stepNumber, "program");
        program.ifPresent(arg_0 -> ((Step)step).setProgram(arg_0));
        Optional<String> variant = parser.getStepArgs(stepNumber, "variant");
        variant.ifPresent(arg_0 -> ((Step)step).setVariant(arg_0));
        Optional<String> prnew = parser.getStepArgs(stepNumber, "prnew");
        if (prnew.isPresent()) {
            step.setNewListId("X");
        }
        Optional<String> prDest = parser.getStepArgs(stepNumber, "pr_dest");
        prDest.ifPresent(arg_0 -> ((Step)step).setPrintDest(arg_0));
        Optional<String> primm = parser.getStepArgs(stepNumber, "primm");
        if (primm.isPresent()) {
            step.setPrintImmed("X");
        }
        Optional<String> prauth = parser.getStepArgs(stepNumber, "pr_auth");
        prauth.ifPresent(arg_0 -> ((Step)step).setPrintAuth(arg_0));
        return step;
    }
}

