/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.rbc.RbcNamer;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.tws.TwsCalendars;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RuncycleConvertor {
    private final RulesDataSet rules;
    private final HashSet<String> keyWords = new HashSet();
    private final HashSet<String> ignoredKeyWords = new HashSet();
    private final HashMap<String, String> dayNameMap = new HashMap();
    private static final String WEEK_DAY_EXPR = "(mo|tu|we|th|fr|sa|su)";
    private static final String NUMBERED_WEEK_DAY_EXPR = "(([-+]?[0-9])?(mo|tu|we|th|fr|sa|su))";
    private static final String MMDDYYYY_EXPR = "([0-9][0-9]/[0-9][0-9]/[0-9][0-9][0-9][0-9])";
    private static final String MMDDYY_EXPR = "([0-9][0-9]/[0-9][0-9]/[0-9][0-9])";
    private static final String WEEK_DAY_LIST_EXPR = String.format("^%s,?(, *%s)*$", "(mo|tu|we|th|fr|sa|su)", "(mo|tu|we|th|fr|sa|su)");
    private static final String NUMBERED_WEEK_DAY_LIST_EXPR = String.format("^%s,?(, *%s)*$", "(([-+]?[0-9])?(mo|tu|we|th|fr|sa|su))", "(([-+]?[0-9])?(mo|tu|we|th|fr|sa|su))");
    private static final String MMDDYYYY_LIST_EXPR = String.format("^%s(, *%s)*$", "([0-9][0-9]/[0-9][0-9]/[0-9][0-9][0-9][0-9])", "([0-9][0-9]/[0-9][0-9]/[0-9][0-9][0-9][0-9])");
    private static final String MMDDYY_LIST_EXPR = String.format("^%s(, *%s)*$", "([0-9][0-9]/[0-9][0-9]/[0-9][0-9])", "([0-9][0-9]/[0-9][0-9]/[0-9][0-9])");
    private Integer anonymousCount = 0;
    private TwsCalendars calendarsConvertor;

    public RuncycleConvertor(RulesDataSet rules) {
        this.ignoredKeyWords.add("DESCRIPTION");
        this.ignoredKeyWords.add("AT");
        this.ignoredKeyWords.add("UNTIL");
        this.ignoredKeyWords.add("ONUNTIL");
        this.ignoredKeyWords.add("SCHEDTIME");
        this.ignoredKeyWords.add("DEADLINE");
        this.keyWords.add("RUNCYCLE");
        this.keyWords.add("VALIDFROM");
        this.keyWords.add("VALIDTO");
        this.keyWords.add("VARTABLE");
        this.keyWords.addAll(this.ignoredKeyWords);
        this.dayNameMap.put("su", "SUN");
        this.dayNameMap.put("mo", "MON");
        this.dayNameMap.put("tu", "TUE");
        this.dayNameMap.put("we", "WED");
        this.dayNameMap.put("th", "THU");
        this.dayNameMap.put("fr", "FRI");
        this.dayNameMap.put("sa", "SAT");
        File sourceCalendars = new File(Params.instance().getDatasourcePath() + "calendars.txt");
        if (sourceCalendars.exists()) {
            this.calendarsConvertor = new TwsCalendars(sourceCalendars.toPath(), Params.instance().getDatacenterName());
            try {
                this.calendarsConvertor.convert();
                this.calendarsConvertor.writeCalendars();
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
        this.rules = rules;
    }

    public void convertExceptRuncycle(String sourceCycle, Properties targetRbc, List<String> conversionMessages, String schedule) {
        this.convertOnRuncycle(sourceCycle, targetRbc, conversionMessages, schedule);
        targetRbc.setProperty("NAME", "!" + targetRbc.getProperty("NAME"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void convertOnRuncycle(String sourceCycle, Properties targetRbc, List<String> conversionMessages, String schedule) {
        if (conversionMessages == null) {
            conversionMessages = new ArrayList<String>();
        }
        cycleWords = this.stringToWords(sourceCycle);
        offsetArray = new ArrayList<String>();
        for (i = 0; i < cycleWords.size(); ++i) {
            if (this.isKeyWord(cycleWords.get(i))) {
                keyWord = cycleWords.get(i++);
                value = i >= cycleWords.size() ? "" : cycleWords.get(i);
                this.handleKeyVal(keyWord, value, targetRbc);
                continue;
            }
            if (cycleWords.get(i).toLowerCase().matches(RuncycleConvertor.WEEK_DAY_LIST_EXPR)) {
                this.weekdayListToRbc(cycleWords.get(i), targetRbc);
                continue;
            }
            if (cycleWords.get(i).matches(RuncycleConvertor.MMDDYYYY_LIST_EXPR) || cycleWords.get(i).matches("^[0-9]{8}(,[0-9]{8})*$")) {
                Reporter.addMessage(conversionMessages, (String)"WRN6007", (String)schedule, (String[])new String[]{schedule, "Dates list: " + cycleWords.get(i)});
                continue;
            }
            if (cycleWords.get(i).matches(RuncycleConvertor.MMDDYY_LIST_EXPR) || cycleWords.get(i).matches("^[0-9]{6}(,[0-9]{6})*$")) {
                Reporter.addMessage(conversionMessages, (String)"WRN6007", (String)schedule, (String[])new String[]{schedule, "Dates list: " + cycleWords.get(i)});
                continue;
            }
            if (cycleWords.get(i).toLowerCase().matches("^[+-][0-9]+((day|weekday|workday)s?)?$")) {
                offsetStr = cycleWords.get(i);
                if (i + 1 <= cycleWords.size() && cycleWords.get(i + 1).toLowerCase().matches("(day|weekday|workday)s?")) {
                    offsetStr = (String)offsetStr + " ";
                    offsetStr = (String)offsetStr + cycleWords.get(++i);
                }
                Reporter.addMessage(conversionMessages, (String)"WRN6007", (String)schedule, (String[])new String[]{schedule, "Offset: " + (String)offsetStr});
                continue;
            }
            if (cycleWords.get(i).toUpperCase().startsWith("FREQ=")) {
                this.iCalendarToRbc(cycleWords.get(i), targetRbc, conversionMessages, schedule);
                continue;
            }
            if (cycleWords.get(i).equalsIgnoreCase("request")) continue;
            if (cycleWords.get(i).toLowerCase().matches("fd(ignore|prev|next)")) {
                if (offsetArray.size() > 1) {
                    Reporter.addMessage(conversionMessages, (String)"WRN0014", (String)schedule, (String[])new String[]{"TWS", "CONFCAL", (String)offsetArray.get(1), cycleWords.get(i), "Offset definition is not simple"});
                    continue;
                }
                this.setConfCal(cycleWords.get(i).toLowerCase(), targetRbc);
                continue;
            }
            if (cycleWords.get(i).equalsIgnoreCase("everyday")) {
                for (j = 0; j < GlobalFunctions.getMonthsArray().length; ++j) {
                    targetRbc.put(GlobalFunctions.getMonthsArray()[j], "1");
                }
                targetRbc.setProperty("DAYS", "ALL");
                continue;
            }
            if (cycleWords.get(i).equalsIgnoreCase("weekdays")) {
                startDay = this.rules.getStringRule("TWS rules", new String[]{"FIRST_DAY_OF_WEEK"}).substring(0, 3).toUpperCase();
                if (startDay.equals("SUN")) {
                    targetRbc.setProperty("WEEKDAYS", "2,3,4,5,6");
                    continue;
                }
                targetRbc.setProperty("WEEKDAYS", "1,2,3,4,5");
                continue;
            }
            if (!cycleWords.get(i).trim().matches("^[A-Za-z][A-Za-z0-9_-]*$") || targetRbc.containsKey("DAYSCAL")) continue;
            targetRbc.put("DAYSCAL", cycleWords.get(i));
            if (this.calendarsConvertor == null || !this.calendarsConvertor.isConverted(cycleWords.get(i))) {
                action = new HashMap<String, String>();
                action.put("ACTENTTYPE", "CAL");
                action.put("JOBID", schedule);
                action.put("ACTENTNAME", cycleWords.get(i));
                action.put("ACTENTQTY", "0");
                action.put("ACTSTATUS", "0");
                Reporter.addAction(action);
            }
            while (i + 1 < cycleWords.size() && cycleWords.get(i + 1).toLowerCase().matches("((day|weekday|workday)s?)|([-+]?[0-9]*)")) {
                offsetArray.add(cycleWords.get(++i));
            }
        }
        if (targetRbc.keySet().isEmpty()) {
            targetRbc = null;
        } else {
            if (offsetArray.size() > 1) {
                if (targetRbc.size() == 2) {
                    targetRbc.put("CONFCAL", offsetArray.get(1));
                    targetRbc.put("SHIFT", "NOCONFCAL");
                    shiftnum = 0;
                    try {
                        shiftnum = Integer.parseInt(((String)offsetArray.get(0)).replace("+", ""));
                        if (shiftnum >= -62 && shiftnum <= 62) ** GOTO lbl99
                        Reporter.addMessage(conversionMessages, (String)"WRN0020", (String)schedule, (String[])new String[]{"TWS", "Shift", (String)offsetArray.get(0), "SHIFTNUM", String.valueOf(shiftnum), "Number from -62 to 62"});
                    }
                    catch (NumberFormatException e) {
                        Reporter.addMessage(conversionMessages, (String)"WRN0010", (String)schedule, (String[])new String[]{"TWS", "Shift", (String)offsetArray.get(0), "SHIFTNUM", String.valueOf(shiftnum)});
                        shiftnum = 0;
                    }
                    finally {
                        targetRbc.put("SHIFTNUM", String.valueOf(shiftnum));
                    }
                } else {
                    Reporter.addMessage(conversionMessages, (String)"WRN6007", (String)schedule, (String[])new String[]{schedule, "More than one scheduling definition " + cycleWords.toString().replace(",", "")});
                }
            }
lbl99:
            // 6 sources

            monthsArr = GlobalFunctions.getMonthsArray();
            for (String s : monthsArr) {
                targetRbc.put(s, "1");
            }
            if (!targetRbc.containsKey("NAME") && !RbcNamer.nameRbc((Properties)targetRbc, (String)this.rules.getStringRule("TWS rules", new String[]{"FIRST_DAY_OF_WEEK"}).substring(0, 3).toUpperCase())) {
                var8_15 = this.anonymousCount;
                this.anonymousCount = this.anonymousCount + 1;
                targetRbc.put("NAME", "RBC_" + var8_15.toString());
                Reporter.addMessage(conversionMessages, (String)"INF6105", (String)schedule, (String[])new String[]{sourceCycle, targetRbc.getProperty("NAME")});
            }
        }
    }

    private void setConfCal(String shift, Properties targetRbc) {
        targetRbc.putIfAbsent("CONFCAL", this.rules.getStringRule("TWS rules", new String[]{"WORKDAYS_CALENDAR"}));
        if (shift.equalsIgnoreCase("fdnext")) {
            targetRbc.put("SHIFT", "NEXTDAY");
        }
        if (shift.equalsIgnoreCase("fdprev")) {
            targetRbc.put("SHIFT", "PREVDAY");
        }
    }

    private void iCalendarToRbc(String iCal, Properties targetRbc, List<String> conversionMessages, String schedule) {
        String[] iCalRules = iCal.split(";");
        String freq = null;
        String modifierKey = null;
        String modifierValue = null;
        for (String iCalRule : iCalRules) {
            String value;
            String[] ruleArr = iCalRule.split("=");
            String key = ruleArr[0].trim();
            String string = value = ruleArr.length > 1 ? ruleArr[1].trim() : "";
            if (key.equalsIgnoreCase("FREQ")) {
                freq = value;
                continue;
            }
            if (key.equalsIgnoreCase("INTERVAL")) {
                if (value.equals("1")) continue;
                Reporter.addMessage(conversionMessages, (String)"WRN6007", (String)schedule, (String[])new String[]{schedule, "INTERVAL"});
                return;
            }
            modifierKey = key;
            modifierValue = value;
        }
        if ("DAILY".equalsIgnoreCase(freq)) {
            targetRbc.setProperty("DAYS", "ALL");
            if (modifierKey != null) {
                String currConfcal = targetRbc.getProperty("CONFCAL");
                if (modifierKey.equalsIgnoreCase("BYWORKDAY") && currConfcal == null) {
                    targetRbc.put("CONFCAL", this.rules.getStringRule("TWS rules", new String[]{"WORKDAYS_CALENDAR"}));
                }
                if (modifierKey.equalsIgnoreCase("BYFREEDAY")) {
                    if (currConfcal == null) {
                        targetRbc.put("CONFCAL", this.rules.getStringRule("TWS rules", new String[]{"FREEDAYS_CALENDAR"}));
                    } else {
                        targetRbc.put("CONFCAL", currConfcal.substring(currConfcal.indexOf(45) + 1));
                    }
                }
            }
        } else if ("WEEKLY".equalsIgnoreCase(freq)) {
            if (modifierKey == null || !modifierKey.equalsIgnoreCase("BYDAY")) {
                Reporter.addMessage(conversionMessages, (String)"WRN6007", (String)schedule, (String[])new String[]{schedule, iCal + " invalid modifier " + modifierKey});
                return;
            }
            this.weekdayListToRbc(modifierValue, targetRbc);
        } else if ("MONTHLY".equalsIgnoreCase(freq)) {
            if (modifierKey == null || !modifierKey.equalsIgnoreCase("BYDAY") && !modifierKey.equalsIgnoreCase("BYMONTHDAY")) {
                Reporter.addMessage(conversionMessages, (String)"WRN6007", (String)schedule, (String[])new String[]{schedule, iCal + " invalid modifier " + modifierKey});
                return;
            }
            if (modifierKey.equalsIgnoreCase("BYMONTHDAY")) {
                this.monthDayListToRbc(modifierValue, targetRbc);
            } else if (modifierKey.equalsIgnoreCase("BYDAY")) {
                if (modifierValue.toLowerCase().matches(WEEK_DAY_LIST_EXPR)) {
                    this.weekdayListToRbc(modifierValue, targetRbc);
                } else if (modifierValue.toLowerCase().matches(NUMBERED_WEEK_DAY_LIST_EXPR)) {
                    this.numberedWeekdayListToRbc(modifierValue, targetRbc, conversionMessages, schedule);
                }
            }
        } else {
            Reporter.addMessage(conversionMessages, (String)"WRN6007", (String)schedule, (String[])new String[]{schedule, "FREQ=" + freq});
        }
    }

    private void monthDayListToRbc(String dayList, Properties targetRbc) {
        String[] daysArr = dayList.split(", *");
        StringBuilder monthDays = new StringBuilder();
        for (int i = 0; i < daysArr.length; ++i) {
            if (daysArr[i].matches("^[+-][0-9]+$")) {
                char operator = daysArr[i].charAt(0);
                if (operator == '+') {
                    daysArr[i] = daysArr[i].substring(1);
                } else {
                    if (!targetRbc.containsKey("DAYSCAL")) {
                        targetRbc.put("DAYSCAL", this.rules.getStringRule("TWS rules", new String[]{"ALL_DAYS_CALENDAR"}));
                    }
                    if (monthDays.length() > 0) {
                        monthDays.append(',');
                    }
                    monthDays.append('L');
                    monthDays.append(Integer.valueOf(daysArr[i].substring(1)));
                }
            }
            if (!daysArr[i].matches("^[0-9]+$")) continue;
            if (monthDays.length() > 0) {
                monthDays.append(',');
            }
            monthDays.append(Integer.valueOf(daysArr[i]));
        }
        targetRbc.put("DAYS", monthDays.toString());
    }

    private void numberedWeekdayListToRbc(String daysList, Properties targetRbc, List<String> conversionMessages, String schedule) {
        String firstDay = this.rules.getStringRule("TWS rules", new String[]{"FIRST_DAY_OF_WEEK"}).substring(0, 3).toUpperCase();
        String[] daysArr = daysList.toLowerCase().split(", *");
        StringBuilder ctmWeekDays = new StringBuilder();
        Pattern pattern = Pattern.compile(String.format("^(([+-])?([0-9]))?%s$", WEEK_DAY_EXPR));
        for (String s : daysArr) {
            Matcher matcher = pattern.matcher(s.trim());
            if (!matcher.matches()) continue;
            String operator = matcher.group(2);
            if (operator == null) {
                operator = "+";
            }
            String week = matcher.group(3);
            if (ctmWeekDays.length() > 0) {
                ctmWeekDays.append(",");
            }
            if (week == null || week.isEmpty()) {
                ctmWeekDays.append(GlobalFunctions.getDayOfTheWeekCtmIndex((String[])GlobalFunctions.getWeekDaysArray((String)firstDay), (String)this.dayNameMap.get(s)));
                continue;
            }
            if (operator.equals("-")) {
                Reporter.addMessage(conversionMessages, (String)"WRN6007", (String)schedule, (String[])new String[]{schedule, s});
                continue;
            }
            String day = GlobalFunctions.getDayOfTheWeekCtmIndex((String[])GlobalFunctions.getWeekDaysArray((String)firstDay), (String)this.dayNameMap.get(s.substring(1))).toString();
            ctmWeekDays.append(String.format("D%sW%s", day, week));
        }
        targetRbc.put("WEEKSCAL", this.rules.getStringRule("TWS rules", new String[]{"ALL_DAYS_CALENDAR"}));
        targetRbc.put("WEEKDAYS", ctmWeekDays.toString());
    }

    private void weekdayListToRbc(String daysList, Properties targetRbc) {
        String firstDay = this.rules.getStringRule("TWS rules", new String[]{"FIRST_DAY_OF_WEEK"}).substring(0, 3).toUpperCase();
        String[] daysArr = daysList.toLowerCase().split(", *");
        StringBuilder ctmWeekDays = new StringBuilder(targetRbc.getProperty("WEEKDAYS") == null ? "" : targetRbc.getProperty("WEEKDAYS"));
        for (String s : daysArr) {
            if (s.isEmpty()) continue;
            if (ctmWeekDays.length() > 0) {
                ctmWeekDays.append(",");
            }
            ctmWeekDays.append(GlobalFunctions.getDayOfTheWeekCtmIndex((String[])GlobalFunctions.getWeekDaysArray((String)firstDay), (String)this.dayNameMap.get(s.toLowerCase())));
        }
        targetRbc.put("WEEKDAYS", ctmWeekDays.toString());
    }

    private void handleKeyVal(String keyWord, String value, Properties targetRbc) {
        if (keyWord.equalsIgnoreCase("RUNCYCLE")) {
            targetRbc.put("NAME", value);
        } else if (keyWord.equalsIgnoreCase("VALIDFROM") || keyWord.equalsIgnoreCase("VALIDTO")) {
            String key = keyWord.equalsIgnoreCase("VALIDFROM") ? "ACTIVE_FROM" : "ACTIVE_TILL";
            String[] date = value.split("/", 3);
            targetRbc.put(key, String.format("%s%s%s", date[2], date[0], date[1]));
        } else if (this.ignoredKeyWords.contains(keyWord) || keyWord.equalsIgnoreCase("VARTABLE")) {
            // empty if block
        }
    }

    private boolean isKeyWord(String string) {
        return this.keyWords.contains(string.toUpperCase());
    }

    private ArrayList<String> stringToWords(String source) {
        ArrayList<String> toRet = new ArrayList<String>();
        boolean quoted = false;
        StringBuilder currWord = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            boolean escaped = false;
            if (source.charAt(i) == '\\' && !escaped) {
                escaped = true;
            }
            if (source.charAt(i) == '\"' && !escaped) {
                quoted = !quoted;
                continue;
            }
            if (Character.isWhitespace(source.charAt(i)) && !escaped && !quoted) {
                toRet.add(currWord.toString());
                currWord.delete(0, currWord.length());
                continue;
            }
            currWord.append(source.charAt(i));
        }
        if (currWord.length() > 0) {
            toRet.add(currWord.toString());
        }
        return toRet;
    }

    public Properties invertRbc(Properties sourceRbc) {
        Properties toRet = (Properties)sourceRbc.clone();
        this.invertCalendars(sourceRbc, toRet);
        this.invertWeekDays(sourceRbc, toRet);
        this.invertMonthDays(sourceRbc, toRet);
        return toRet;
    }

    private void invertWeekDays(Properties sourceRbc, Properties toRet) {
        String sourceDays = sourceRbc.getProperty("WEEKDAYS");
        if (sourceDays == null) {
            return;
        }
        if (sourceDays.matches("[0-9](,[0-9])*")) {
            StringBuilder inverted = new StringBuilder();
            Integer i = 0;
            while (i < 7) {
                if (!sourceDays.contains(Integer.toString(i))) {
                    if (inverted.length() > 0) {
                        inverted.append(',');
                    }
                    inverted.append(i);
                }
                Integer n = i;
                i = i + 1;
            }
            toRet.put("WEEKDAYS", inverted.toString());
        }
    }

    private void invertMonthDays(Properties sourceRbc, Properties toRet) {
        String[] sourceDays;
        if (!sourceRbc.containsKey("DAYS")) {
            return;
        }
        StringBuilder invertedDays = new StringBuilder();
        if (!sourceRbc.containsKey("DAYSCAL")) {
            toRet.put("DAYSCAL", this.rules.getStringRule("TWS rules", new String[]{"ALL_DAYS_CALENDAR"}));
        }
        for (String sourceDay : sourceDays = ((String)sourceRbc.get("DAYS")).split(",")) {
            if (sourceDay.matches("^[0-9]+$")) {
                if (invertedDays.length() > 0) {
                    invertedDays.append(',');
                }
                invertedDays.append("-D");
                invertedDays.append(sourceDay);
                continue;
            }
            if (sourceDay.matches("^[LD][0-9]+$")) {
                if (invertedDays.length() > 0) {
                    invertedDays.append(',');
                }
                invertedDays.append("-");
                invertedDays.append(sourceDay);
                continue;
            }
            if (invertedDays.length() > 0) {
                invertedDays.append(',');
            }
            invertedDays.append(sourceDay);
        }
        toRet.put("DAYS", invertedDays.toString());
    }

    private void invertCalendars(Properties sourceRbc, Properties toRet) {
        if (sourceRbc.containsKey("WEEKSCAL") && !sourceRbc.get("WEEKSCAL").equals(this.rules.getStringRule("TWS rules", new String[]{"ALL_DAYS_CALENDAR"}))) {
            toRet.put("WEEKSCAL", "not-" + String.valueOf(sourceRbc.get("WEEKSCAL")));
        }
        if (sourceRbc.containsKey("DAYSCAL") && !sourceRbc.get("DAYSCAL").equals(this.rules.getStringRule("TWS rules", new String[]{"ALL_DAYS_CALENDAR"}))) {
            toRet.put("DAYSCAL", "not-" + String.valueOf(sourceRbc.get("DAYSCAL")));
        }
        if (sourceRbc.containsKey("CONFCAL")) {
            String confCal = (String)sourceRbc.get("CONFCAL");
            if (confCal == null) {
                confCal = "";
            }
            if (confCal.equals(this.rules.getStringRule("TWS rules", new String[]{"FREEDAYS_CALENDAR"}))) {
                toRet.put("CONFCAL", this.rules.getStringRule("TWS rules", new String[]{"WORKDAYS_CALENDAR"}));
            } else if (confCal.equals(this.rules.getStringRule("TWS rules", new String[]{"WORKDAYS_CALENDAR"}))) {
                toRet.put("CONFCAL", this.rules.getStringRule("TWS rules", new String[]{"FREEDAYS_CALENDAR"}));
            } else if (!confCal.isEmpty() && !sourceRbc.get("CONFCAL").equals(this.rules.getStringRule("TWS rules", new String[]{"ALL_DAYS_CALENDAR"}))) {
                if (confCal.startsWith("not-")) {
                    toRet.put("CONFCAL", confCal.substring(confCal.indexOf(45) + 1));
                } else {
                    toRet.put("CONFCAL", "not-" + confCal);
                }
            }
        }
    }
}

