/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.csvreader.CsvWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class Resources {
    static final char MARKSIGN = '#';
    static final String[] csvHeader = new String[]{"ResourceName", "quantity", "description"};
    private File inputFile;
    private String resourcesCsvFile;
    private CsvWriter resourcesCsv;
    private String[] resourcesParametersValues;

    public Resources(File inputFile, String convertpath) {
        this.inputFile = inputFile;
        this.resourcesCsvFile = convertpath + "resources.csv";
        this.resourcesParametersValues = new String[csvHeader.length];
    }

    private void getParametersFromReadLine(String line) throws IOException {
        String[] params = line.split("[ \\t]+", 3);
        if (params.length == 2 || params.length == 3) {
            this.resourcesParametersValues[0] = params[0];
            this.resourcesParametersValues[1] = params[1];
            this.resourcesParametersValues[2] = params.length == 3 ? params[2] : "";
            this.resourcesCsv.writeRecord(this.resourcesParametersValues);
        }
    }

    public void writeToCSV() {
        if (!this.inputFile.exists()) {
            return;
        }
        try {
            BufferedReader input = new BufferedReader(new FileReader(this.inputFile));
            String line = input.readLine();
            line = line.trim();
            if (line.compareToIgnoreCase("$RESOURCE") != 0) {
                input.close();
                return;
            }
            this.resourcesCsv = new CsvWriter(this.resourcesCsvFile);
            this.resourcesCsv.writeRecord(csvHeader);
            while ((line = input.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                this.getParametersFromReadLine(line);
            }
            this.resourcesCsv.close();
            input.close();
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }
}

