/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.tws.Dependecy;
import com.bmc.ctmconvert.tws.DependencySide;
import com.bmc.ctmconvert.tws.TwsDefs;
import com.bmc.ctmconvert.tws.TwsJob;
import com.bmc.ctmconvert.tws.TwsUniqueConditionNameGenerator;
import java.util.ArrayList;
import java.util.Properties;

public class OutConditionsManager {
    private TwsJob twsJob;
    private TwsDefs sourceDefinition;
    private TwsUniqueConditionNameGenerator uniqueConditionNameGenerator;

    public OutConditionsManager(TwsJob twsJob, TwsDefs sourceDefinition) {
        this.twsJob = twsJob;
        this.sourceDefinition = sourceDefinition;
        this.uniqueConditionNameGenerator = this.sourceDefinition.getuniqueConditionNameGenerator();
    }

    public ArrayList<Properties> generateOutConditions() {
        String conditionSender = this.twsJob.getFullQualifiedJobName();
        ArrayList<Properties> outCondslist = new ArrayList<Properties>();
        if (this.sourceDefinition.isConditionSent(conditionSender)) {
            outCondslist = this.convertToCtmOutCondition(conditionSender);
        }
        return outCondslist;
    }

    public void addCondition() {
    }

    private ArrayList<Properties> convertToCtmOutCondition(String conditionSender) {
        String format = this.sourceDefinition.getConditionFormatRule();
        if (format.equals("JOB-TO-JOB")) {
            return this.buildFromJobtoJobOutConditions(conditionSender);
        }
        return this.buildEnded_OkOutConditions();
    }

    private ArrayList<Properties> buildFromJobtoJobOutConditions(String conditionSender) {
        ArrayList<Properties> toRet = new ArrayList<Properties>();
        ArrayList<DependencySide> gettersSide = this.sourceDefinition.getConditionGettersBySender(conditionSender);
        for (DependencySide getterSide : gettersSide) {
            Properties toAdd = new Properties();
            DependencySide senderSide = this.buildSenderSideDependency();
            String scheduleWithFollows = getterSide.getFolderName();
            if (getterSide.getType() == SchedEntity.TYPE.JOB) {
                getterSide.setFolderName(scheduleWithFollows.split("#")[1]);
            } else {
                scheduleWithFollows = String.format("%s#%s", getterSide.getCpuName(), scheduleWithFollows);
            }
            Dependecy dependency = new Dependecy(senderSide, getterSide, scheduleWithFollows, "OUTCOND");
            toAdd.put("NAME", this.uniqueConditionNameGenerator.getUniqueConditionName(dependency));
            toAdd.put("ODATE", "ODAT");
            toAdd.put("SIGN", "ADD");
            toRet.add(toAdd);
        }
        return toRet;
    }

    private ArrayList<Properties> buildEnded_OkOutConditions() {
        ArrayList<Properties> toRet = new ArrayList<Properties>();
        String condNodeTable = this.twsJob.type() == SchedEntity.TYPE.SMART_TABLE ? this.twsJob.getOriginalJobName(true) : this.twsJob.getParent().getOriginalJobName(true);
        String condJob = this.twsJob.type() == SchedEntity.TYPE.SMART_TABLE ? "" : this.twsJob.getOriginalJobName(false);
        Properties toAdd = new Properties();
        toAdd.put("NAME", String.format("%s%s%s_OK", condNodeTable, condJob.isEmpty() ? "" : ".", condJob));
        toAdd.put("ODATE", "ODAT");
        toAdd.put("SIGN", "ADD");
        toRet.add(toAdd);
        return toRet;
    }

    private DependencySide buildSenderSideDependency() {
        DependencySide outSide = this.twsJob.type() == SchedEntity.TYPE.JOB ? new DependencySide(this.twsJob.GetOrigNodeid(), this.twsJob.getOriginalParentName(false), this.twsJob.getOriginalJobName(false)) : new DependencySide(this.twsJob.GetOrigNodeid(), this.twsJob.getOriginalJobName(false));
        return outSide;
    }
}

