/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.tws.DependencySide;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DependencyCreator {
    private Map<String, ArrayList<DependencySide>> outConditionSenders = new HashMap<String, ArrayList<DependencySide>>();
    RulesDataSet rules;

    public DependencyCreator(RulesDataSet rules) {
        this.rules = rules;
    }

    public void createdeps(String predecessors, String receivingID) {
        boolean isJobReceive;
        String[] predArr = predecessors.split("\\s*,\\s*");
        Pattern recievePattern = Pattern.compile("([A-Za-z0-9_-]+)#([A-Za-z0-9_-]+)( ([A-Za-z0-9_-]+)#([A-Za-z0-9_-]+)( AS ([A-Za-z0-9_-]+))?)?");
        Matcher recieveMatcher = recievePattern.matcher(receivingID);
        if (!recieveMatcher.matches()) {
            return;
        }
        String rcvSchedNode = recieveMatcher.group(1);
        String rcvSchedId = recieveMatcher.group(2);
        String rcvJobId = recieveMatcher.group(5);
        String rcvAlias = recieveMatcher.group(7);
        boolean bl = isJobReceive = rcvJobId != null && !rcvJobId.isEmpty();
        if (isJobReceive && rcvAlias != null && !rcvAlias.isEmpty()) {
            rcvJobId = rcvAlias;
        }
        for (int i = 0; i < predArr.length; ++i) {
            String sendingSched;
            String sendingJob;
            predArr[i] = predArr[i].replace("\"", "");
            Pattern followPat = Pattern.compile("(.+::)?(([A-Za-z0-9_-]+)#)?([A-Za-z0-9_-]+)([.]([A-Za-z0-9_-]+|@))?( .*)?");
            Matcher followMatch = followPat.matcher(predArr[i]);
            if (!followMatch.matches()) continue;
            String sendingNode = followMatch.group(3);
            if (sendingNode == null || sendingNode.isEmpty()) {
                sendingNode = rcvSchedNode;
            }
            if (isJobReceive) {
                entName = followMatch.group(6);
                if (entName != null && !entName.isEmpty()) {
                    sendingJob = entName.equals("@") ? null : entName;
                    sendingSched = followMatch.group(4);
                } else {
                    sendingJob = followMatch.group(4);
                    sendingSched = rcvSchedId;
                }
            } else {
                entName = followMatch.group(6);
                if (entName != null && !entName.isEmpty()) {
                    sendingJob = entName.equals("@") ? null : entName;
                    sendingSched = followMatch.group(4);
                } else {
                    sendingJob = null;
                    sendingSched = followMatch.group(4);
                }
            }
            String conditionSenderName = String.format("%s#%s.%s", sendingNode, sendingSched, sendingJob == null ? "" : sendingJob);
            SchedEntity.TYPE rcvType = rcvJobId == null ? SchedEntity.TYPE.SMART_TABLE : SchedEntity.TYPE.JOB;
            String optionalRecevieNode = this.extractReceiveNode(receivingID);
            String recevieNode = optionalRecevieNode == null ? rcvSchedNode : optionalRecevieNode;
            DependencySide recevieSide = rcvType == SchedEntity.TYPE.JOB ? new DependencySide(recevieNode, String.format("%s#%s", rcvSchedNode, rcvSchedId), rcvJobId) : new DependencySide(recevieNode, rcvSchedId);
            if (this.outConditionSenders.containsKey(conditionSenderName)) {
                this.outConditionSenders.get(conditionSenderName).add(recevieSide);
                continue;
            }
            ArrayList<DependencySide> conditionGettersList = new ArrayList<DependencySide>();
            conditionGettersList.add(recevieSide);
            this.outConditionSenders.put(conditionSenderName, conditionGettersList);
        }
    }

    public boolean containsKey(String outJob) {
        return this.outConditionSenders.containsKey(outJob);
    }

    public ArrayList<DependencySide> get(String outJob) {
        ArrayList<DependencySide> conditionsGetters = this.outConditionSenders.get(outJob);
        return conditionsGetters;
    }

    private String extractReceiveNode(String receivingID) {
        String[] splitByHashTag;
        String toRet = null;
        String[] splitBySpace = receivingID.split("\\s+");
        if (splitBySpace.length >= 2 && (splitByHashTag = splitBySpace[1].split("#")).length == 2) {
            toRet = splitByHashTag[0];
        }
        return toRet;
    }
}

