/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.csvreader.CsvWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Cpu2csv {
    private File m_targetCsv;
    private File m_sourceFile;
    private final String[] m_sourceKeys = new String[]{"CPUNAME", "CPUCLASS", "DOMAIN", "DESCRIPTION", "VARTABLE", "OS", "NODE", "TCPADDR", "SECUREADDR", "TZ", "TIMEZONE", "DOMAIN", "HOST", "ACCESS", "TYPE", "IGNORE", "AUTOLINK", "BEHINDFIREWALL", "SECURITYLEVEL", "FULLSTATUS", "SERVER", "MEMBERS", "*MANAGER", "PARENT", "END", "FOR", "MAESTRO", "ISMASTER"};
    private final String[] m_csvHeader = new String[]{"NAME", "CLASS", "DESCRIPTION", "VARTABLE", "OS", "NODE", "TCPADDR", "SECUREADDR", "TIMEZONE", "DOMAIN", "HOST", "ACCESS", "TYPE", "IGNORE", "AUTOLINK", "BEHINDFIREWALL", "SECURITYLEVEL", "FULLSTATUS", "SERVER", "MEMBERS", "*MANAGER", "PARENT"};

    public Cpu2csv(File cpuFile, File targetCsv) {
        this.m_sourceFile = cpuFile;
        this.m_targetCsv = targetCsv;
    }

    public void writeToCSV() throws IOException {
        this.entries2csv(this.readEntries());
    }

    private ArrayList<HashMap<String, String>> readEntries() throws IOException {
        String currLine;
        ArrayList<HashMap<String, String>> toRet = new ArrayList<HashMap<String, String>>();
        BufferedReader inputStream = new BufferedReader(new FileReader(this.m_sourceFile));
        ArrayList<String> rawEntry = new ArrayList<String>();
        while ((currLine = inputStream.readLine()) != null) {
            if (currLine.trim().isEmpty()) continue;
            rawEntry.add(currLine);
            if (!currLine.equalsIgnoreCase("END")) continue;
            toRet.add(this.processEntry(rawEntry));
            rawEntry.clear();
        }
        inputStream.close();
        return toRet;
    }

    private HashMap<String, String> processEntry(ArrayList<String> rawEntry) {
        HashMap<String, String> toRet = new HashMap<String, String>();
        String currKey = "";
        StringBuilder currValue = new StringBuilder();
        for (String line : rawEntry) {
            String[] lineArr = line.split("[ \t]+");
            for (int i = 0; i < lineArr.length; ++i) {
                if (this.isKey(lineArr[i])) {
                    currKey = this.handleNewKey(toRet, lineArr[i].toUpperCase(), currKey.toUpperCase(), currValue);
                    continue;
                }
                if (lineArr[i].isEmpty()) continue;
                if (currValue.length() > 0) {
                    currValue.append(' ');
                }
                currValue.append(lineArr[i]);
            }
        }
        return toRet;
    }

    private String handleNewKey(HashMap<String, String> map, String newKey, String currKey, StringBuilder currValue) {
        String tmpValue = currValue.toString();
        String retKey = newKey;
        if (currKey.equals("DESCRIPTION") && tmpValue.indexOf(34) == tmpValue.lastIndexOf(34)) {
            return currKey;
        }
        if (newKey.equals("FOR") || newKey.equals("MAESTRO")) {
            return currKey;
        }
        if (newKey.equals("TZ")) {
            retKey = "TIMEZONE";
        }
        if (newKey.equals("CPUNAME") || newKey.equals("CPUCLASS") || newKey.equals("DOMAIN") && !map.containsKey("CLASS")) {
            map.put("CLASS", newKey);
            retKey = "NAME";
        }
        if (newKey.equals("IGNORE")) {
            map.put(newKey, newKey);
            retKey = "";
        }
        if (newKey.equals("ISMASTER")) {
            map.put("PARENT", newKey);
            retKey = "";
        }
        if (!currKey.isEmpty() && currValue.length() > 0) {
            map.put(currKey, tmpValue);
            currValue.delete(0, currValue.length());
        }
        return retKey;
    }

    private boolean isKey(String string) {
        for (int i = 0; i < this.m_sourceKeys.length; ++i) {
            if (!this.m_sourceKeys[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void entries2csv(ArrayList<HashMap<String, String>> entries) throws IOException {
        CsvWriter writer = new CsvWriter(this.m_targetCsv.getPath());
        writer.writeRecord(this.m_csvHeader);
        for (HashMap<String, String> entry : entries) {
            writer.writeRecord(this.cpuMap2arr(entry));
        }
        writer.close();
    }

    private String[] cpuMap2arr(HashMap<String, String> entry) {
        String[] toRet = new String[this.m_csvHeader.length];
        for (int i = 0; i < this.m_csvHeader.length; ++i) {
            if (!entry.containsKey(this.m_csvHeader[i])) continue;
            toRet[i] = entry.get(this.m_csvHeader[i]);
        }
        return toRet;
    }
}

