/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.scheduling;

import com.bmc.ctmconvert.dSeries.scheduling.EventSchedulingTokenizer;
import com.bmc.ctmconvert.dSeries.scheduling.TreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

class TreeExtractor {
    private final TreeNode<EventSchedulingTokenizer.Token> tree;
    private final List<EventSchedulingTokenizer.Token> route;

    public TreeExtractor(TreeNode<EventSchedulingTokenizer.Token> tree) {
        this(tree, new ArrayList<EventSchedulingTokenizer.Token>());
    }

    private TreeExtractor(TreeNode<EventSchedulingTokenizer.Token> tree, List<EventSchedulingTokenizer.Token> route) {
        this.tree = tree;
        this.route = route;
    }

    public TreeExtractor get(EventSchedulingTokenizer.TokenType ... type) {
        Optional<TreeNode<EventSchedulingTokenizer.Token>> child = this.tree.getChildBy(i -> List.of(type).contains((Object)((EventSchedulingTokenizer.Token)i.getData()).type()));
        return child.map(this.next()).orElse(new EmptyTreeExtractor());
    }

    private Function<TreeNode<EventSchedulingTokenizer.Token>, TreeExtractor> next() {
        return token -> {
            this.route.add((EventSchedulingTokenizer.Token)token.getData());
            return new TreeExtractor((TreeNode<EventSchedulingTokenizer.Token>)token, this.route);
        };
    }

    public TreeExtractor getOptional(EventSchedulingTokenizer.TokenType type) {
        Optional<TreeNode<EventSchedulingTokenizer.Token>> child = this.tree.getChildBy(i -> ((EventSchedulingTokenizer.Token)i.getData()).type() == type);
        return child.filter(c -> ((EventSchedulingTokenizer.Token)c.getData()).type() == type).map(this.next()).orElseGet(() -> child.map(token -> new TreeExtractor((TreeNode<EventSchedulingTokenizer.Token>)token, this.route)).orElse(this));
    }

    public Route getRoute() {
        return new Route(this.route);
    }

    public <T> Optional<T> convert(Function<List<EventSchedulingTokenizer.Token>, T> creator) {
        return Optional.ofNullable(creator.apply(this.route));
    }

    private static class EmptyTreeExtractor
    extends TreeExtractor {
        private static final TreeNode<EventSchedulingTokenizer.Token> emptyTree = new TreeNode<EventSchedulingTokenizer.Token>(EventSchedulingTokenizer.empty(""));

        public EmptyTreeExtractor() {
            super(emptyTree);
        }

        @Override
        public TreeExtractor get(EventSchedulingTokenizer.TokenType ... type) {
            return new EmptyTreeExtractor();
        }
    }

    public static class Route {
        private final List<EventSchedulingTokenizer.Token> tokensRoute;

        public Route(List<EventSchedulingTokenizer.Token> tokensRoute) {
            this.tokensRoute = tokensRoute;
        }

        public boolean isEmpty() {
            return this.tokensRoute.isEmpty();
        }

        public boolean isNotEmpty() {
            return !this.isEmpty();
        }

        public EventSchedulingTokenizer.Token get(EventSchedulingTokenizer.TokenType type, int position) {
            return (EventSchedulingTokenizer.Token)this.tokensRoute.stream().filter(i -> i.type() == type).collect(Collectors.toList()).get(position);
        }

        public EventSchedulingTokenizer.Token get(EventSchedulingTokenizer.TokenType type) {
            return this.tokensRoute.stream().filter(i -> i.type() == type).findFirst().orElse(EventSchedulingTokenizer.empty(""));
        }

        public EventSchedulingTokenizer.Token get(int index) {
            return this.tokensRoute.get(index);
        }
    }
}

