/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.database;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DSeriesCommonDataBaseHandler {
    private final XmlElement jobData;

    public DSeriesCommonDataBaseHandler(XmlElement jobData) {
        this.jobData = jobData;
    }

    public Optional<String> convertConnectionProfile() {
        return Optional.ofNullable(this.jobData.getFirstChildElementByName("app:dburl")).map(XmlElement::getText).map(this::parseConnectionProfile);
    }

    private String parseConnectionProfile(String connectionString) {
        String host = this.getHostFromConnectionString(connectionString);
        String databaseName = this.getDatabaseNameFromConnectionString(connectionString);
        String connectionProfile = List.of(host, databaseName).stream().filter(s -> !s.isBlank()).collect(Collectors.joining("_"));
        return this.validateConnectionProfile(connectionProfile);
    }

    private String validateConnectionProfile(String connectionProfile) {
        if (connectionProfile.isBlank()) {
            return "DB_DEFAULT_CONNECTION";
        }
        return FieldValidation.instance().validateAndReturnFixedValue("CONNECTION_PROFILE", connectionProfile);
    }

    private String getDatabaseNameFromConnectionString(String connectionString) {
        String dbRegex = this.getDataBaseNameRegexByType(connectionString);
        Matcher databaseMatcher = Pattern.compile(dbRegex).matcher(connectionString);
        return databaseMatcher.matches() ? databaseMatcher.group("db") : "";
    }

    private String getDataBaseNameRegexByType(String input) {
        String dbNameGroup = "(?<db>[\\w$]+)";
        if (input.contains(":sqlserver:")) {
            return ".*?DatabaseName=(?<db>[\\w$]+).*";
        }
        if (input.contains(":teradata:")) {
            return ".*?DATABASE=(?<db>[\\w$]+).*";
        }
        return ".*/(?<db>[\\w$]+)";
    }

    private String getHostFromConnectionString(String input) {
        Matcher hostNameMatcher = Pattern.compile(".*?://(?<host>[\\w.]+).*").matcher(input);
        return hostNameMatcher.matches() ? hostNameMatcher.group("host") : "";
    }
}

