/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.assessment.resources;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.dSeries.assessment.resources.ResourceData;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ResourceDataExtractor {
    private final Map<String, InputStream> resourceData;

    public ResourceDataExtractor(Map<String, InputStream> resourceData) {
        this.resourceData = resourceData;
    }

    public Collection<ResourceData> getResources() {
        return this.resourceData.values().stream().map(inputStream -> {
            XmlElement xml = XmlLoader.from((InputStream)inputStream);
            String maxAvailability = this.getAttributeValue(xml, "max_availability");
            String name = this.getAttributeValue(xml, "ResourceName");
            String description = this.getAttributeValue(xml, "ResourceDescription");
            return new ResourceData(name, maxAvailability, description);
        }).collect(Collectors.toList());
    }

    private String getAttributeValue(XmlElement xml, String attribute) {
        XmlElement xmlElement = Optional.ofNullable(xml.getFirstChildElementByName(attribute)).orElseGet(() -> xml.getFirstChildElementByName("res:" + attribute));
        return Optional.ofNullable(xmlElement).map(XmlElement::getText).orElse("");
    }
}

