/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.as400;

import com.bmc.ctmconvert.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ParametersAndOthersConvertor {
    private String othersElementValue;
    private String parametersElementValue;
    private static final Pattern OTHERS_REGEX = Pattern.compile("(.+?)\\((.+?)\\)");
    private static final Pattern PARAM_REGEX = Pattern.compile("[^ ']+|'(([^']|'')+)'");
    private int paramIndex = 1;

    public ParametersAndOthersConvertor(String otherElementString, String parametersElementString) {
        this.othersElementValue = otherElementString;
        this.parametersElementValue = parametersElementString;
    }

    public Map<String, String> convertOthers() {
        List<Pair<String, String>> othersAsVariables = this.turnOthersToVariables();
        return othersAsVariables.stream().collect(Collectors.toMap(s -> this.getOthersName((String)s.getKey()), s -> ((String)s.getValue()).toUpperCase()));
    }

    private String getOthersName(String name) {
        return "%%OS400-" + name.toUpperCase();
    }

    private List<Pair<String, String>> turnOthersToVariables() {
        Matcher matches = OTHERS_REGEX.matcher(this.othersElementValue);
        ArrayList<Pair<String, String>> othersAsVariables = new ArrayList<Pair<String, String>>();
        while (matches.find()) {
            String name = matches.group(1).trim();
            String value = matches.group(2).trim();
            if (name.isEmpty() || value.isEmpty()) continue;
            othersAsVariables.add((Pair<String, String>)new Pair((Object)name, (Object)value));
        }
        return othersAsVariables;
    }

    public Map<String, String> convertParameters() {
        List<String> parameters = this.getParametersList();
        return parameters.stream().collect(Collectors.toMap(s -> this.getParametersName(), s -> this.convertParametersValue((String)s)));
    }

    private String getParametersName() {
        return String.format("%%%%OS400-PARM%d", this.paramIndex++);
    }

    private String convertParametersValue(String parameterValue) {
        if (StringUtils.isNumeric((CharSequence)parameterValue)) {
            return "%%DEC" + parameterValue;
        }
        if (StringUtils.isBlank((CharSequence)parameterValue)) {
            return String.format("*BLANK%d", parameterValue.length());
        }
        return parameterValue;
    }

    private List<String> getParametersList() {
        ArrayList<String> paramatersList = new ArrayList<String>();
        Matcher matches = PARAM_REGEX.matcher(this.parametersElementValue);
        while (matches.find()) {
            paramatersList.add(this.fixParameter(matches.toMatchResult()));
        }
        paramatersList = paramatersList.stream().map(s -> {
            s = s.replace("''", "'");
            return s;
        }).collect(Collectors.toList());
        return paramatersList;
    }

    private String fixParameter(MatchResult matchResult) {
        return matchResult.group(1) != null ? matchResult.group(1) : matchResult.group(0).toUpperCase();
    }
}

