/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.as400;

import com.bmc.ctmconvert.common.draftwriter.VersionControl;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.predicates.ComparablePredicate;
import com.bmc.ctmconvert.dSeries.DSeriesJob;
import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import com.bmc.ctmconvert.dSeries.as400.ParametersAndOthersConvertor;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;

public class AS400Convertor {
    private DSeriesJob dSeriesJob;

    public AS400Convertor(DSeriesJob dSeriesJob) {
        this.dSeriesJob = dSeriesJob;
    }

    public void convert() {
        this.addDefaultAttributes();
        this.addAttributes();
        this.addVariables();
    }

    private void addDefaultAttributes() {
        this.dSeriesJob.addAttribute("TASKTYPE", "Job");
        this.dSeriesJob.addAttribute("APPL_TYPE", "OS400");
        this.dSeriesJob.addAttribute("APPL_VER", "*ALL");
        this.dSeriesJob.addAttribute("CM_VER", VersionControl.getcurrentFullVersion());
        this.dSeriesJob.addAttribute("APPL_FORM", "OS/400 Full");
    }

    private void addVariables() {
        ParametersAndOthersConvertor convertor = new ParametersAndOthersConvertor(this.getElementValueByElementTag("others"), this.getElementValueByElementTag("param"));
        this.dSeriesJob.addAllAutoEdits(convertor.convertOthers());
        this.dSeriesJob.addAllAutoEdits(convertor.convertParameters());
        this.dSeriesJob.addAutoEdits("%%OS400-JOB_OWNER", this.getElementValueByElementTag("user"));
        this.dSeriesJob.addAutoEdits("%%OS400-JOB_NAME", this.getElementValueByElementTag("jobname"));
        this.addVariablesIfExist("libl", "%%OS400-INLLIBL");
        this.addVariablesIfExist("jobq", "%%OS400-JOBQ");
        this.addVariablesIfExist("jobd", "%%OS400-JOBD");
        this.addCmdOrProgVariables();
    }

    private void addCmdOrProgVariables() {
        if (!this.isOS400Command()) {
            Pair<String, String> libAndProgram = this.getLibAndProgram();
            this.dSeriesJob.addAutoEdits("%%OS400-MEM_LIB", (String)libAndProgram.getKey());
            this.dSeriesJob.addAutoEdits("%%OS400-MEM_NAME", (String)libAndProgram.getValue());
        } else {
            this.dSeriesJob.addAutoEdits(String.format("%%%%OS400-CMDLINE%s", 1), this.getElementValueByElementTag("cmdname"));
        }
        this.dSeriesJob.addAutoEdits("%%OS400-OBJTYP", !this.isOS400Command() ? "*PGM" : "*CMDLINE");
    }

    private void addVariablesIfExist(String dSeriesElementName, String ctmVarName) {
        String elementValue = this.getElementValueByElementTag(dSeriesElementName);
        if (!elementValue.isEmpty()) {
            this.dSeriesJob.addAutoEdits(ctmVarName, elementValue);
        }
    }

    private void addAttributes() {
        this.dSeriesJob.addAttribute("OWNER", this.getElementValueByElementTag("user"));
        this.dSeriesJob.addAttribute("JOBNAME", this.getElementValueByElementTag("jobname"));
        String nodeId = this.getElementValueByElementTag("agent");
        String validatedNodeId = FieldValidation.instance().validateAndReturnFixedValue("NODEID", nodeId, true, "agent", this.dSeriesJob.getJobName(), this.dSeriesJob.getMessages());
        this.dSeriesJob.addAttribute("NODEID", validatedNodeId);
        if (!this.isOS400Command()) {
            Pair<String, String> libAndProgram = this.getLibAndProgram();
            this.dSeriesJob.addAttribute("MEMLIB", (String)libAndProgram.getKey());
            this.dSeriesJob.addAttribute("MEMNAME", (String)libAndProgram.getValue());
        }
    }

    private boolean isOS400Command() {
        return !this.getElementValueByElementTag("cmdname").isEmpty();
    }

    private String getElementValueByElementTag(final String elementTag) {
        XmlElement rootElement = this.dSeriesJob.getRootElement();
        List matchingElments = rootElement.filterAndReturnXmlElement(new ComparablePredicate(this){

            public boolean testImpl(Element subjectElement) {
                return DseriesGlobals.elemntNameMatch(subjectElement, elementTag);
            }
        });
        return matchingElments.stream().findFirst().map(e -> e.getText()).orElse("");
    }

    private Pair<String, String> getLibAndProgram() {
        String lib;
        String clpPath = this.getElementValueByElementTag("clpname");
        String[] splitPath = clpPath.split("/");
        String program = splitPath[splitPath.length - 1];
        lib = clpPath.contains("/") ? String.join((CharSequence)"/", Arrays.copyOfRange(splitPath, 0, splitPath.length - 1)) : ((lib = this.getElementValueByElementTag("as400lib")).isEmpty() ? "*LIBL" : lib);
        return new Pair((Object)lib, (Object)program);
    }
}

