/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.dSeries.DSeriesJob;
import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import com.bmc.ctmconvert.shouts.ShoutBuilder;
import com.bmc.ctmconvert.shouts.ShoutExecTimeBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.w3c.dom.Node;

public class PrematureAndOverdueAlertsHandler {
    public static final String MAX_TIME_SHOUT_MESSAGE = "Submission of job %%JOBNAME in Application %%SCHEDTAB long running %%RUNCOUNT odate %%ODATE Sev SEVERITY NODEALIAS:%%NODEID OID:%%ORDERID";
    public static final String MIN_TIME_SHOUT_MESSAGE = "Submission of job %%JOBNAME in Application %%SCHEDTAB short running %%RUNCOUNT odate %%ODATE Sev SEVERITY NODEALIAS:%%NODEID OID:%%ORDERID";
    private final DSeriesJob dSeriesJob;

    public PrematureAndOverdueAlertsHandler(DSeriesJob dSeriesJob) {
        this.dSeriesJob = dSeriesJob;
    }

    public List<Properties> handle(List<Properties> shouts) {
        shouts.addAll(this.getShoutsFromMonitorStatesOverduePremendInJob());
        return shouts;
    }

    private Optional<Properties> createShout(String time, String shoutMessage, ShoutExecTimeBuilder.Measure sign) {
        return this.getTime(time).map(t -> new ShoutExecTimeBuilder().addWhen(ShoutExecTimeBuilder.createJobExecTime((ShoutExecTimeBuilder.Measure)sign, (int)t, (ShoutExecTimeBuilder.Unit)ShoutExecTimeBuilder.Unit.MINUTE)).addMessage(shoutMessage).addDestination(ShoutBuilder.EM).addUrgency(ShoutBuilder.Urgency.REGULAR).build());
    }

    private Optional<String> getTimeValue(String time) {
        return this.getMaxMinSection().flatMap(maxMin -> maxMin.getAllDecnedElementByMultipleName(new String[]{time, "app:" + time}).stream().findFirst()).map(XmlElement::getText);
    }

    private Optional<XmlElement> getMaxMinSection() {
        return this.dSeriesJob.getRootElement().getAllDecnedElementByMultipleName(new String[]{"max_min", "app:max_min"}).stream().findFirst();
    }

    private List<Properties> getShoutsFromMonitorStatesOverduePremendInJob() {
        if (this.dSeriesJob.isJob()) {
            return this.convertMonitorStatesOverduePremendToShouts();
        }
        return Collections.emptyList();
    }

    private List<Properties> convertMonitorStatesOverduePremendToShouts() {
        ArrayList<Properties> shouts = new ArrayList<Properties>();
        if (this.jobHasMonitorStateOverdue()) {
            this.getShoutFromMonitorStateOverdue().ifPresent(shouts::add);
        }
        if (this.jobHasMonitorStatePremend()) {
            this.getShoutFromMonitorStatePremend().ifPresent(shouts::add);
        }
        return shouts;
    }

    private boolean jobHasMonitorStatePremend() {
        return this.jobHasMonitorState("PREMEND");
    }

    private boolean jobHasMonitorStateOverdue() {
        return this.jobHasMonitorState("OVERDUE");
    }

    private Optional<Properties> getShoutFromMonitorStateOverdue() {
        return this.getShoutFromMonitorState("max_time", MAX_TIME_SHOUT_MESSAGE, ShoutExecTimeBuilder.Measure.GREATER_THAN);
    }

    private boolean applicationHasMonitorState(String monitorState) {
        Node monitorStatesNode = this.dSeriesJob.getDefault("alert_notifylist").flatMap(x -> DseriesGlobals.findChildNodeDFS(x, "alert_notify")).flatMap(x -> DseriesGlobals.findChildNodeDFS(x, "monitor_states")).orElse(null);
        return this.hasMonitorState(monitorStatesNode, monitorState);
    }

    private boolean jobHasMonitorState(String monitorState) {
        Node monitorStatesNode = DseriesGlobals.findChildNodeDFS(this.dSeriesJob.getOriginalNode(), "monitor_states", null, null);
        return this.hasMonitorState(monitorStatesNode, monitorState) || this.applicationHasMonitorState(monitorState);
    }

    private boolean hasMonitorState(Node monitorStatesNode, String monitorState) {
        return DseriesGlobals.getChildValues(monitorStatesNode, "monitor_state").stream().map(v -> this.dSeriesJob.resolveStrings((String)v, "monitor state")).anyMatch(monitorState::equals);
    }

    private Optional<Properties> getShoutFromMonitorState(String time, String message, ShoutExecTimeBuilder.Measure measure) {
        Optional<String> timeValue = this.getTimeValue(time);
        return timeValue.flatMap(t -> this.createShout((String)t, message, measure));
    }

    private Optional<Integer> getTime(String timeString) {
        if (!GlobalFunctions.isNumber((String)timeString)) {
            this.dSeriesJob.addMessage("WRN16016", this.dSeriesJob.getOriginalJobName(), this.dSeriesJob.getJobName(), timeString);
            return Optional.empty();
        }
        int timeValue = Integer.parseInt(timeString);
        if (timeValue > 999) {
            this.dSeriesJob.addMessage("WRN16015", this.dSeriesJob.getOriginalJobName(), this.dSeriesJob.getJobName(), timeString);
            return Optional.of(999);
        }
        return Optional.of(timeValue);
    }

    private Optional<Properties> getShoutFromMonitorStatePremend() {
        return this.getShoutFromMonitorState("min_time", MIN_TIME_SHOUT_MESSAGE, ShoutExecTimeBuilder.Measure.LESS_THAN);
    }
}

