/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.integration_factory.wrapper.PeopleSoftWrapper;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.dSeries.DSeriesJob;
import java.util.Optional;

public class PeopleSoftHandler {
    private final PeopleSoftWrapper wrapper;
    private final XmlElement jobXml;
    private final DSeriesJob dSeriesJob;

    public PeopleSoftHandler(DSeriesJob dSeriesJob) {
        this.dSeriesJob = dSeriesJob;
        this.wrapper = new PeopleSoftWrapper((SchedEntity)dSeriesJob);
        this.jobXml = Optional.ofNullable(dSeriesJob.getRootElement()).orElse(XmlElement.nullXmlElement);
    }

    public void convert() {
        this.wrapper.withUserID("DEFAULT_RUN_AS").withRunControlId(this.getRunControlIdFrom(this.jobXml)).withJobName(this.getJobNameFrom(this.jobXml)).withServer(this.getServerNameFrom(this.jobXml)).withProcessType(this.getProcessTypeFrom(this.jobXml)).withConnectionProfile(this.getConnectionProfileNameFrom(this.jobXml)).convert();
    }

    private String getConnectionProfileNameFrom(XmlElement jobXml) {
        return Optional.ofNullable(jobXml.getValueOfFirstChildElementByName("agent")).map(x -> this.dSeriesJob.resolveStrings((String)x, "connection profile")).orElse(null);
    }

    private String getProcessTypeFrom(XmlElement jobXml) {
        return jobXml.getValueOfFirstChildElementByName("processtype");
    }

    private String getServerNameFrom(XmlElement jobXml) {
        return jobXml.getValueOfFirstChildElementByName("servername");
    }

    private String getJobNameFrom(XmlElement jobXml) {
        return jobXml.getValueOfFirstChildElementByName("processname");
    }

    private String getRunControlIdFrom(XmlElement jobXml) {
        return jobXml.getValueOfFirstChildElementByName("runcntlid");
    }
}

