/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.dSeries.DseriesDefs;
import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import com.bmc.ctmconvert.dSeries.file_monitor.EventItem;
import com.bmc.ctmconvert.dSeries.scheduling.EventScheduling;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class EventHandler {
    private final DseriesDefs dseriesDefs;
    private final LinkedHashMap<String, String> eventToAppMap;
    private final Map<String, List<EventScheduling.Scheduling>> eventSchedMap;
    private HashMap<String, String> eventCalendarMap;
    private final AttrHolderList topLevel;
    private final DocumentBuilder db;

    public EventHandler(DseriesDefs dseriesDefs) {
        this.dseriesDefs = dseriesDefs;
        this.eventToAppMap = new LinkedHashMap();
        this.eventSchedMap = new HashMap<String, List<EventScheduling.Scheduling>>();
        this.topLevel = new AttrHolderList();
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            this.db = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    EventItem handleEvent(String eventXmlFileName, InputStream eventInputStream) {
        try {
            Document evtDoc = this.db.parse(eventInputStream);
            this.mapEvtToToplevel(eventXmlFileName, evtDoc);
            return new EventItem(this.getEventName(evtDoc).orElse(""), evtDoc);
        }
        catch (IOException | SAXException e) {
            ConversionLogger.getLogger().info("Failed to load file: " + eventXmlFileName + "\n" + e.getMessage());
            return EventItem.empty();
        }
    }

    private void mapEvtToToplevel(String eventXmlFileName, Document evtDoc) {
        Optional<String> evtNameOpt = this.getEventName(evtDoc);
        if (evtNameOpt.isPresent()) {
            String evtName = evtNameOpt.get();
            String[] values = new String[]{eventXmlFileName, evtName, "appl", ""};
            DseriesDefs.DseriesAttrHolder toAdd = new DseriesDefs.DseriesAttrHolder(values, evtName);
            HashMap<String, String> filterDetails = new HashMap<String, String>();
            filterDetails.put("Application Name", evtName);
            if (this.dseriesDefs.getRules().getFilterHandler().isFilter(filterDetails)) {
                this.addTopLevel((IAttrHolder)toAdd, evtDoc);
            }
            this.mapEventToApplication(evtDoc, evtName);
            this.handleSchedElement(evtDoc, evtName);
            this.handleEventCalendar(evtDoc, evtName);
        }
    }

    private void addTopLevel(IAttrHolder toAdd, Document evtDoc) {
        if (this.isUniqueFileMonitoringEvent(toAdd, evtDoc)) {
            this.topLevel.add((Object)toAdd);
        }
    }

    private boolean isUniqueFileMonitoringEvent(IAttrHolder toAdd, Document evtDoc) {
        if (this.isFileMonitoringEvent(evtDoc)) {
            Predicate<IAttrHolder> notInTopLevel = attr -> this.topLevel.stream().noneMatch(topLevelItem -> topLevelItem.getAttr("Name").equals(attr.getAttr("Name")));
            return notInTopLevel.test(toAdd);
        }
        return true;
    }

    private void mapEventToApplication(Document evtDoc, String evtName) {
        Optional<Node> appNode = DseriesGlobals.findChildNodeDFS(evtDoc, "runApplication");
        String appName = appNode.or(() -> DseriesGlobals.findChildNodeDFS(evtDoc, "invoketarget")).map(Node::getTextContent).orElse(null);
        this.eventToAppMap.put(evtName, appName);
    }

    private void handleSchedElement(Document event, String eventName) {
        XmlElement xml = XmlElement.ofNullable((Element)event.getDocumentElement());
        List<String> scheduleElements = xml.getAllDecnedElementByMultipleName(new String[]{"even:scheduleelement", "scheduleelement"}).stream().map(XmlElement::getText).map(String::trim).collect(Collectors.toList());
        boolean isInActiveOnly = EventHandler.getIsInActiveOnly(xml);
        this.eventSchedMap.put(eventName, new EventScheduling(scheduleElements, isInActiveOnly).parse());
    }

    private static boolean getIsInActiveOnly(XmlElement xml) {
        return xml.getAllDecnedElementByMultipleName(new String[]{"even:inactiveonly", "inactiveonly"}).stream().map(XmlElement::getText).map(String::trim).findFirst().filter(s -> s.equalsIgnoreCase("true")).isPresent();
    }

    private void handleEventCalendar(Document evtDoc, String evtName) {
        Node calendarNameNode = DseriesGlobals.findChildNodeDFS(evtDoc, "calendar", null, null);
        if (calendarNameNode != null) {
            String calendarName;
            Node tmpNode = DseriesGlobals.findChildNodeDFS(calendarNameNode, "name", null, null);
            if (tmpNode != null) {
                calendarNameNode = tmpNode;
            }
            if ((calendarName = calendarNameNode.getTextContent()) != null && !calendarName.isEmpty()) {
                if (this.eventCalendarMap == null) {
                    this.eventCalendarMap = new HashMap();
                }
                this.eventCalendarMap.put(evtName, calendarName.toUpperCase());
            }
        }
    }

    private Optional<String> getEventName(Document evtDoc) {
        return this.getFileMonitoringEventName(evtDoc).or(this.getRegularEventName(evtDoc)).map(Node::getTextContent).map(EventHandler::removeEventNamePrefix);
    }

    private Supplier<Optional<Node>> getRegularEventName(Document evtDoc) {
        return () -> DseriesGlobals.findChildNodeDFS(evtDoc, "name");
    }

    private Optional<Node> getFileMonitoringEventName(Document evtDoc) {
        if (this.isFileMonitoringEvent(evtDoc)) {
            return DseriesGlobals.findChildNodeDFS(evtDoc, "runApplication");
        }
        return Optional.empty();
    }

    private boolean isFileMonitoringEvent(Document evtDoc) {
        return DseriesGlobals.findChildNodeDFS(evtDoc, "filemonitoring").isPresent();
    }

    public static String removeEventNamePrefix(String name) {
        return name.replaceFirst("^.*\\.", "");
    }

    public Optional<String> getAppByEventName(String evntName) {
        return Optional.ofNullable(this.eventToAppMap.get(evntName));
    }

    public List<EventScheduling.Scheduling> getSchedBYEvent(String appName) {
        return this.eventSchedMap.get(appName);
    }

    public Optional<String> getCalendar(String applicationName) {
        Optional<String> ret = Optional.empty();
        if (this.eventCalendarMap != null && this.eventCalendarMap.containsKey(applicationName)) {
            ret = Optional.of(this.eventCalendarMap.get(applicationName));
        }
        return ret;
    }

    public AttrHolderList getTopLevel() {
        return this.topLevel;
    }

    public List<String> getEventsOfApp(String applName) {
        ArrayList<String> eventsList = new ArrayList<String>();
        this.eventToAppMap.keySet().stream().filter(event -> this.eventToAppMap.get(event) != null && this.eventToAppMap.get(event).equals(applName)).forEach(eventsList::add);
        return eventsList;
    }
}

