/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DseriesData {
    private final LinkedHashMap<String, Supplier<InputStream>> applSuppliers;
    private final LinkedHashMap<String, Supplier<InputStream>> evtSuppliers;
    private final LinkedHashMap<String, Supplier<InputStream>> calSuppliers;
    private final LinkedHashMap<String, Supplier<InputStream>> resourceSuppliers;
    private final List<Supplier<InputStream>> varXmls = new ArrayList<Supplier<InputStream>>();

    public DseriesData() {
        this.applSuppliers = new LinkedHashMap();
        this.evtSuppliers = new LinkedHashMap();
        this.calSuppliers = new LinkedHashMap();
        this.resourceSuppliers = new LinkedHashMap();
    }

    public void addAppXml(String path, Supplier<InputStream> inputStreamSupplier) {
        this.applSuppliers.put(path, inputStreamSupplier);
    }

    public Map<String, InputStream> getApplXml() {
        return this.getXmlFor(this.applSuppliers);
    }

    public void addEvtXml(String path, Supplier<InputStream> inputStreamSupplier) {
        this.evtSuppliers.put(path, inputStreamSupplier);
    }

    public Map<String, InputStream> getEvtXml() {
        return this.getXmlFor(this.evtSuppliers);
    }

    private Map<String, InputStream> getXmlFor(LinkedHashMap<String, Supplier<InputStream>> evtSuppliers) {
        LinkedHashMap<String, InputStream> ret = new LinkedHashMap<String, InputStream>();
        for (Map.Entry<String, Supplier<InputStream>> supplier : evtSuppliers.entrySet()) {
            Supplier<InputStream> streamSupplier = supplier.getValue();
            ret.put(supplier.getKey(), streamSupplier.get());
        }
        return ret;
    }

    public void addCalXml(String path, Supplier<InputStream> inputStreamSupplier) {
        this.calSuppliers.put(path, inputStreamSupplier);
    }

    public Map<String, InputStream> getCalXml() {
        return this.getXmlFor(this.calSuppliers);
    }

    public Map<String, InputStream> getResourceXml() {
        return this.getXmlFor(this.resourceSuppliers);
    }

    public void addResourceXml(String path, Supplier<InputStream> inputStreamSupplier) {
        this.resourceSuppliers.put(path, inputStreamSupplier);
    }

    public static Path getInputDir(DseriesGlobals.XML_TYPE inputType, Path baseDir) {
        return switch (inputType) {
            default -> throw new MatchException(null, null);
            case DseriesGlobals.XML_TYPE.APP -> baseDir.resolve("Applications");
            case DseriesGlobals.XML_TYPE.CAL -> baseDir.resolve("Calendars");
            case DseriesGlobals.XML_TYPE.EVT -> baseDir.resolve("Events");
            case DseriesGlobals.XML_TYPE.VAR -> baseDir.resolve("Variables");
            case DseriesGlobals.XML_TYPE.RESOURCE -> baseDir.resolve("Resources");
        };
    }

    public List<InputStream> getVarXml() {
        return this.varXmls.stream().map(Supplier::get).collect(Collectors.toList());
    }

    public void addVarXml(Supplier<InputStream> inputStreamSupplier) {
        this.varXmls.add(inputStreamSupplier);
    }
}

