/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.dSeries.DSeriesJob;
import com.bmc.ctmconvert.dSeries.DseriesDefs;
import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import com.bmc.ctmconvert.dSeries.ResolvedString;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DependenciesConvertor {
    public static final String EXTERNAL_CONDITION_PREFIX = "$EXTERNAL_";
    public static final String JOB_A_TO_JOB_B_FORMAT = "%s-TO-%s";
    public static final String JOB_ENDED_STATUS_FORMAT = "%s-ENDED%s";
    public static final String SEPARATOR = "_";
    private static DependenciesConvertor instance;
    private static LinkedHashMap<String, LinkedHashSet<Properties>> inConds;
    private static LinkedHashMap<String, LinkedHashSet<Properties>> outConds;
    private static LinkedHashMap<String, LinkedHashMap<Properties, List<Properties>>> onDoStatements;
    private static HashMap<String, LinkedHashSet<String>> externalJobSuccessor;
    private static HashMap<String, LinkedHashSet<String>> externalJobPredecessor;
    private static final String mapKeyFormat = "%s-/-%s";
    private static DseriesDefs dseriesDefs;

    public static DseriesDefs getDseriesDefs() {
        return dseriesDefs;
    }

    private DependenciesConvertor() {
        inConds = new LinkedHashMap();
        outConds = new LinkedHashMap();
        onDoStatements = new LinkedHashMap();
        externalJobSuccessor = new HashMap();
        externalJobPredecessor = new HashMap();
    }

    public static DependenciesConvertor instance(DseriesDefs dseriesDefs) {
        DependenciesConvertor.dseriesDefs = dseriesDefs;
        if (instance == null) {
            instance = new DependenciesConvertor();
        }
        return instance;
    }

    private String generateMapKey(String jobname, String application) {
        return String.format(mapKeyFormat, application, jobname);
    }

    public void registerConditions(DSeriesJob registringJob, Node conditionList) {
        Node conditionNode = DseriesGlobals.findChildNodeDFS(conditionList, "relconditionlist", null, null);
        if (conditionNode != null) {
            conditionNode = conditionNode.getFirstChild();
        }
        while (conditionNode != null) {
            if (DseriesGlobals.elemntNameMatch(conditionNode, "relcondition")) {
                String successorName = null;
                String condStatus = null;
                for (Node condElement = conditionNode.getFirstChild(); condElement != null; condElement = condElement.getNextSibling()) {
                    if (condElement.getNodeType() != 1) continue;
                    if (DseriesGlobals.elemntNameMatch(condElement, "successorname")) {
                        successorName = registringJob.resolveStrings(condElement.getTextContent(), "successor job definition");
                        continue;
                    }
                    if (DseriesGlobals.elemntNameMatch(condElement, "condition")) {
                        condStatus = condElement.getTextContent();
                        continue;
                    }
                    Reporter.addMessage(registringJob.getMessages(), (String)"WRN16001", (String)registringJob.getJobFullPathName(), (String[])new String[]{condElement.getNodeName(), condElement.getParentNode().getNodeName()});
                }
                if (successorName != null && !successorName.isEmpty() && condStatus != null && !condStatus.isEmpty()) {
                    String eventName = this.getEventName(registringJob);
                    this.mapConditions(eventName, this.createPredecessorName(registringJob, eventName), this.jobPathOf(eventName, successorName), condStatus);
                }
            }
            conditionNode = conditionNode.getNextSibling();
        }
    }

    private String createPredecessorName(DSeriesJob registringJob, String eventName) {
        String predecessorName = this.isExternalJob(registringJob) ? this.jobPathOf(EXTERNAL_CONDITION_PREFIX, this.removeVariableFrom(registringJob.getOriginalJobName()), "") : this.jobPathOf(eventName, registringJob.getOriginalJobName());
        return predecessorName;
    }

    private String removeVariableFrom(String originalJobName) {
        return originalJobName.replaceAll("_%%.*$", "");
    }

    private boolean isExternalJob(DSeriesJob registringJob) {
        return List.of("ext_job", "extmon_job").contains(registringJob.getOrigJobType());
    }

    public String jobPathOf(String eventName, String jobName) {
        return this.jobPathOf(eventName, jobName, SEPARATOR);
    }

    public String jobPathOf(String eventName, String jobName, String separator) {
        return this.takeValueAfterPeriod(eventName) + separator + jobName;
    }

    private String takeValueAfterPeriod(String eventName) {
        return eventName.replaceFirst("^.*\\.", "");
    }

    private String getEventName(DSeriesJob registringJob) {
        return registringJob.getParent() == null ? "TOP_LEVEL" : registringJob.getParent().getEventName();
    }

    private void mapConditions(String eventName, String predecessorName, String successorName, String condStatus) {
        boolean deleteCondition;
        boolean okCond = (condStatus = condStatus.trim().toUpperCase()).equalsIgnoreCase("NORMAL") || condStatus.equalsIgnoreCase("UNCONDITIONAL");
        boolean notOkCond = condStatus.equalsIgnoreCase("ABNORMAL") || condStatus.equalsIgnoreCase("UNCONDITIONAL");
        Matcher completionStatusMatcher = Pattern.compile("(\\d+)-?(\\d*)").matcher(condStatus.replace("\"", ""));
        boolean completionStatusCond = completionStatusMatcher.matches();
        String condStatusStr = "";
        int[] coplitionStatus = new int[]{0};
        if (completionStatusCond) {
            try {
                condStatusStr = "-OK";
                String value = completionStatusMatcher.group(1);
                int coplitionStatusStart = -1;
                if (value != null && !value.isEmpty()) {
                    coplitionStatusStart = Integer.parseInt(value);
                }
                value = completionStatusMatcher.group(2);
                int coplitionStatusEnd = -1;
                if (value != null && !value.isEmpty()) {
                    coplitionStatusEnd = Integer.parseInt(value);
                }
                if (coplitionStatusStart != -1 && coplitionStatusEnd != -1) {
                    if (coplitionStatusStart > coplitionStatusEnd) {
                        coplitionStatusStart -= coplitionStatusEnd;
                        coplitionStatusEnd += coplitionStatusStart;
                        coplitionStatusStart = coplitionStatusEnd - coplitionStatusStart;
                    }
                    coplitionStatus = new int[coplitionStatusEnd - coplitionStatusStart + 1];
                    for (int index = coplitionStatusStart; index <= coplitionStatusEnd; ++index) {
                        coplitionStatus[index - coplitionStatusStart] = index;
                    }
                } else {
                    coplitionStatus = coplitionStatusStart != -1 ? new int[]{coplitionStatusStart} : new int[]{0};
                }
            }
            catch (NumberFormatException e) {
                ConversionLogger.getLogger().info("Coplition status is not in a valid format: " + String.valueOf(coplitionStatus));
            }
        }
        if (okCond && notOkCond) {
            condStatusStr = "";
        } else if (okCond) {
            condStatusStr = "-OK";
        } else if (notOkCond) {
            condStatusStr = "-NOTOK";
        }
        String condName = this.buildConditionName(predecessorName, successorName, condStatusStr);
        Properties inCond = new Properties();
        inCond.setProperty("AND_OR", "AND");
        inCond.setProperty("ODATE", "ODAT");
        inCond.setProperty("NAME", condName);
        if (!inConds.containsKey(this.generateMapKey(successorName, eventName))) {
            inConds.put(this.generateMapKey(successorName, eventName), new LinkedHashSet());
        }
        inConds.get(this.generateMapKey(successorName, eventName)).add(inCond);
        if (okCond) {
            Properties outCond = this.buildOutCondition(condName);
            if (!outConds.containsKey(this.generateMapKey(predecessorName, eventName))) {
                outConds.put(this.generateMapKey(predecessorName, eventName), new LinkedHashSet());
            }
            outConds.get(this.generateMapKey(predecessorName, eventName)).add(outCond);
        }
        if (notOkCond || completionStatusCond) {
            for (int status : coplitionStatus) {
                Properties onStmt = new Properties();
                onStmt.setProperty("STMT", "*");
                if (notOkCond) {
                    onStmt.setProperty("CODE", "NOTOK");
                } else {
                    onStmt.setProperty("CODE", "COMPSTAT EQ " + status);
                }
                Properties doStmt = new Properties();
                doStmt.setProperty("NAME", condName);
                doStmt.setProperty("ACTION", "DOCOND");
                doStmt.setProperty("ODATE", "ODAT");
                doStmt.setProperty("SIGN", "ADD");
                if (!onDoStatements.containsKey(this.generateMapKey(predecessorName, eventName))) {
                    onDoStatements.put(this.generateMapKey(predecessorName, eventName), new LinkedHashMap());
                }
                if (!onDoStatements.get(this.generateMapKey(predecessorName, eventName)).containsKey(onStmt)) {
                    onDoStatements.get(this.generateMapKey(predecessorName, eventName)).put(onStmt, new ArrayList());
                }
                onDoStatements.get(this.generateMapKey(predecessorName, eventName)).get(onStmt).add(doStmt);
            }
        }
        if (!this.isJobAOK() && (deleteCondition = dseriesDefs.getRules().getBooleanRule("dSeries rules", new String[]{"CLEAN_UP_CONDITIONS"}).booleanValue())) {
            Properties outCondDel = new Properties();
            outCondDel.setProperty("SIGN", "DEL");
            outCondDel.setProperty("ODATE", "ODAT");
            outCondDel.setProperty("NAME", condName);
            if (!outConds.containsKey(this.generateMapKey(successorName, eventName))) {
                outConds.put(this.generateMapKey(successorName, eventName), new LinkedHashSet());
            }
            outConds.get(this.generateMapKey(successorName, eventName)).add(outCondDel);
        }
    }

    public Properties buildOutCondition(String condName) {
        Properties outCond = new Properties();
        outCond.setProperty("NAME", condName);
        outCond.setProperty("SIGN", "ADD");
        outCond.setProperty("ODATE", "ODAT");
        return outCond;
    }

    private boolean isJobAOK() {
        return dseriesDefs.getRules().getStringRule("dSeries rules", new String[]{"CONDITION_NAME"}).equals("JOBA_OK");
    }

    public List<Properties> getInconds(DSeriesJob job) {
        String eventName = this.getEventName(job);
        DependenciesConvertor.instance(DependenciesConvertor.getDseriesDefs()).getExternalSuccessorInCondition(job, eventName);
        Optional<LinkedHashSet<Properties>> inConditions = Optional.ofNullable(inConds.get(this.generateMapKey(this.jobPathOf(eventName, job.getOriginalJobName()), eventName)));
        return inConditions.map(ArrayList::new).orElse(new ArrayList());
    }

    public List<Properties> getOutconds(DSeriesJob job) {
        String eventName = this.getEventName(job);
        DependenciesConvertor.instance(DependenciesConvertor.getDseriesDefs()).getExternalPredecessorOutCondition(job, eventName);
        Optional<LinkedHashSet<Properties>> outConditions = Optional.ofNullable(outConds.get(this.generateMapKey(this.jobPathOf(eventName, job.getOriginalJobName()), eventName)));
        return outConditions.map(ArrayList::new).orElse(new ArrayList());
    }

    public Map<Properties, List<Properties>> getOnDoStatements(DSeriesJob job) {
        String eventName = this.getEventName(job);
        return onDoStatements.get(this.generateMapKey(this.jobPathOf(eventName, job.getOriginalJobName()), eventName));
    }

    private XmlElement getXmlRootElement(InputStream newInputStream) {
        XmlLoader xmlLoader = new XmlLoader();
        try {
            xmlLoader.loadFile(newInputStream);
        }
        catch (IOException | SAXException e) {
            ConversionLogger.getLogger().info(e.getMessage());
            return null;
        }
        return xmlLoader.getXmlElement();
    }

    public void handleExternalJobs(String appxmlFileName, InputStream newInputStream) {
        XmlElement root = this.getXmlRootElement(newInputStream);
        if (root == null) {
            ConversionLogger.getLogger().log(Level.INFO, appxmlFileName);
        } else {
            List externalJobList = root.getDirectchildsElementbyName(new String[]{"app:" + String.valueOf((Object)DseriesGlobals.JOB_TYPES_ENUM.EXT_JOB), DseriesGlobals.JOB_TYPES_ENUM.EXT_JOB.toString()});
            if (!externalJobList.isEmpty()) {
                this.collectExternalJobConditions(root.getAttribute("name"), (ArrayList)externalJobList);
            }
        }
    }

    private void collectExternalJobConditions(String applicationName, ArrayList<XmlElement> externalJobList) {
        for (XmlElement jobExternal : externalJobList) {
            String jobName = this.getJobNameAfterResolving(jobExternal);
            List applidXmlElement = jobExternal.getDirectchildsElementbyName(new String[]{"app:applid", "applid"});
            List successorXmlElementList = jobExternal.getAllDecnedElementByMultipleName(new String[]{"app:successorname", "successorname"});
            if (!applidXmlElement.isEmpty()) {
                for (XmlElement applid : applidXmlElement) {
                    if (applid.getElement() != null) {
                        Object applidName = applid.getElement().getTextContent();
                        if (((String)applidName).startsWith("%(APPL.group)")) {
                            String successorApplication = applicationName.substring(0, applicationName.indexOf(SEPARATOR));
                            applidName = successorApplication + ((String)applidName).substring(((String)applidName).indexOf(SEPARATOR));
                        }
                        List<String> eventsList = dseriesDefs.getEventsOfApp((String)applidName);
                        for (String event : eventsList) {
                            for (XmlElement successorXmlElement : successorXmlElementList) {
                                List<String> refEventsList = dseriesDefs.getEventsOfApp(applicationName);
                                for (String refEvent : refEventsList) {
                                    String successorName = successorXmlElement.getElement().getTextContent();
                                    if (!externalJobPredecessor.containsKey(this.jobPathOf(event, jobName))) {
                                        externalJobPredecessor.put(this.jobPathOf(event, jobName), new LinkedHashSet());
                                    }
                                    externalJobPredecessor.get(this.jobPathOf(event, jobName)).add(this.jobPathOf(refEvent, successorName));
                                    if (!externalJobSuccessor.containsKey(this.jobPathOf(refEvent, successorName))) {
                                        externalJobSuccessor.put(this.jobPathOf(refEvent, successorName), new LinkedHashSet());
                                    }
                                    externalJobSuccessor.get(this.jobPathOf(refEvent, successorName)).add(this.jobPathOf(event, jobName));
                                }
                            }
                        }
                        continue;
                    }
                    ConversionLogger.getLogger().info("Corrupted Data: we have a ext_job with no applid (1)");
                }
                continue;
            }
            ConversionLogger.getLogger().info("Corrupted Data: we have a ext_job with no applid (2)");
        }
    }

    private String getJobNameAfterResolving(XmlElement jobExternal) {
        Object jobName = jobExternal.getAttribute("name");
        String jobQualifier = jobExternal.getAttribute("qualifier");
        if (!jobQualifier.isEmpty()) {
            jobName = (String)jobName + "." + jobQualifier;
        }
        ResolvedString resolvedString = new ResolvedString((String)jobName, new LinkedHashMap<String, String>(), DependenciesConvertor.getDseriesDefs());
        jobName = resolvedString.getResolvedValueImmidiate();
        return jobName;
    }

    public static void destroy() {
        instance = null;
    }

    private String addInCond(String successor, String successorFolder, String condName) {
        String mapKey = this.generateMapKey(successor, successorFolder);
        Properties inCondProp = new Properties();
        inCondProp.setProperty("NAME", condName);
        inCondProp.setProperty("AND_OR", "AND");
        inCondProp.setProperty("ODATE", "ODAT");
        inConds.computeIfAbsent(mapKey, k -> new LinkedHashSet()).add(inCondProp);
        return mapKey;
    }

    private void addOutCond(String predecessor, String predecessorFolder, String condName, String sign) {
        String mapKey = this.generateMapKey(predecessor, predecessorFolder);
        Properties outCondProp = new Properties();
        outCondProp.setProperty("NAME", condName);
        outCondProp.setProperty("SIGN", sign);
        outCondProp.setProperty("ODATE", "ODAT");
        outConds.computeIfAbsent(mapKey, k -> new LinkedHashSet()).add(outCondProp);
    }

    public String buildConditionName(String predecessorName, String successorName, String conditionStatus) {
        String conditionFormat = this.isJobAOK() ? JOB_ENDED_STATUS_FORMAT : JOB_A_TO_JOB_B_FORMAT;
        String formattedCondition = String.format(conditionFormat, predecessorName, this.isJobAOK() ? conditionStatus : successorName);
        return FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", formattedCondition);
    }

    public void getExternalSuccessorInCondition(DSeriesJob job, String parentName) {
        String fullJobName = job.getOriginalJobName();
        String successorKey = this.jobPathOf(parentName, fullJobName);
        if (externalJobSuccessor.containsKey(successorKey)) {
            LinkedHashSet<String> successorList = externalJobSuccessor.get(successorKey);
            for (String successor : successorList) {
                boolean deleteCondition;
                String inCondName = this.buildConditionName(successor, successorKey, "-OK");
                this.addInCond(successorKey, parentName, inCondName);
                boolean jobAOK = this.isJobAOK();
                if (jobAOK || !(deleteCondition = dseriesDefs.getRules().getBooleanRule("dSeries rules", new String[]{"CLEAN_UP_CONDITIONS"}).booleanValue())) continue;
                this.addOutCond(successorKey, parentName, inCondName, "DEL");
            }
        }
    }

    public void getExternalPredecessorOutCondition(DSeriesJob job, String parentName) {
        String fullJobName = job.getOriginalJobName();
        String predecessorKey = this.jobPathOf(parentName, fullJobName);
        if (externalJobPredecessor.containsKey(predecessorKey)) {
            LinkedHashSet<String> predecessorList = externalJobPredecessor.get(predecessorKey);
            for (String predecessor : predecessorList) {
                String outCondName = this.buildConditionName(predecessorKey, predecessor, "-OK");
                this.addOutCond(predecessorKey, parentName, outCondName, "ADD");
            }
        }
    }
}

