/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.dSeries.DSeriesJob;
import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.DoMail;
import com.bmc.ctmconvert.ondo.DoShout;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.UnaryOperator;
import org.w3c.dom.Node;

public class DSeriesRetryHandler {
    public static final String ALERT = "alert";
    private final DSeriesJob job;

    public DSeriesRetryHandler(DSeriesJob dSeriesJob) {
        this.job = dSeriesJob;
        this.getRetryCount().map(this.handleRetryCountGreaterThen99()).ifPresent(retryCount -> {
            this.handleJobAttributesForRetry((Integer)retryCount);
            this.job.addOnDoStmts(this.createOnDoRerunAction());
            this.job.addOnDoStmts(this.getOnWithDos((Integer)retryCount));
        });
    }

    private UnaryOperator<Integer> handleRetryCountGreaterThen99() {
        return retryCount -> {
            if (retryCount > 99) {
                this.job.addMessage("WRN16024", this.job.getJobName(), this.job.getOriginalJobName(), retryCount.toString());
                return 99;
            }
            return retryCount;
        };
    }

    private Map<Properties, List<Properties>> getOnWithDos(Integer retryCount) {
        String incrementedCount = String.valueOf(retryCount + 1);
        OnStatement.OnNumberOfFailures on = OnStatement.createOnNumberOfFailures((String)incrementedCount);
        if (this.hasNotifyEmail()) {
            this.getDoMail().ifPresent(arg_0 -> ((OnStatement.OnNumberOfFailures)on).addDo(arg_0));
        }
        if (this.hasNotifyAlerts()) {
            on.addDo(this.getDoShout(incrementedCount));
        }
        if (this.hasNotifySnmp()) {
            this.getDoShoutSnmp(incrementedCount).ifPresent(arg_0 -> ((OnStatement.OnNumberOfFailures)on).addDo(arg_0));
        }
        if (!on.hasDoStatements()) {
            on.addDo(Do.createDoNotOk());
        }
        HashMap<Properties, List<Properties>> onDo = new HashMap<Properties, List<Properties>>();
        on.accept(onDo::put);
        return onDo;
    }

    private Optional<Do> getDoShoutSnmp(String retryCount) {
        String snmpDestination = this.getSnmpDestination();
        String fixedDestination = FieldValidation.instance().validateAndReturnFixedValue("DEST", snmpDestination);
        if (fixedDestination.length() > 16) {
            fixedDestination = fixedDestination.substring(0, 16);
        }
        if ("".equals(fixedDestination)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getDoShoutWithDestination(retryCount, fixedDestination));
    }

    private Do getDoShoutWithDestination(String retryCount, String destination) {
        DoShout doShout = Do.createDoShout((String)destination);
        doShout.setMessage("Job %%JOBNAME failed to run " + retryCount + " times");
        doShout.setUrgancy("R");
        return doShout;
    }

    private String getSnmpDestination() {
        return this.getTextOfAll(ALERT).stream().findFirst().or(this::getDefaultFromParent).orElse("EM");
    }

    private Optional<String> getDefaultFromParent() {
        return Optional.ofNullable(this.job.getOriginalNode()).map(Node::getParentNode).map(e -> DseriesGlobals.findChildNodeDFS(e, "defaults", null, null)).map(e -> DseriesGlobals.findChildNodeDFS(e, ALERT, null, null)).map(Node::getTextContent);
    }

    private boolean hasNotifySnmp() {
        return "true".equals(this.getRetryAttributeValueOf("last_notify_snmp"));
    }

    private Do getDoShout(String retryCount) {
        return this.getDoShoutWithDestination(retryCount, "EM");
    }

    private boolean hasNotifyAlerts() {
        return "true".equals(this.getRetryAttributeValueOf("last_notify_alerts"));
    }

    private boolean hasNotifyEmail() {
        return "true".equals(this.getRetryAttributeValueOf("last_notify_email"));
    }

    private Optional<DoMail> getDoMail() {
        String emailAddresses = this.getEmailAddresses();
        if (emailAddresses.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(Do.createDoMail((String)this.getEmailAddresses()).setSubject(this.getSubject()).setMessage(this.getMessage()).setUrgancy("R"));
    }

    private String getMessage() {
        String emailText = String.join((CharSequence)"", this.getTextOfAll("emailtext"));
        return FieldValidation.instance().validateAndReturnFixedValue("MAIL_MESSAGE", emailText);
    }

    private List<String> getTextOfAll(String tagName) {
        return this.job.getRootElement().getAllDecnedValuesByMultipleName(new String[]{tagName, "app:" + tagName});
    }

    private String getSubject() {
        String emailSubject = String.join((CharSequence)"", this.getTextOfAll("email_subject"));
        return FieldValidation.instance().validateAndReturnFixedValue("MAIL_SUBJECT", emailSubject);
    }

    private String getEmailAddresses() {
        String mailAddress = String.join((CharSequence)",", this.getTextOfAll("mailaddress"));
        return FieldValidation.instance().validateAndReturnFixedValue("MAIL_DESTINATION", mailAddress);
    }

    private Map<Properties, List<Properties>> createOnDoRerunAction() {
        OnStatement.OnNotOkStatement onOkStatement = OnStatement.createOnNotOkStatement();
        onOkStatement.addDo((Do)Do.createDoRerun());
        HashMap<Properties, List<Properties>> onDo = new HashMap<Properties, List<Properties>>();
        onOkStatement.accept(onDo::put);
        return onDo;
    }

    private void handleJobAttributesForRetry(Integer retryCount) {
        this.job.addAttribute("MAXRERUN", String.valueOf(retryCount));
        this.job.addAttribute("INTERVAL", this.getRetryInterval());
        this.job.addAttribute("CYCLIC", "0");
        this.job.addAttribute("IND_CYCLIC", "E");
    }

    private String getRetryInterval() {
        String retryInterval = this.getRetryAttributeValueOf("retry_interval");
        int number = GlobalFunctions.getNumberFrom((String)retryInterval).orElse(0);
        return String.format("%05dM", number);
    }

    private String getRetryAttributeValueOf(String retryAttribute) {
        return this.getTextOfAll(retryAttribute).stream().findFirst().orElse("0");
    }

    private Optional<Integer> getRetryCount() {
        String retryCount = this.getRetryAttributeValueOf("retry_count");
        if (!"0".equals(retryCount)) {
            return Optional.of(retryCount).flatMap(GlobalFunctions::getNumberFrom);
        }
        return Optional.empty();
    }
}

