/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.sap;

import com.bmc.ctmconvert.applications.ApplicationsDefs;
import com.bmc.ctmconvert.applications.ApplicationsEntitiy;
import com.bmc.ctmconvert.applications.ApplicationsHierarchyTree;
import com.bmc.ctmconvert.applications.ApplicationsJob;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.sap.SAPJob;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SAPDefs
extends ApplicationsDefs {
    private static final int JOBCOUNT_LENGTH = 8;
    protected HashMap<String, LinkedHashSet<Properties>> inConds;
    protected HashMap<String, LinkedHashSet<Properties>> outConds;

    public SAPDefs() {
        this.IdFieldName = "TABLE_NAME";
        HashMap competitorValues = new HashMap();
        String tableName = FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", this.ApplicationRules.getFieldEditor().generateCTMField("TABLE_NAME", competitorValues));
        ApplicationsHierarchyTree.setDefaultFolder((String)tableName);
        ApplicationsHierarchyTree.setFolderOverrideFlag((boolean)true);
        this.createCalendarsFile();
    }

    public void finalize_() {
        ApplicationsHierarchyTree.destroy();
    }

    public void init() throws ConvertorCancelClickException {
        this.createConditionsMap();
        this.handleUnExtractedRecipients();
    }

    private void handleUnExtractedRecipients() {
        ApplicationsEntitiy SAPJobs = (ApplicationsEntitiy)ApplicationsHierarchyTree.instance().getHierarchyTree().getFirstChild();
        for (int i = 0; i < SAPJobs.getChildCount(); ++i) {
            ApplicationsEntitiy hierarchyTree = (ApplicationsEntitiy)SAPJobs.getChildAt(i);
            Element entityData = hierarchyTree.getEntityData();
            NodeList fields = entityData.getElementsByTagName("Field");
            for (int j = 0; j < fields.getLength(); ++j) {
                Element field = (Element)fields.item(j);
                String autoEdit = field.getAttribute("AUTOEDIT");
                String value = field.getAttribute("VALUE");
                if (autoEdit == null || !autoEdit.equalsIgnoreCase("%%SAPR3-RECIP_TYPE") || !value.equalsIgnoreCase("CTM_VALUE_NOT_EXTRACTED")) continue;
                Reporter.addMessage((List)this.messages, (String)"WRN13003", (String)"DEFAULT_FOLDER", (String[])new String[0]);
                return;
            }
        }
    }

    private void createConditionsMap() {
        this.inConds = new HashMap();
        this.outConds = new HashMap();
        ApplicationsEntitiy SAPJobs = (ApplicationsEntitiy)ApplicationsHierarchyTree.instance().getHierarchyTree().getFirstChild();
        for (int i = 0; i < SAPJobs.getChildCount(); ++i) {
            ApplicationsEntitiy hierarchyTree = (ApplicationsEntitiy)SAPJobs.getChildAt(i);
            Element entityData = hierarchyTree.getEntityData();
            NodeList fields = entityData.getElementsByTagName("Field");
            String JOBNAME = "";
            String JOBCOUNT = "";
            String EVENTID = "";
            String EVENTPARM = "";
            for (int j = 0; j < fields.getLength(); ++j) {
                Element field = (Element)fields.item(j);
                String key = field.getAttribute("NAME");
                String value = field.getAttribute("VALUE");
                if (key != null && key.equals("JOBNAME")) {
                    JOBNAME = value;
                    continue;
                }
                if (key != null && key.equals("JOBCOUNT")) {
                    JOBCOUNT = value;
                    continue;
                }
                if (key != null && key.equals("EVENTID")) {
                    EVENTID = value;
                    continue;
                }
                if (key == null || !key.equals("EVENTPARM")) continue;
                EVENTPARM = value;
            }
            if (!EVENTID.equals("SAP_END_OF_JOB")) continue;
            if (EVENTPARM != null && !EVENTPARM.isEmpty()) {
                String predecessorName = this.getPredessorName(EVENTPARM);
                String successorName = String.format("%s#%s", JOBNAME, JOBCOUNT);
                String conditionName = FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", String.format("%s-TO-%s", predecessorName, successorName));
                Properties outCond = new Properties();
                outCond.setProperty("NAME", conditionName);
                outCond.setProperty("SIGN", "ADD");
                outCond.setProperty("ODATE", "ODAT");
                this.addConditionToHash(this.outConds, outCond, predecessorName);
                Properties inCond = new Properties();
                inCond.setProperty("NAME", conditionName);
                inCond.setProperty("AND_OR", "AND");
                inCond.setProperty("ODATE", "ODAT");
                this.addConditionToHash(this.inConds, inCond, successorName);
                continue;
            }
            Reporter.addMessage((List)this.messages, (String)"WRN13002", (String)String.format("%s#%s", JOBNAME, JOBCOUNT), (String[])new String[]{EVENTPARM, EVENTID});
        }
    }

    private String getPredessorName(String EVENTPARM) {
        String predecessorName = "";
        try {
            if (EVENTPARM != null) {
                String jobName_EVENTPARM = EVENTPARM.substring(0, EVENTPARM.length() - 8).trim();
                String jobCount_EVENTPARM = EVENTPARM.substring(EVENTPARM.length() - 8);
                predecessorName = String.format("%s#%s", jobName_EVENTPARM, jobCount_EVENTPARM);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        return predecessorName;
    }

    private void addConditionToHash(HashMap<String, LinkedHashSet<Properties>> hashMap, Properties condition, String jobname) {
        LinkedHashSet<Properties> list = hashMap.get(jobname);
        if (list == null) {
            list = new LinkedHashSet();
        }
        list.add(condition);
        hashMap.put(jobname, list);
    }

    public List<Properties> getJobInconds(SchedEntity job) {
        LinkedHashSet<Properties> inCondsForJob = this.inConds.get(((SAPJob)job).getJobId());
        if (inCondsForJob != null) {
            return new ArrayList<Properties>(inCondsForJob);
        }
        return null;
    }

    public List<Properties> getJobOutconds(SchedEntity job) {
        LinkedHashSet<Properties> outCondsForJob = this.outConds.get(((SAPJob)job).getJobId());
        if (outCondsForJob != null) {
            return new ArrayList<Properties>(outCondsForJob);
        }
        return null;
    }

    protected ApplicationsJob getApplicationsJob(ApplicationsEntitiy child) {
        return new SAPJob(child, SchedEntity.TYPE.SMART_TABLE, this);
    }

    public Map<String, LinkedHashSet<Properties>> getInConds() {
        return new HashMap<String, LinkedHashSet<Properties>>(this.inConds);
    }

    public Map<String, LinkedHashSet<Properties>> getOutConds() {
        return new HashMap<String, LinkedHashSet<Properties>>(this.outConds);
    }
}

