/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.cron;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.cron.CronGlobals;
import com.bmc.ctmconvert.rules.RuleManager;
import java.util.HashMap;
import java.util.Properties;

public class CronRbcGenerator {
    private static CronRbcGenerator instance;
    private HashMap<String, Properties> rbcs = new HashMap();
    private static final String intInListPatternFormat = "^(.*,)?(0*)?%d(,.*)?$";
    private int rbcCount = 0;

    public static CronRbcGenerator instance() {
        return instance == null ? (instance = new CronRbcGenerator()) : instance;
    }

    public static void destroy() {
        instance = null;
    }

    private CronRbcGenerator() {
    }

    public Properties getRbc(String months, String monthDays, String weekDays) {
        if (months.isEmpty() || monthDays.isEmpty() || weekDays.isEmpty()) {
            return null;
        }
        String rbcId = String.format("%s=@=%s=@=%s", months, monthDays, weekDays);
        if (!this.rbcs.containsKey(rbcId)) {
            Properties newRbc = new Properties();
            newRbc.setProperty("NAME", this.generate_name(rbcId));
            newRbc.setProperty("DAYS_AND_OR", "OR");
            this.handleMonths(newRbc, months);
            if (!weekDays.equals("*")) {
                this.handleWeekDays(newRbc, weekDays);
            }
            if (!monthDays.equals("*")) {
                this.handleMonthDays(newRbc, monthDays);
            }
            if (monthDays.equals("*") && weekDays.equals("*")) {
                newRbc.setProperty("DAYS", "ALL");
            }
            this.rbcs.put(rbcId, newRbc);
        }
        return this.rbcs.get(rbcId);
    }

    public Properties geEmptyRbc() {
        Properties toRet = new Properties();
        String[] monthsStrArr = GlobalFunctions.getMonthsArray();
        for (int i = 0; i < monthsStrArr.length; ++i) {
            toRet.setProperty(monthsStrArr[i], "0");
        }
        toRet.setProperty("NAME", "Unscheduled");
        return toRet;
    }

    private String generate_name(String rbcId) {
        if (rbcId.equals("*=@=*=@=*")) {
            return "RBC_ALL";
        }
        return String.format("RBC_%d", this.rbcCount++);
    }

    private void setDaysValue(Properties newRbc, String targetField, String value) {
        int maxValue;
        int minValue;
        if (targetField.equals("DAYS")) {
            minValue = 1;
            maxValue = 31;
        } else if (targetField.equals("WEEKDAYS")) {
            minValue = 0;
            maxValue = 6;
        } else {
            return;
        }
        value = CronGlobals.value2list(value, minValue, maxValue);
        boolean isAll = true;
        StringBuilder rbcValue = new StringBuilder();
        if (!CronGlobals.value2list("*", minValue, maxValue).equals(value)) {
            for (int i = minValue; i <= maxValue; ++i) {
                if (value.matches(String.format(intInListPatternFormat, i))) {
                    if (rbcValue.length() > 0) {
                        rbcValue.append(',');
                    }
                    rbcValue.append(i);
                    continue;
                }
                isAll = false;
            }
        }
        newRbc.setProperty(targetField, isAll ? "ALL" : rbcValue.toString());
    }

    private void handleMonthDays(Properties newRbc, String monthDays) {
        this.setDaysValue(newRbc, "DAYS", monthDays);
    }

    private void handleWeekDays(Properties newRbc, String weekDays) {
        if ((weekDays = weekDays.toUpperCase()).matches(".*[A-Z].*")) {
            for (int i = 0; i < GlobalFunctions.getWeekDaysArray((String)"sun").length; ++i) {
                weekDays = weekDays.replace(GlobalFunctions.getWeekDaysArray((String)"sun")[i], Integer.toString(i));
            }
        }
        weekDays = weekDays.replace("7", "0");
        weekDays = CronGlobals.value2list(weekDays, 0, 6);
        this.setDaysValue(newRbc, "WEEKDAYS", weekDays);
        int firstDay = this.getStartDay();
        if (!newRbc.getProperty("WEEKDAYS").equals("ALL") && firstDay != 0) {
            String[] weekDaysArr = newRbc.getProperty("WEEKDAYS").split(",");
            StringBuilder offSetValue = new StringBuilder();
            for (int i = 0; i < weekDaysArr.length; ++i) {
                if (offSetValue.length() > 0) {
                    offSetValue.append(',');
                }
                Integer toApp = Integer.valueOf(weekDaysArr[i]);
                toApp = (toApp - firstDay + 7) % 7;
                offSetValue.append(toApp);
            }
            newRbc.setProperty("WEEKDAYS", offSetValue.toString());
        }
    }

    private int getStartDay() {
        String fromConf = RuleManager.instance().getCurrentRules().getStringRule("Cron rules", new String[]{"FIRST_DAY_OF_WEEK"});
        for (int i = 0; i < Globs.WEEKDAYS_ARRAY.length; ++i) {
            if (!fromConf.equals(Globs.WEEKDAYS_ARRAY[i])) continue;
            return i - 1;
        }
        return 0;
    }

    private void handleMonths(Properties newRbc, String months) {
        int i;
        months = months.toUpperCase();
        String[] monthsStrArr = GlobalFunctions.getMonthsArray();
        if (months.matches(".*[A-Z].*")) {
            for (i = 0; i < monthsStrArr.length; ++i) {
                months = months.replace(monthsStrArr[i], Integer.toString(i + 1));
            }
        }
        months = CronGlobals.value2list(months, 1, 12);
        for (i = 0; i < monthsStrArr.length; ++i) {
            newRbc.setProperty(monthsStrArr[i], months.matches(String.format(intInListPatternFormat, i + 1)) ? "1" : "0");
        }
    }
}

