/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.cron;

import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.exceptions.NoJobsFoundException;
import com.bmc.ctmconvert.cron.CronAssessmentReportReplier;
import com.bmc.ctmconvert.cron.CronDataReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;

public class CronAssessmentReport
extends AbstractAssessmentReport {
    private ArrayList<String> descriptionTypeLookNodes;
    private String datasourceName;
    private CronAssessmentReportReplier assessmentReportReplier;

    public CronAssessmentReport(String pathName, String descriptionXMLFileName, String optionalFile) {
        super(pathName, descriptionXMLFileName, optionalFile);
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String optionalFile) throws NoJobsFoundException {
        this.descriptionTypeLookNodes = new ArrayList();
        this.datasourceName = Params.instance().getDatasourceName();
        String datasourcePath = Params.instance().getDatasourcePath();
        CronDataReader cronDataReader = new CronDataReader(datasourcePath);
        AssessmentXMLDescriptionReader descriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
        this.assessmentReportReplier = new CronAssessmentReportReplier(descriptionXMLReader, cronDataReader);
        if (this.assessmentReportReplier.getNumberOfJobsMap().isEmpty()) {
            throw new NoJobsFoundException("No Cron job definitions were found by the selected Control-M/Agents");
        }
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.datasourceName);
        for (String name : this.assessmentReportReplier.getAllMachineNames()) {
            root.add(this.assessmentReportReplier.insertMachineToTree(name));
        }
        return root;
    }

    protected String getJobInfo(String messageID) {
        return this.assessmentReportReplier.getEntityDescription(messageID);
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        Iterator<String> machineIt = this.assessmentReportReplier.getAllMachineNames().iterator();
        this.descriptionTypeLookNodes.add(this.datasourceName);
        while (machineIt.hasNext()) {
            String val = machineIt.next();
            this.descriptionTypeLookNodes.add(this.assessmentReportReplier.appendNumOfjobs(val));
            Iterator<String> userIt = this.assessmentReportReplier.getAllUsersForMachine(val).iterator();
            while (userIt.hasNext()) {
                this.descriptionTypeLookNodes.add(this.assessmentReportReplier.removeNumOfNode(userIt.next()));
            }
        }
        return this.descriptionTypeLookNodes;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        return null;
    }

    protected ArrayList<String> getSelectionList(String parentNodeID) {
        return null;
    }

    protected HashMap<String, String> getDescriptionNodes() {
        HashMap<String, String> descriptionHash = new HashMap<String, String>();
        Iterator<String> machineIt = this.assessmentReportReplier.getAllMachineNames().iterator();
        descriptionHash.put(this.datasourceName, this.assessmentReportReplier.getMainSummary());
        while (machineIt.hasNext()) {
            String machineName = machineIt.next();
            descriptionHash.put(machineName, this.assessmentReportReplier.getMachineDescription(machineName));
        }
        return descriptionHash;
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        return null;
    }
}

