/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.cron;

import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.common.CliParams;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.discovery.ManualFilesDiscovery;
import com.bmc.ctmconvert.discovery.OsDataHolder;
import java.util.ArrayList;

public class CliImporterCron
extends CliImporter {
    private String format = "%s_%d";
    private int numberOfArgs = 1;

    public CliImporterCron() {
        this.checkParamsValidiy();
    }

    public FlowGlobals.COMPLETION_MODE doImport(String destinationFolderPath) {
        ArrayList<OsDataHolder> osDataHolderList = new ArrayList<OsDataHolder>();
        for (int i = 1; i <= this.numberOfArgs; ++i) {
            String machineName = CliParams.instance().get(String.format(this.format, "MACHINE_NAME", i));
            String dataFile = CliParams.instance().get(String.format(this.format, "DATA_FILE", i));
            String userName = CliParams.instance().get(String.format(this.format, "USER_NAME", i));
            if (machineName.isEmpty() || dataFile.isEmpty() || userName.isEmpty()) continue;
            osDataHolderList.add(new OsDataHolder(machineName, dataFile, "", userName));
        }
        return ManualFilesDiscovery.staticCopyFilesToDestinationFolder((String)destinationFolderPath, osDataHolderList);
    }

    public void checkParamsValidiy() {
        BaseFieldValidator datasourceValidator = null;
        while (CliParams.instance().containsKey(String.format(this.format, "MACHINE_NAME", this.numberOfArgs)) && CliParams.instance().containsKey(String.format(this.format, "USER_NAME", this.numberOfArgs)) && CliParams.instance().containsKey(String.format(this.format, "DATA_FILE", this.numberOfArgs))) {
            datasourceValidator = new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY);
            if (!datasourceValidator.isValid(CliParams.instance().get(String.format(this.format, "MACHINE_NAME", this.numberOfArgs)))) {
                ProcessAlertsManager.instance().addMessage(String.format(this.format, "MACHINE_NAME", this.numberOfArgs) + ": " + datasourceValidator.getErrorMessage());
            }
            if (!datasourceValidator.isValid(CliParams.instance().get(String.format(this.format, "USER_NAME", this.numberOfArgs)))) {
                ProcessAlertsManager.instance().addMessage(String.format(this.format, "USER_NAME", this.numberOfArgs) + ": " + datasourceValidator.getErrorMessage());
            }
            if (!(datasourceValidator = new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH)).isValid(CliParams.instance().get(String.format(this.format, "DATA_FILE", this.numberOfArgs)))) {
                ProcessAlertsManager.instance().addMessage(String.format(this.format, "DATA_FILE", this.numberOfArgs) + ": " + datasourceValidator.getErrorMessage());
            }
            ++this.numberOfArgs;
        }
        --this.numberOfArgs;
        ProcessAlertsManager.instance().exitIfMessages(1);
    }
}

