/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.builderutils;

import com.bmc.ctmconvert.InputStreamNamePair;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class BuilderUtils {
    private FileSystem fileSystem;

    public BuilderUtils(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public List<InputStreamNamePair> parseInputData(JSONArray projectDataFilesPathArray) {
        ArrayList<InputStreamNamePair> dataInputStreamList = new ArrayList<InputStreamNamePair>();
        projectDataFilesPathArray.forEach(arrayItem -> {
            String filePathString = arrayItem.toString();
            try {
                Path fixedPath = BuilderUtils.getFileFromPath(filePathString);
                Path path = this.fileSystem.getPath(fixedPath.toString(), new String[0]);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    dataInputStreamList.addAll(BuilderUtils.getFilesInputStreamNamePairFromDirectory(path));
                } else {
                    InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                    dataInputStreamList.add(new InputStreamNamePair(path.getFileName().toString(), inputStream));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return dataInputStreamList;
    }

    public static Path getFileFromPath(String fullPathStringToFile) {
        return Paths.get(fullPathStringToFile, new String[0]);
    }

    public static List<InputStreamNamePair> getFilesInputStreamNamePairFromDirectory(Path directoryPath) throws IOException {
        ArrayList<InputStreamNamePair> inputStreams = new ArrayList<InputStreamNamePair>();
        try (Stream<Path> paths = Files.list(directoryPath);){
            paths.forEach(path -> {
                try {
                    InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                    inputStreams.add(new InputStreamNamePair(path.toFile().getName(), inputStream));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return inputStreams;
    }

    public static JSONObject toJson(HttpServletRequest request) throws IOException {
        ServletInputStream requestAsInputStream = request.getInputStream();
        String requestBodyJsonString = IOUtils.toString((InputStream)requestAsInputStream);
        JSONObject requestJson = new JSONObject(requestBodyJsonString);
        return requestJson;
    }
}

