/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rules;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.rules.Rule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RulesContainer
extends Rule {
    static final String XML_TAG_RULE_CONTAINER = "RULE_CONTAINER";
    ArrayList<Rule> ruleList;

    public RulesContainer(String name) {
        super(name);
        this.ruleList = new ArrayList();
    }

    public RulesContainer(RulesContainer rule) {
        super(rule.name);
        this.init();
        for (Rule child : rule.ruleList) {
            this.ruleList.add(child.copy());
        }
    }

    private void init() {
        this.ruleList = new ArrayList();
    }

    public RulesContainer(RulesContainer metaDataRule, XmlElement ruleElement) {
        if (ruleElement == null || metaDataRule == null) {
            return;
        }
        String ruleName = ruleElement.getAttribute("NAME");
        if (ruleName.isEmpty()) {
            this.ruleList = null;
            return;
        }
        this.name = ruleName;
        this.init();
        List<XmlElement> rulesElements = ruleElement.getDirectchildsElementbyName("RULE", XML_TAG_RULE_CONTAINER);
        for (XmlElement childElement : rulesElements) {
            Rule newRule = null;
            if (!metaDataRule.hasRule(Rule.getRuleName(childElement))) continue;
            Rule childMetaDataRule = metaDataRule.getRule(Rule.getRuleName(childElement));
            if (childElement.getTagName().equals("RULE")) {
                newRule = new Rule(childMetaDataRule, childElement);
            } else if (childElement.getTagName().equals(XML_TAG_RULE_CONTAINER) && childMetaDataRule instanceof RulesContainer) {
                newRule = new RulesContainer((RulesContainer)childMetaDataRule, childElement);
            }
            if (newRule == null || newRule.isEmpty()) continue;
            this.add(newRule);
        }
    }

    @Override
    public Rule copy() {
        return new RulesContainer(this);
    }

    public Rule getRule(String ruleName) {
        for (Rule rule : this.ruleList) {
            if (!rule.getName().equals(ruleName)) continue;
            return rule;
        }
        return null;
    }

    public boolean hasRule(String ... rulePath) {
        Rule rule = this.getRule(rulePath);
        return rule != null;
    }

    public Rule getRule(String ... rulePath) {
        if (rulePath.length == 0) {
            return null;
        }
        if (rulePath.length == 1) {
            return this.getRule(rulePath[0]);
        }
        Rule child = this.getRule(rulePath[0]);
        if (!(child instanceof RulesContainer)) {
            return null;
        }
        return ((RulesContainer)child).getRule(Arrays.copyOfRange(rulePath, 1, rulePath.length));
    }

    public void add(Rule childRule) {
        if (childRule == null) {
            return;
        }
        this.ruleList.add(childRule);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("name : ").append(this.name).append("\t");
        builder.append("type : ").append((Object)this.getDataType()).append("\n");
        builder.append("___________________________________").append("\n");
        for (Rule rule : this.ruleList) {
            builder.append(rule).append("\n");
        }
        builder.append("\n");
        return builder.toString();
    }

    @Override
    public Element toXmlElement(Document doc) {
        Element ruleElement = doc.createElement(XML_TAG_RULE_CONTAINER);
        if (this.isEmpty()) {
            return null;
        }
        ruleElement.setAttribute("NAME", this.getName());
        for (Rule item : this.ruleList) {
            Element itemElement = item.toXmlElement(doc);
            if (itemElement == null) continue;
            ruleElement.appendChild(itemElement);
        }
        return ruleElement;
    }

    @Override
    Rule.RuleDataType getDataType() {
        return Rule.RuleDataType.RULES_CONTAINER;
    }

    public ArrayList<Rule> getContent() {
        return this.ruleList;
    }
}

