/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rules;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.util.regex.Pattern;

public class NameManipulator {
    private static final int jobnameMaxLenth = 64;
    private static int uniqueNumber = 0;
    private boolean forceUniqueness;
    private RulesDataSet rules = RuleManager.instance().getCurrentRules();
    static final Pattern metaCharsPattern = Pattern.compile("[\\.\\\\+\\[^\\]$\\(\\)\\{\\}=!<>|:]");
    private static final String RULES_GROUP_NAME_MANIPULATE_NAME = "MANIPULATE_NAME";
    public static final String FORCE_UNIQUENESS = "FORCE_UNIQUENESS";
    public static final String TRUNCATE_HEAD = "TRUNCATE_HEAD";
    public static final String TRUNCATION_SIGN = "TRUNCATION_SIGN";
    public static final String UNIQUENESS_SEPARATOR = "UNIQUENESS_SEPARATOR";
    public static final String CONVERT_UNAUTOMATED = "CONVERT_UNAUTOMATED";
    private static final String TRUNCATE_DIRECTION = "TRUNCATION_DIRECTION";

    public String manipulateName(String name, SchedEntity.TYPE entityType) {
        if (!this.isForceUniquence()) {
            switch (entityType) {
                case SMART_TABLE: 
                case SUB_TABLE: {
                    this.setForceUniquence(true);
                    break;
                }
            }
        }
        return this.getManipulateName(name);
    }

    private String getManipulateName(String name) {
        if (this.isForceUniquence()) {
            return this.generateUniqueName(name);
        }
        return this.truncateName(name, 64);
    }

    private String generateUniqueName(String name) {
        String uniquenessSuffix = this.getUniquenceSeprator() + String.valueOf(uniqueNumber++);
        return this.truncateName(name, 64 - uniquenessSuffix.length()) + uniquenessSuffix;
    }

    private String truncateName(String name, int truncationLength) {
        TruncationPosition truncationPosition;
        int beginIndex = 0;
        int endIndex = name.length();
        Object jobNameFormat = "%s";
        String truncationSign = this.getTruncationSign();
        TruncationPosition truncationPosition2 = truncationPosition = this.rules.getStringRule(RULES_GROUP_NAME_MANIPULATE_NAME, TRUNCATE_DIRECTION).equalsIgnoreCase(TRUNCATE_HEAD) ? TruncationPosition.START : TruncationPosition.END;
        if ((truncationLength -= truncationSign.length()) < name.length()) {
            switch (truncationPosition.ordinal()) {
                case 0: {
                    beginIndex = name.length() - truncationLength;
                    endIndex = name.length();
                    jobNameFormat = truncationSign + "%s";
                    break;
                }
                case 1: {
                    beginIndex = 0;
                    endIndex = truncationLength;
                    jobNameFormat = "%s" + truncationSign;
                    break;
                }
            }
        }
        return String.format((String)jobNameFormat, name.substring(beginIndex, endIndex));
    }

    public boolean isForceUniquence() {
        this.forceUniqueness = true;
        if (this.rules.isRuleExist(RULES_GROUP_NAME_MANIPULATE_NAME, FORCE_UNIQUENESS)) {
            this.forceUniqueness = this.rules.getBooleanRule(RULES_GROUP_NAME_MANIPULATE_NAME, FORCE_UNIQUENESS);
        }
        return this.forceUniqueness;
    }

    private void setForceUniquence(boolean b) {
        this.forceUniqueness = b;
    }

    public String getUniquenceSeprator() {
        return this.rules.getStringRule(RULES_GROUP_NAME_MANIPULATE_NAME, UNIQUENESS_SEPARATOR);
    }

    public boolean isTruncateFromHead() {
        TruncationPosition truncationPosition = this.rules.getStringRule(RULES_GROUP_NAME_MANIPULATE_NAME, TRUNCATE_DIRECTION).equalsIgnoreCase(TRUNCATE_HEAD) ? TruncationPosition.START : TruncationPosition.END;
        return truncationPosition.equals((Object)TruncationPosition.START);
    }

    public String getTruncationSign() {
        String truncationSign = this.rules.getStringRule(RULES_GROUP_NAME_MANIPULATE_NAME, TRUNCATION_SIGN);
        if (truncationSign.equals("%")) {
            truncationSign = "%%";
        }
        return truncationSign;
    }

    public static enum TruncationPosition {
        START,
        END;

    }
}

