/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rules;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.Activable;
import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.base.Errorable;
import java.util.ArrayList;

public abstract class ChangingComponentData
implements Activable,
DataRetrievable,
Errorable {
    Actionable dataChangedAction;
    Errorable errorComponent;
    DataRetrievable tmpComponent;
    String componentName;
    String componentGroupName;
    ArrayList<Activable> tmpAssistingComponents;
    boolean isActive;
    boolean isError;

    public ChangingComponentData(String name, String componentGroupName) {
        this.componentName = name;
        this.componentGroupName = componentGroupName;
        this.tmpAssistingComponents = new ArrayList();
        this.isActive = true;
        this.isError = false;
    }

    @Override
    public void setActive(Boolean b) {
        this.isActive = b;
        if (this.tmpComponent != null) {
            this.tmpComponent.setActive(b);
        }
        for (Activable component : this.tmpAssistingComponents) {
            component.setActive(b);
        }
    }

    @Override
    public void addValueChangedAction(Actionable action) {
        this.dataChangedAction = action;
    }

    public void setTmpComponent(DataRetrievable tmpComponent) {
        this.tmpComponent = tmpComponent;
        this.initTmpComponent();
    }

    private void initTmpComponent() {
        Boolean tmpActive = this.isActive;
        this.setActive(true);
        if (this.getData() != null && this.tmpComponent != null) {
            this.tmpComponent.setData(this.getData());
        }
        this.setActive(tmpActive);
    }

    public void clearTmpAssistingComponentList() {
        this.tmpAssistingComponents = new ArrayList();
    }

    public void addTmpAssistingComponent(Activable component) {
        this.tmpAssistingComponents.add(component);
    }

    @Override
    public void setData(Object obj) {
        if (this.tmpComponent != null) {
            this.tmpComponent.setData(obj);
        }
    }

    public void setErrorComponent(Errorable errorComponent) {
        this.errorComponent = errorComponent;
        this.setError(this.isError, "");
    }

    @Override
    public String getName() {
        return this.componentName;
    }

    @Override
    public String getGroupName() {
        return this.componentGroupName;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    protected void storeValue(Object value) {
        if (this.dataChangedAction != null) {
            this.dataChangedAction.act();
        }
    }

    @Override
    public void setError(Boolean b, String Message) {
        if (this.errorComponent != null) {
            this.errorComponent.setError(b, Message);
        }
    }
}

