/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.ExternalCommand;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.LoadReport;
import com.bmc.cnvvalidation.MappingFileHandler;
import com.csvreader.CsvReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LoadForecastReport
extends LoadReport {
    private static final String BR = System.lineSeparator();
    private String mForecastCSV;
    private final String mOdate;
    private final CsvReader csvReader;
    MappingFileHandler mappingFileHandler = null;

    public LoadForecastReport(String sOdate, ExternalParameters externalParameters) throws IOException, InterruptedException {
        super(externalParameters);
        InputStream inputStream;
        try {
            String mappingFile = "";
            if (externalParameters.getMapCtmToLegacy().equals("YES")) {
                mappingFile = externalParameters.getJobnameMappingFile();
            }
            this.mappingFileHandler = new MappingFileHandler(mappingFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mOdate = sOdate;
        if (externalParameters.getCtmForecastReport() == null) {
            this.mForecastCSV = "workarea\\cnvvforecast_" + this.mOdate + ".csv";
            this.RunForecast(externalParameters.getGuiServer(), externalParameters.getEmUser(), externalParameters.getEmPass());
            inputStream = this.fileExists(this.mForecastCSV) ? Files.newInputStream(Paths.get(this.mForecastCSV, new String[0]), new OpenOption[0]) : InputStream.nullInputStream();
        } else {
            inputStream = externalParameters.getCtmForecastReport().get();
        }
        this.newDate();
        this.br = null;
        this.csvReader = new CsvReader((Reader)new InputStreamReader(inputStream));
        this.csvReader.readHeaders();
        String[] headers = this.csvReader.getHeaders();
        int i = 0;
        for (String header : headers) {
            headers[i++] = header.trim();
        }
        this.csvReader.setHeaders(headers);
    }

    private boolean fileExists(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return false;
        }
        File f = new File(fileName);
        return f.exists() && !f.isDirectory();
    }

    public void RunForecast(String emServer, String emUser, String emPass) throws IOException, InterruptedException, IllegalArgumentException {
        File f;
        String emHome = System.getenv("EM_HOME");
        if (!(emHome != null || (f = new File(emHome = "c:\\Program Files\\BMC Software\\Control-M EM\\Default")).exists() && f.isDirectory() || (f = new File(emHome = "c:\\Program Files\\BMC Software\\Control-M EM 9.0.00\\Default")).exists() && f.isDirectory() || (f = new File(emHome = "c:\\Program Files\\BMC Software\\Control-M EM 8.0.00\\Default")).exists() && f.isDirectory())) {
            throw new IllegalArgumentException("Environment variable EM_HOME not specified. Unable to run Control-M Forecast");
        }
        String fn = this.trimQt(emHome);
        File f2 = new File(fn);
        if (!f2.exists() || !f2.isDirectory()) {
            throw new IllegalArgumentException(fn + " is not valid EM_HOME. Unable to run Control-M Forecast");
        }
        String fullPathFn = "\"%EM_HOME%\\bin\\forecastcli.exe\"".replace("%EM_HOME%", fn);
        f2 = new File(this.trimQt(fullPathFn));
        if (!f2.exists() || !f2.isFile()) {
            throw new IllegalArgumentException("Forecast CLI is not at " + fullPathFn + " Unable to run Control-M Forecast");
        }
        String forecastCmd = fullPathFn + " -u " + emUser + " -p " + emPass + " -s " + emServer + " -odate " + this.mOdate + " -job_info_file " + this.mForecastCSV;
        ExternalCommand extCmd = new ExternalCommand(forecastCmd, "workarea\\forecastError.log");
        System.out.println(BR + "forecastCmd is : " + extCmd.getCommand());
        extCmd.start();
        System.out.println(BR + "Exit Value = " + extCmd.getExitValue());
        if (extCmd.getExitValue() != 0) {
            System.out.println("Exit Errors = " + BR + extCmd.getExitErrors());
            throw new IllegalArgumentException("Unable to run Control-M Forecast : " + extCmd.getExitErrors());
        }
    }

    @Override
    protected CommonJobFH nextJobInternal() {
        String localStartTime = "";
        String localEndTime = "";
        String utcStartTime = "";
        String utcEndTime = "";
        Date cnvDate = null;
        SimpleDateFormat inputFormat = new SimpleDateFormat("HH:mm:ss z");
        SimpleDateFormat outputFormat = this.dateFormatter.timeFormatWithSec;
        String compLevel = this.externalParameters.getForecastCompareLevel();
        try {
            while (this.csvReader.readRecord()) {
                if (compLevel.equals("jobs") && (this.csvReader.get("TASK_TYPE").equals("SMART Table") || this.csvReader.get("TASK_TYPE").startsWith("Sub-Table")) || compLevel.equals("folders") && !this.csvReader.get("TASK_TYPE").equals("SMART Table") && !this.csvReader.get("TASK_TYPE").startsWith("Sub-Table")) continue;
                utcStartTime = this.csvReader.get("START");
                try {
                    if (utcStartTime.equals("---")) {
                        utcStartTime = "12:00:00 GMT+00:00";
                    }
                    cnvDate = inputFormat.parse(utcStartTime);
                    localStartTime = outputFormat.format(cnvDate);
                }
                catch (ParseException e) {
                    localStartTime = "";
                }
                utcEndTime = this.csvReader.get("END");
                try {
                    cnvDate = inputFormat.parse(utcEndTime);
                    localEndTime = outputFormat.format(cnvDate);
                }
                catch (ParseException e) {
                    localEndTime = "";
                }
                return new CommonJobFH(this.mappingFileHandler.getCtmToLegacyMapValue(this.csvReader.get("JOB_MEM_NAME").trim()), "", this.csvReader.get("DATA_CENTER").trim(), this.csvReader.get("PARENT_TABLE").trim(), this.csvReader.get("JOB_MEM_NAME").trim(), this.csvReader.get("RUN_COUNT").trim(), localStartTime, localEndTime, this.mOdate, this.date.toString(), "", "Control-M", "", "");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String trimQt(String swq) {
        int len = swq.length();
        if (len > 2 && swq.startsWith("\"") && swq.endsWith("\"")) {
            return swq.substring(1, len - 1).trim();
        }
        return swq;
    }
}

